/*
 * Decompiled with CFR 0.152.
 */
package magicbees.world.feature;

import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;

public class FeatureOreVein {
    private Block veinBlock;
    private int veinBlockMeta;
    private Block replacesBlock;

    public FeatureOreVein(Block block, Block replacesBlock) {
        this(block, 0, replacesBlock);
    }

    public FeatureOreVein(Block block, int meta, Block replacesBlock) {
        this.veinBlock = block;
        this.veinBlockMeta = meta;
        this.replacesBlock = replacesBlock;
    }

    public void generateVein(World world, Random random, int startX, int startY, int startZ, int maxSpawnCount) {
        int currentX = startX;
        int currentY = startY;
        int currentZ = startZ;
        int spawnAttempts = 0;
        int spawnCount = 0;
        while (spawnCount < maxSpawnCount && spawnAttempts < maxSpawnCount * 2) {
            ++spawnAttempts;
            if (!world.func_72799_c(currentX, currentY, currentZ) && FeatureOreVein.canBlockReplaceAt(world, currentX, currentY, currentZ, this.replacesBlock)) {
                world.func_72832_d(currentX, currentY, currentZ, this.veinBlock.field_71990_ca, this.veinBlockMeta, 2);
                ++spawnCount;
            }
            switch (random.nextInt(6)) {
                case 0: {
                    ++currentY;
                    break;
                }
                case 1: {
                    --currentY;
                    break;
                }
                case 2: {
                    ++currentZ;
                    break;
                }
                case 3: {
                    --currentZ;
                    break;
                }
                case 4: {
                    ++currentX;
                    break;
                }
                case 5: {
                    --currentX;
                }
            }
        }
    }

    private static boolean canBlockReplaceAt(World world, int x, int y, int z, Block block) {
        return Block.field_71973_m[world.func_72798_a(x, y, z)] != null && Block.field_71973_m[world.func_72798_a(x, y, z)].isGenMineableReplaceable(world, x, y, z, block.field_71990_ca);
    }
}

