/*
 * Decompiled with CFR 0.152.
 */
package magicbees.tileentity;

import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.genetics.IIndividual;
import magicbees.bees.BeeManager;
import magicbees.tileentity.TileEntityEffectJar;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class EffectJarHousing
implements IBeeHousing {
    private static EffectJarHousing instance = new EffectJarHousing();
    TileEntityEffectJar jarEntity;

    public static EffectJarHousing getFor(TileEntityEffectJar entity) {
        EffectJarHousing.instance.jarEntity = entity;
        return instance;
    }

    public float getTerritoryModifier(IBeeGenome genome, float currentModifier) {
        return 0.9f;
    }

    public float getMutationModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return 0.0f;
    }

    public float getLifespanModifier(IBeeGenome genome, IBeeGenome mate, float currentModifier) {
        return 0.0f;
    }

    public float getProductionModifier(IBeeGenome genome, float currentModifier) {
        return 0.0f;
    }

    public float getFloweringModifier(IBeeGenome genome, float currentModifier) {
        return 0.0f;
    }

    public int getXCoord() {
        return this.jarEntity.field_70329_l;
    }

    public int getYCoord() {
        return this.jarEntity.field_70330_m;
    }

    public int getZCoord() {
        return this.jarEntity.field_70327_n;
    }

    public boolean isSealed() {
        return true;
    }

    public boolean isSelfLighted() {
        return true;
    }

    public boolean isSunlightSimulated() {
        return true;
    }

    public boolean isHellish() {
        return false;
    }

    public void onQueenChange(ItemStack queen) {
    }

    public void wearOutEquipment(int amount) {
    }

    public void onQueenDeath(IBee queen) {
    }

    public void onPostQueenDeath(IBee queen) {
    }

    public ItemStack getQueen() {
        return this.jarEntity.func_70301_a(1);
    }

    public ItemStack getDrone() {
        return null;
    }

    public void setQueen(ItemStack itemStack) {
        this.jarEntity.func_70299_a(1, itemStack);
    }

    public void setDrone(ItemStack itemstack) {
    }

    public int getBiomeId() {
        return this.jarEntity.field_70331_k.func_72807_a((int)this.getXCoord(), (int)this.getYCoord()).field_76756_M;
    }

    public EnumTemperature getTemperature() {
        EnumTemperature temp = EnumTemperature.NORMAL;
        ItemStack stack = this.jarEntity.func_70301_a(1);
        if (stack != null) {
            IBee queen = BeeManager.beeRoot.getMember(stack);
            temp = queen.getGenome().getPrimary().getTemperature();
        }
        return temp;
    }

    public EnumHumidity getHumidity() {
        EnumHumidity humid = EnumHumidity.NORMAL;
        ItemStack stack = this.jarEntity.func_70301_a(1);
        if (stack != null) {
            IBee queen = BeeManager.beeRoot.getMember(stack);
            humid = queen.getGenome().getPrimary().getHumidity();
        }
        return humid;
    }

    public World getWorld() {
        return this.jarEntity.field_70331_k;
    }

    public String getOwnerName() {
        return this.jarEntity.getOwner();
    }

    public void setErrorState(int state) {
    }

    public int getErrorOrdinal() {
        return 1;
    }

    public boolean canBreed() {
        return false;
    }

    public boolean addProduct(ItemStack product, boolean all) {
        return true;
    }

    public boolean onPollenRetrieved(IBee queen, IIndividual pollen, boolean isHandled) {
        return false;
    }

    public boolean onEggLaid(IBee queen) {
        return false;
    }

    public float getGeneticDecay(IBeeGenome genome, float currentModifier) {
        return 0.0f;
    }
}

