/*
 * Decompiled with CFR 0.152.
 */
package magicbees.main;

import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.Mod;
import cpw.mods.fml.common.SidedProxy;
import cpw.mods.fml.common.event.FMLInitializationEvent;
import cpw.mods.fml.common.event.FMLInterModComms;
import cpw.mods.fml.common.event.FMLPostInitializationEvent;
import cpw.mods.fml.common.event.FMLPreInitializationEvent;
import cpw.mods.fml.common.network.IGuiHandler;
import cpw.mods.fml.common.network.NetworkMod;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.registry.GameRegistry;
import magicbees.bees.BeeManager;
import magicbees.bees.TransmutationEffectController;
import magicbees.client.gui.GUIHandler;
import magicbees.main.CommonProxy;
import magicbees.main.Config;
import magicbees.main.utils.CraftingManager;
import magicbees.main.utils.IMCManager;
import magicbees.main.utils.LocalizationManager;
import magicbees.main.utils.VersionInfo;
import magicbees.main.utils.compat.ArsMagicaHelper;
import magicbees.main.utils.compat.EquivalentExchangeHelper;
import magicbees.main.utils.compat.ExtraBeesHelper;
import magicbees.main.utils.compat.ForestryHelper;
import magicbees.main.utils.compat.RedstoneArsenalHelper;
import magicbees.main.utils.compat.ThaumcraftHelper;
import magicbees.main.utils.compat.ThermalExpansionHelper;
import magicbees.world.WorldGeneratorHandler;

@Mod(modid="MagicBees", name="Magic Bees", useMetadata=true, acceptedMinecraftVersions="1.6.2", version="2.1.13", dependencies="required-after:Forestry;after:Thaumcraft;after:ExtraBees;after:EE3;after:ArsMagica;after:TConstruct;after:Railcraft;after:ThermalExpansion")
@NetworkMod(serverSideRequired=false, clientSideRequired=true)
public class MagicBees {
    @Mod.Instance(value="MagicBees")
    public static MagicBees object;
    @SidedProxy(serverSide="magicbees.main.CommonProxy", clientSide="magicbees.main.ClientProxy")
    public static CommonProxy proxy;
    public GUIHandler guiHandler;
    private String configsPath;
    private Config modConfig;
    private WorldGeneratorHandler worldHandler;

    @Mod.EventHandler
    public void preInit(FMLPreInitializationEvent event) {
        this.configsPath = event.getModConfigurationDirectory().getAbsolutePath();
        this.modConfig = new Config(event.getSuggestedConfigurationFile());
        ForestryHelper.preInit();
        ExtraBeesHelper.preInit();
        ThaumcraftHelper.preInit();
        EquivalentExchangeHelper.preInit();
        ArsMagicaHelper.preInit();
        ThermalExpansionHelper.preInit();
        RedstoneArsenalHelper.preInit();
        this.modConfig.setupBlocks();
        this.modConfig.setupItems();
        LocalizationManager.setupLocalizationInfo();
        new TransmutationEffectController();
    }

    @Mod.EventHandler
    public void init(FMLInitializationEvent event) {
        ForestryHelper.init();
        ExtraBeesHelper.init();
        ThaumcraftHelper.init();
        EquivalentExchangeHelper.init();
        ArsMagicaHelper.init();
        ThermalExpansionHelper.init();
        RedstoneArsenalHelper.init();
        this.worldHandler = new WorldGeneratorHandler();
        GameRegistry.registerWorldGenerator((IWorldGenerator)this.worldHandler);
    }

    @Mod.EventHandler
    public void postInit(FMLPostInitializationEvent event) {
        ForestryHelper.postInit();
        ExtraBeesHelper.postInit();
        ThaumcraftHelper.postInit();
        EquivalentExchangeHelper.postInit();
        ArsMagicaHelper.postInit();
        ThermalExpansionHelper.postInit();
        RedstoneArsenalHelper.postInit();
        this.guiHandler = new GUIHandler();
        NetworkRegistry.instance().registerGuiHandler((Object)this, (IGuiHandler)this.guiHandler);
        proxy.registerRenderers();
        BeeManager.ititializeBees();
        this.modConfig.saveConfigs();
        CraftingManager.setupCrafting();
        CraftingManager.registerLiquidContainers();
        VersionInfo.doVersionCheck();
    }

    @Mod.EventHandler
    public void handleIMCMessage(FMLInterModComms.IMCEvent event) {
        IMCManager.handle(event);
    }

    public static Config getConfig() {
        return MagicBees.object.modConfig;
    }
}

