/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.EnumBeeType;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.core.EnumHumidity;
import forestry.api.core.EnumTemperature;
import forestry.api.core.IIconProvider;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IIndividual;
import forestry.api.genetics.IMutation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import magicbees.bees.BeeClassification;
import magicbees.bees.BeeGenomeManager;
import magicbees.bees.BeeManager;
import magicbees.item.types.CombType;
import magicbees.item.types.DropType;
import magicbees.item.types.NuggetType;
import magicbees.item.types.PollenType;
import magicbees.item.types.ResourceType;
import magicbees.main.Config;
import magicbees.main.utils.LocalizationManager;
import magicbees.main.utils.compat.ArsMagicaHelper;
import magicbees.main.utils.compat.EquivalentExchangeHelper;
import magicbees.main.utils.compat.ForestryHelper;
import magicbees.main.utils.compat.RedstoneArsenalHelper;
import magicbees.main.utils.compat.ThaumcraftHelper;
import magicbees.main.utils.compat.ThermalExpansionHelper;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public enum BeeSpecies implements IAlleleBeeSpecies,
IIconProvider
{
    MYSTICAL("Mystical", "mysticum", (IClassification)BeeClassification.VEILED, 11534263, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false, true),
    SORCEROUS("Sorcerous", "fascinatio", (IClassification)BeeClassification.VEILED, 0xEA9A9A, EnumTemperature.HOT, EnumHumidity.ARID, false, false, true),
    UNUSUAL("Unusual", "inusitatus", (IClassification)BeeClassification.VEILED, 7525217, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false, true),
    ATTUNED("Attuned", "similis", (IClassification)BeeClassification.VEILED, 34472, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false, true),
    ELDRITCH("Eldritch", "prodigiosus", BeeClassification.VEILED, 9270688, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    ESOTERIC("Esoteric", "secretiore", (IClassification)BeeClassification.ARCANE, 4249, 16751968, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    MYSTERIOUS("Mysterious", "mysticus", (IClassification)BeeClassification.ARCANE, 7744450, 16751968, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    ARCANE("Arcane", "arcanus", (IClassification)BeeClassification.ARCANE, 13779679, 16751968, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, true),
    CHARMED("Charmed", "larvatus", (IClassification)BeeClassification.SUPERNATURAL, 4779756, 16751968, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    ENCHANTED("Enchanted", "cantatus", (IClassification)BeeClassification.SUPERNATURAL, 1632038, 16751968, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    SUPERNATURAL("Supernatural", "coeleste", (IClassification)BeeClassification.SUPERNATURAL, 22036, 16751968, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, true),
    ETHEREAL("Ethereal", "diaphanum", (IClassification)BeeClassification.MAGICAL, 0xBA3B3B, 0xEFF8FF, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    WATERY("Watery", "aquatilis", BeeClassification.MAGICAL, 3226718, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    EARTHY("Earthen", "fictili", BeeClassification.MAGICAL, 7897645, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    FIREY("Firey", "ardens", BeeClassification.MAGICAL, 13848857, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    WINDY("Windy", "ventosum", BeeClassification.MAGICAL, 16776634, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    PUPIL("Pupil", "disciplina", BeeClassification.SCHOLARLY, 0xFFFF00, EnumTemperature.NORMAL, EnumHumidity.ARID, false, true),
    SCHOLARLY("Scholarly", "studiosis", BeeClassification.SCHOLARLY, 0x6E0000, EnumTemperature.NORMAL, EnumHumidity.ARID, false, false),
    SAVANT("Savant", "philologus", BeeClassification.SCHOLARLY, 16752706, EnumTemperature.NORMAL, EnumHumidity.ARID, true, false),
    AWARE("Aware", "sensibilis", BeeClassification.MAGICAL, 6198709, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    SPIRIT("Spirit", "larva", BeeClassification.SOUL, 11703883, EnumTemperature.WARM, EnumHumidity.NORMAL, false, true),
    SOUL("Soul", "anima", BeeClassification.SOUL, 8214811, EnumTemperature.HELLISH, EnumHumidity.NORMAL, true, false),
    SKULKING("Skulking", "malevolens", (IClassification)BeeClassification.SKULKING, 5392423, 14766646, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    GHASTLY("Ghastly", "pallens", (IClassification)BeeClassification.SKULKING, 0xCCCCEE, 12552060, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    SPIDERY("Spidery", "araneolus", (IClassification)BeeClassification.SKULKING, 0x888888, 0x222222, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    SMOULDERING("Smouldering", "flagrantia", (IClassification)BeeClassification.SKULKING, 16762695, 15369028, EnumTemperature.HELLISH, EnumHumidity.NORMAL, false, false),
    TIMELY("Timely", "gallifreis", BeeClassification.TIME, 13021062, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    LORDLY("Lordly", "rassilonis", (IClassification)BeeClassification.TIME, 13021062, 9306643, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    DOCTORAL("Doctoral", "medicus qui", (IClassification)BeeClassification.TIME, 14542332, 4943500, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, false),
    INFERNAL("Infernal", "infernales", (IClassification)BeeClassification.ABOMINABLE, 0xFF1C1C, 9834240, EnumTemperature.HELLISH, EnumHumidity.ARID, false, true),
    HATEFUL("Hateful", "odibilis", (IClassification)BeeClassification.ABOMINABLE, 0xDB00DB, 9834240, EnumTemperature.HELLISH, EnumHumidity.ARID, false, false),
    SPITEFUL("Spiteful", "maligna", (IClassification)BeeClassification.ABOMINABLE, 6278144, 9834240, EnumTemperature.HELLISH, EnumHumidity.ARID, true, false),
    WITHERING("Withering", "vietus", (IClassification)BeeClassification.ABOMINABLE, 0x5B5B5B, 9834240, EnumTemperature.HELLISH, EnumHumidity.ARID, true, false),
    OBLIVION("Oblivion", "oblivioni", (IClassification)BeeClassification.EXTRINSIC, 14009317, 0xF696FF, EnumTemperature.COLD, EnumHumidity.NORMAL, false, false),
    NAMELESS("Nameless", "sine nomine", (IClassification)BeeClassification.EXTRINSIC, 9217995, 0xF696FF, EnumTemperature.COLD, EnumHumidity.NORMAL, false, true),
    ABANDONED("Abandoned", "reliquit", (IClassification)BeeClassification.EXTRINSIC, 12962700, 0xF696FF, EnumTemperature.COLD, EnumHumidity.NORMAL, false, true),
    FORLORN("Forlorn", "perditus", (IClassification)BeeClassification.EXTRINSIC, 13346956, 0xF696FF, EnumTemperature.COLD, EnumHumidity.NORMAL, true, false),
    DRACONIC("Draconic", "draconic", (IClassification)BeeClassification.EXTRINSIC, 10442413, 5913442, EnumTemperature.COLD, EnumHumidity.NORMAL, true, false),
    IRON("Iron", "ferrus", (IClassification)BeeClassification.METALLIC, 0x686868, 0xE9E9E9, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    GOLD("Gold", "aurum", (IClassification)BeeClassification.METALLIC, 6834945, 0xFFFF0B, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, false),
    COPPER("Copper", "aercus", (IClassification)BeeClassification.METALLIC, 6834945, 16762906, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    TIN("Tin", "stannum", (IClassification)BeeClassification.METALLIC, 4086125, 10926795, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    SILVER("Silver", "argenteus", (IClassification)BeeClassification.METALLIC, 7634049, 9879492, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    LEAD("Lead", "plumbeus", (IClassification)BeeClassification.METALLIC, 9879492, 9546227, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    ALUMINUM("Aluminum", "aluminium", (IClassification)BeeClassification.METALLIC, 0xEDEDED, 0x767676, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    ARDITE("Ardite", "aurantiaco", (IClassification)BeeClassification.METALLIC, 0x720000, 16752128, EnumTemperature.HOT, EnumHumidity.ARID, false, false),
    COBALT("Cobalt", "caeruleo", (IClassification)BeeClassification.METALLIC, 206431, 5876463, EnumTemperature.HOT, EnumHumidity.ARID, false, false),
    MANYULLYN("Manyullyn", "manahmanah", (IClassification)BeeClassification.METALLIC, 4726125, 12423921, EnumTemperature.HOT, EnumHumidity.ARID, true, false),
    DIAMOND("Diamond", "diamond", (IClassification)BeeClassification.GEM, 2135425, 9303523, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, false),
    EMERALD("Emerald", "prasinus", (IClassification)BeeClassification.GEM, 21248, 1564002, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, false),
    APATITE("Apatite", "apatite", (IClassification)BeeClassification.GEM, 3057644, 7505, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    MUTABLE("Mutable", "mutable", (IClassification)BeeClassification.TRANSMUTING, 14398028, 14734758, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TRANSMUTING("Transmuting", "transmuting", (IClassification)BeeClassification.TRANSMUTING, 14398028, 10670808, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    CRUMBLING("Crumbling", "crumbling", (IClassification)BeeClassification.TRANSMUTING, 14398028, 14394532, EnumTemperature.HOT, EnumHumidity.ARID, false, false),
    INVISIBLE("Invisible", "invisible", (IClassification)BeeClassification.VEILED, 0xFFCCFF, 0xFFFFFF, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TC_AIR("TCAir", "aether", (IClassification)BeeClassification.THAUMIC, 14276150, 0x999999, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, true),
    TC_FIRE("TCFire", "praefervidus", (IClassification)BeeClassification.THAUMIC, 15010571, 0x999999, EnumTemperature.HOT, EnumHumidity.ARID, true, true),
    TC_WATER("TCWater", "umidus", (IClassification)BeeClassification.THAUMIC, 3592153, 0x999999, EnumTemperature.NORMAL, EnumHumidity.DAMP, true, true),
    TC_EARTH("TCEarth", "sordida", (IClassification)BeeClassification.THAUMIC, 20736, 0x999999, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, true),
    TC_ORDER("TCOrder", "ordinatus", (IClassification)BeeClassification.THAUMIC, 11154172, 0x999999, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, true),
    TC_CHAOS("TCChaos", "tenebrarum", (IClassification)BeeClassification.THAUMIC, 0xCCCCCC, 0x999999, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, false),
    TC_VIS("TCVis", "arcanus saecula", (IClassification)BeeClassification.THAUMIC, 19609, 6774481, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TC_TAINT("TCFlux", "arcanus labe", (IClassification)BeeClassification.THAUMIC, 9516906, 6774481, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TC_ATTRACT("TCAttractive", "tractus", (IClassification)BeeClassification.THAUMIC, 9895868, 6774481, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    TC_REJUVENATING("TCRejuvenating", "arcanus vitae", (IClassification)BeeClassification.THAUMIC, 9556185, 6774481, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TC_PURE("TCPure", "arcanus puritatem", (IClassification)BeeClassification.THAUMIC, 11536686, 6774481, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TC_BRAINY("TCBrainy", "cerebrum", (IClassification)BeeClassification.THAUMIC, 8650608, 14766646, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    TC_WISPY("TCWispy", "umbrabilis", (IClassification)BeeClassification.THAUMIC, 10270933, 14766646, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TC_BATTY("TCBatty", "chiroptera", (IClassification)BeeClassification.THAUMIC, 2569485, 14766646, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    TC_CHICKEN("TCChicken", "pullus", (IClassification)BeeClassification.FLESHY, 8209182, 14717022, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    TC_BEEF("TCBeef", "bubulae", (IClassification)BeeClassification.FLESHY, 4203034, 11298643, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    TC_PORK("TCPork", "porcina", (IClassification)BeeClassification.FLESHY, 7494959, 13811603, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    EE_MINIUM("EEMinium", "mutabilis", (IClassification)BeeClassification.ALCHEMICAL, 11274529, 3801867, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    AM_ESSENCE("AMEssence", "essentia", (IClassification)BeeClassification.ESSENTIAL, 8829893, 14919003, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    AM_QUINTESSENCE("AMQuintessence", "cor essentia", (IClassification)BeeClassification.ESSENTIAL, 14918747, 14919003, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, true),
    AM_EARTH("AMEarth", "magica terra", (IClassification)BeeClassification.ESSENTIAL, 11175774, 14919003, EnumTemperature.WARM, EnumHumidity.ARID, false, false),
    AM_AIR("AMAir", "magica aer", (IClassification)BeeClassification.ESSENTIAL, 14019485, 14919003, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    AM_FIRE("AMFire", "magica ignis", (IClassification)BeeClassification.ESSENTIAL, 9651486, 14919003, EnumTemperature.HOT, EnumHumidity.ARID, false, false),
    AM_WATER("AMWater", "magica aqua", (IClassification)BeeClassification.ESSENTIAL, 3898764, 14919003, EnumTemperature.NORMAL, EnumHumidity.DAMP, false, false),
    AM_LIGHTNING("AMLightning", "magica fulgur", (IClassification)BeeClassification.ESSENTIAL, 15462305, 14919003, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    AM_PLANT("AMPlant", "magica herba", (IClassification)BeeClassification.ESSENTIAL, 4830537, 14919003, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    AM_ICE("AMIce", "magica glacium", (IClassification)BeeClassification.ESSENTIAL, 8829638, 14919003, EnumTemperature.COLD, EnumHumidity.NORMAL, false, false),
    AM_ARCANE("AMArcane", "magica arcanum", (IClassification)BeeClassification.ESSENTIAL, 7739469, 14919003, EnumTemperature.NORMAL, EnumHumidity.NORMAL, true, false),
    AM_VORTEX("AMVortex", "gurges", (IClassification)BeeClassification.ESSENTIAL, 7453666, 734632, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, true),
    AM_WIGHT("AMWight", "vectem", (IClassification)BeeClassification.ESSENTIAL, 0xB50000, 4999223, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TE_BLIZZY("TEBlizzy", "blizzard", BeeClassification.ABOMINABLE, 29636, EnumTemperature.COLD, EnumHumidity.NORMAL, false, false),
    TE_GELID("TEGelid", "cyro", BeeClassification.ABOMINABLE, 4894711, EnumTemperature.COLD, EnumHumidity.NORMAL, true, true),
    TE_DANTE("TEDante", "inferno", BeeClassification.ABOMINABLE, 16231498, EnumTemperature.HELLISH, EnumHumidity.ARID, false, false),
    TE_PYRO("TEPyro", "pyromaniac", BeeClassification.ABOMINABLE, 16421644, EnumTemperature.HELLISH, EnumHumidity.ARID, true, true),
    TE_ELECTRUM("TEElectrum", "electrum", BeeClassification.THERMAL, 15398814, EnumTemperature.HOT, EnumHumidity.ARID, false, false),
    TE_PLATINUM("TEPlatinum", "platina", BeeClassification.THERMAL, 10414071, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TE_NICKEL("TENickel", "nickel", BeeClassification.THERMAL, 11848073, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TE_INVAR("TEInvar", "invar", BeeClassification.THERMAL, 13493153, EnumTemperature.HOT, EnumHumidity.ARID, false, false),
    TE_BRONZE("TEBronze", "pyropus", BeeClassification.THERMAL, 11889927, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TE_COAL("TECoal", "carbonis", BeeClassification.THERMAL, 0x2E2D2D, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TE_DESTABILIZED("TEDestabilized", "electric", BeeClassification.THERMAL, 6160899, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TE_LUX("TELux", "lux", BeeClassification.THERMAL, 15858313, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false),
    TE_WINSOME("TEWinsome", "cuniculus", BeeClassification.ADORABLE, 617319, EnumTemperature.COLD, EnumHumidity.NORMAL, false, false),
    TE_ENDEARING("TEEndearing", "cognito", BeeClassification.ADORABLE, 433815, EnumTemperature.COLD, EnumHumidity.NORMAL, true, true),
    RSA_FLUXED("RSAFluxed", "Thermametallic electroflux", BeeClassification.THERMAL, 10356237, EnumTemperature.NORMAL, EnumHumidity.NORMAL, false, false);

    private String binomial;
    private String authority;
    private int primaryColour;
    private int secondaryColour;
    private EnumTemperature temperature;
    private EnumHumidity humidity;
    private boolean hasEffect;
    private boolean isSecret;
    private boolean isCounted;
    private boolean isActive;
    private boolean isNocturnal;
    private IClassification branch;
    private HashMap<ItemStack, Integer> products;
    private HashMap<ItemStack, Integer> specialties;
    private IAllele[] genomeTemplate;
    private String uid;
    private boolean dominant;
    private int complexity;
    @SideOnly(value=Side.CLIENT)
    private Icon[][] icons;
    private static final int defaultBodyColour = 16743462;

    public static void setupBeeSpecies() {
        if (ThaumcraftHelper.isActive()) {
            SCHOLARLY.addSpecialty(Config.miscResources.getStackForType(ResourceType.LORE_FRAGMENT), 2);
            SAVANT.addSpecialty(Config.miscResources.getStackForType(ResourceType.LORE_FRAGMENT), 5);
            TC_AIR.addSpecialty(new ItemStack(Config.tcShard, 1, ThaumcraftHelper.ShardType.AIR.ordinal()), 5);
            TC_FIRE.addSpecialty(new ItemStack(Config.tcShard, 1, ThaumcraftHelper.ShardType.FIRE.ordinal()), 5);
            TC_WATER.addSpecialty(new ItemStack(Config.tcShard, 1, ThaumcraftHelper.ShardType.WATER.ordinal()), 5);
            TC_EARTH.addSpecialty(new ItemStack(Config.tcShard, 1, ThaumcraftHelper.ShardType.EARTH.ordinal()), 5);
            TC_ORDER.addSpecialty(new ItemStack(Config.tcShard, 1, ThaumcraftHelper.ShardType.ORDER.ordinal()), 5);
            TC_CHAOS.addSpecialty(new ItemStack(Config.tcShard, 1, ThaumcraftHelper.ShardType.CHAOS.ordinal()), 5);
            TC_BRAINY.addSpecialty(new ItemStack(Config.tcMiscResource, 1, ThaumcraftHelper.MiscResource.ZOMBIE_BRAIN.ordinal()), 2);
            TC_CHICKEN.addSpecialty(new ItemStack(Config.tcNuggetChicken, 1), 9);
            TC_BEEF.addSpecialty(new ItemStack(Config.tcNuggetBeef, 1), 9);
            TC_PORK.addSpecialty(new ItemStack(Config.tcNuggetPork, 1), 9);
        } else {
            TC_CHAOS.setInactive();
            TC_AIR.setInactive();
            TC_FIRE.setInactive();
            TC_WATER.setInactive();
            TC_EARTH.setInactive();
            TC_ORDER.setInactive();
            TC_VIS.setInactive();
            TC_PURE.setInactive();
            TC_BRAINY.setInactive();
            TC_BATTY.setInactive();
            TC_CHICKEN.setInactive();
            TC_BEEF.setInactive();
            TC_PORK.setInactive();
        }
        TC_WISPY.setInactive();
        TC_TAINT.setInactive();
        TC_ATTRACT.setInactive();
        TC_REJUVENATING.setInactive();
        if (EquivalentExchangeHelper.isActive()) {
            EE_MINIUM.addSpecialty(new ItemStack(Config.eeMinuimShard), 6);
        } else {
            EE_MINIUM.setInactive();
        }
        if (ArsMagicaHelper.isActive()) {
            AM_QUINTESSENCE.addSpecialty(new ItemStack(Config.amItemResource, 1, ArsMagicaHelper.ResourceType.ARCANE_COMPOUND.ordinal()), 5);
            AM_EARTH.addSpecialty(new ItemStack(Config.amEssence, 1, ArsMagicaHelper.EssenceType.EARTH.ordinal()), 7);
            AM_AIR.addSpecialty(new ItemStack(Config.amEssence, 1, ArsMagicaHelper.EssenceType.AIR.ordinal()), 7);
            AM_FIRE.addSpecialty(new ItemStack(Config.amEssence, 1, ArsMagicaHelper.EssenceType.FIRE.ordinal()), 7);
            AM_WATER.addSpecialty(new ItemStack(Config.amEssence, 1, ArsMagicaHelper.EssenceType.WATER.ordinal()), 7);
            AM_LIGHTNING.addSpecialty(new ItemStack(Config.amEssence, 1, ArsMagicaHelper.EssenceType.LIGHTNING.ordinal()), 7);
            AM_PLANT.addSpecialty(new ItemStack(Config.amEssence, 1, ArsMagicaHelper.EssenceType.PLANT.ordinal()), 7);
            AM_ICE.addSpecialty(new ItemStack(Config.amEssence, 1, ArsMagicaHelper.EssenceType.ICE.ordinal()), 7);
            AM_ARCANE.addSpecialty(new ItemStack(Config.amEssence, 1, ArsMagicaHelper.EssenceType.ARCANE.ordinal()), 11);
            AM_VORTEX.addSpecialty(new ItemStack(Config.amEssence, 1, ArsMagicaHelper.EssenceType.EARTH.ordinal()), 15);
            AM_WIGHT.addSpecialty(new ItemStack(Config.amItemResource, 1, ArsMagicaHelper.ResourceType.ARCANE_COMPOUND.ordinal()), 11);
        } else {
            AM_ESSENCE.setInactive();
            AM_QUINTESSENCE.setInactive();
            AM_EARTH.setInactive();
            AM_AIR.setInactive();
            AM_FIRE.setInactive();
            AM_WATER.setInactive();
            AM_LIGHTNING.setInactive();
            AM_PLANT.setInactive();
            AM_ICE.setInactive();
            AM_ARCANE.setInactive();
            AM_VORTEX.setInactive();
            AM_WIGHT.setInactive();
        }
        if (ThermalExpansionHelper.isActive()) {
            TE_BLIZZY.addSpecialty(Config.teDustBlizz, 9);
            TE_GELID.addSpecialty(Config.teDustCryotheum, 9);
            TE_DANTE.addSpecialty(Config.teDustSulfur, 9);
            TE_PYRO.addSpecialty(Config.teDustPyrotheum, 9);
            TE_WINSOME.addSpecialty(Config.teDustPlatinum, 9);
            TE_ENDEARING.addSpecialty(Config.teEnderiumNugget, 9);
        } else {
            TE_BLIZZY.setInactive();
            TE_GELID.setInactive();
            TE_DANTE.setInactive();
            TE_PYRO.setInactive();
            TE_DESTABILIZED.setInactive();
            TE_COAL.setInactive();
            TE_LUX.setInactive();
            TE_WINSOME.setInactive();
            TE_ENDEARING.setInactive();
        }
        if (RedstoneArsenalHelper.isActive()) {
            RSA_FLUXED.addSpecialty(Config.rsaFluxNugget, 9);
        } else {
            RSA_FLUXED.setInactive();
        }
        AlleleManager.alleleRegistry.registerDeprecatedAlleleReplacement("thaumicbees.speciesBlitz", (IAllele)AM_LIGHTNING);
        if (OreDictionary.getOres((String)"ingotCopper").size() <= 0) {
            COPPER.setInactive();
        }
        if (OreDictionary.getOres((String)"ingotTin").size() <= 0) {
            TIN.setInactive();
        }
        if (OreDictionary.getOres((String)"ingotSilver").size() <= 0) {
            SILVER.setInactive();
        }
        if (OreDictionary.getOres((String)"ingotLead").size() <= 0) {
            LEAD.setInactive();
        }
        if (OreDictionary.getOres((String)"ingotNaturalAluminum").size() <= 0) {
            ALUMINUM.setInactive();
        }
        if (OreDictionary.getOres((String)"ingotArdite").size() <= 0) {
            ARDITE.setInactive();
        }
        if (OreDictionary.getOres((String)"ingotCobalt").size() <= 0) {
            COBALT.setInactive();
        }
        if (OreDictionary.getOres((String)"ingotManyullyn").size() <= 0) {
            MANYULLYN.setInactive();
        }
        MYSTICAL.addProduct(Config.combs.getStackForType(CombType.MUNDANE), 15).setGenome(BeeGenomeManager.getTemplateMystical()).register();
        SORCEROUS.addProduct(Config.combs.getStackForType(CombType.MUNDANE), 15).setGenome(BeeGenomeManager.getTemplateSorcerous()).register();
        UNUSUAL.addProduct(Config.combs.getStackForType(CombType.MUNDANE), 15).setGenome(BeeGenomeManager.getTemplateUnusual()).register();
        ATTUNED.addProduct(Config.combs.getStackForType(CombType.MUNDANE), 15).setGenome(BeeGenomeManager.getTemplateAttuned()).register();
        ELDRITCH.addProduct(Config.combs.getStackForType(CombType.MUNDANE), 15).setGenome(BeeGenomeManager.getTemplateEldritch()).register();
        ESOTERIC.addProduct(Config.combs.getStackForType(CombType.OCCULT), 18).setGenome(BeeGenomeManager.getTemplateEsoteric()).register();
        MYSTERIOUS.addProduct(Config.combs.getStackForType(CombType.OCCULT), 20).setGenome(BeeGenomeManager.getTemplateMysterious()).register();
        ARCANE.addProduct(Config.combs.getStackForType(CombType.OCCULT), 25).addSpecialty(Config.drops.getStackForType(DropType.ENCHANTED, 1), 9).setGenome(BeeGenomeManager.getTemplateArcane()).register();
        CHARMED.addProduct(Config.combs.getStackForType(CombType.OTHERWORLDLY), 18).setGenome(BeeGenomeManager.getTemplateCharmed()).register();
        ENCHANTED.addProduct(Config.combs.getStackForType(CombType.OTHERWORLDLY), 20).setGenome(BeeGenomeManager.getTemplateEnchanted()).register();
        SUPERNATURAL.addProduct(Config.combs.getStackForType(CombType.OTHERWORLDLY), 25).addSpecialty(Config.pollen.getStackForType(PollenType.UNUSUAL), 8).setGenome(BeeGenomeManager.getTemplateSupernatural()).register();
        ETHEREAL.addProduct(Config.combs.getStackForType(CombType.OCCULT), 10).addProduct(Config.combs.getStackForType(CombType.OTHERWORLDLY), 10).setGenome(BeeGenomeManager.getTemplateEthereal()).register();
        WINDY.addProduct(Config.combs.getStackForType(CombType.AIRY), 25).setGenome(BeeGenomeManager.getTemplateWindy()).register();
        FIREY.addProduct(Config.combs.getStackForType(CombType.FIREY), 25).setGenome(BeeGenomeManager.getTemplateFirey()).register();
        EARTHY.addProduct(Config.combs.getStackForType(CombType.EARTHY), 25).setGenome(BeeGenomeManager.getTemplateEarthy()).register();
        WATERY.addProduct(Config.combs.getStackForType(CombType.WATERY), 25).addSpecialty(new ItemStack(Block.field_72036_aT), 2).setGenome(BeeGenomeManager.getTemplateWatery()).register();
        PUPIL.addProduct(Config.combs.getStackForType(CombType.PAPERY), 20).setGenome(BeeGenomeManager.getTemplatePupil()).register();
        SCHOLARLY.addProduct(Config.combs.getStackForType(CombType.PAPERY), 25).setGenome(BeeGenomeManager.getTemplateScholarly()).register();
        SAVANT.addProduct(Config.combs.getStackForType(CombType.PAPERY), 40).setGenome(BeeGenomeManager.getTemplateSavant()).register();
        AWARE.addProduct(Config.combs.getStackForType(CombType.INTELLECT), 18).setGenome(BeeGenomeManager.getTemplateAware()).register();
        SPIRIT.addProduct(Config.combs.getStackForType(CombType.INTELLECT), 22).addSpecialty(Config.combs.getStackForType(CombType.SOUL), 16).setGenome(BeeGenomeManager.getTemplateSpirit()).register();
        SOUL.addProduct(Config.combs.getStackForType(CombType.INTELLECT), 28).addSpecialty(Config.combs.getStackForType(CombType.SOUL), 20).setGenome(BeeGenomeManager.getTemplateSoul()).register();
        SKULKING.addProduct(Config.combs.getStackForType(CombType.FURTIVE), 10).setGenome(BeeGenomeManager.getTemplateSkulking()).register();
        GHASTLY.addProduct(Config.combs.getStackForType(CombType.FURTIVE), 8).addSpecialty(new ItemStack(Item.field_77732_bp), 2).setGenome(BeeGenomeManager.getTemplateGhastly()).register();
        SPIDERY.addProduct(Config.combs.getStackForType(CombType.FURTIVE), 13).addProduct(new ItemStack(Item.field_77683_K), 8).addSpecialty(new ItemStack(Item.field_77728_bu), 8).setGenome(BeeGenomeManager.getTemplateSpidery()).register();
        SMOULDERING.addProduct(Config.combs.getStackForType(CombType.FURTIVE), 10).addProduct(Config.combs.getStackForType(CombType.MOLTEN), 10).addSpecialty(new ItemStack(Item.field_77731_bo), 5).setGenome(BeeGenomeManager.getTemplateSmouldering()).register();
        TIMELY.addProduct(Config.combs.getStackForType(CombType.TEMPORAL), 16).setGenome(BeeGenomeManager.getTemplateTimely()).register();
        LORDLY.addProduct(Config.combs.getStackForType(CombType.TEMPORAL), 19).setGenome(BeeGenomeManager.getTemplateLordly()).register();
        DOCTORAL.addProduct(Config.combs.getStackForType(CombType.TEMPORAL), 24).addSpecialty(new ItemStack((Item)Config.jellyBaby), 7).setGenome(BeeGenomeManager.getTemplateDoctoral()).register();
        INFERNAL.addProduct(Config.combs.getStackForType(CombType.MOLTEN), 12).setGenome(BeeGenomeManager.getTemplateInfernal()).register();
        HATEFUL.addProduct(Config.combs.getStackForType(CombType.MOLTEN), 18).setGenome(BeeGenomeManager.getTemplateHateful()).register();
        SPITEFUL.addProduct(Config.combs.getStackForType(CombType.MOLTEN), 24).setGenome(BeeGenomeManager.getTemplateSpiteful()).register();
        WITHERING.addSpecialty(Config.miscResources.getStackForType(ResourceType.SKULL_CHIP), 15).setGenome(BeeGenomeManager.getTemplateWithering()).register();
        OBLIVION.addProduct(Config.combs.getStackForType(CombType.FORGOTTEN), 14).setGenome(BeeGenomeManager.getTemplateOblivion()).register();
        NAMELESS.addProduct(Config.combs.getStackForType(CombType.FORGOTTEN), 19).setGenome(BeeGenomeManager.getTemplateNameless()).register();
        ABANDONED.addProduct(Config.combs.getStackForType(CombType.FORGOTTEN), 24).setGenome(BeeGenomeManager.getTemplateAbandoned()).register();
        FORLORN.addProduct(Config.combs.getStackForType(CombType.FORGOTTEN), 30).setGenome(BeeGenomeManager.getTemplateForlorn()).register();
        DRACONIC.addSpecialty(Config.miscResources.getStackForType(ResourceType.DRAGON_DUST), 15).setGenome(BeeGenomeManager.getTemplateDraconic()).register();
        IRON.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).addSpecialty(Config.nuggets.getStackForType(NuggetType.IRON), 18).setGenome(BeeGenomeManager.getTemplateIron()).register();
        GOLD.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).addSpecialty(new ItemStack(Item.field_77733_bq, 1), 16).setGenome(BeeGenomeManager.getTemplateGold()).register();
        COPPER.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).addSpecialty(Config.nuggets.getStackForType(NuggetType.COPPER), 20).setGenome(BeeGenomeManager.getTemplateCopper()).register();
        TIN.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).addSpecialty(Config.nuggets.getStackForType(NuggetType.TIN), 20).setGenome(BeeGenomeManager.getTemplateTin()).register();
        SILVER.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).addSpecialty(Config.nuggets.getStackForType(NuggetType.SILVER), 16).setGenome(BeeGenomeManager.getTemplateSilver()).register();
        LEAD.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).addSpecialty(Config.nuggets.getStackForType(NuggetType.LEAD), 17).setGenome(BeeGenomeManager.getTemplateLead()).register();
        ALUMINUM.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).setGenome(BeeGenomeManager.getTemplateAluminum());
        if (OreDictionary.getOres((String)"nuggetAluminum").size() > 0) {
            ALUMINUM.addSpecialty((ItemStack)OreDictionary.getOres((String)"nuggetAluminum").get(0), 20);
        } else {
            ALUMINUM.setInactive();
        }
        ALUMINUM.register();
        ARDITE.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).setGenome(BeeGenomeManager.getTemplateArdite());
        if (OreDictionary.getOres((String)"nuggetArdite").size() > 0) {
            ARDITE.addSpecialty((ItemStack)OreDictionary.getOres((String)"nuggetArdite").get(0), 18);
        } else {
            ARDITE.setInactive();
        }
        ARDITE.register();
        COBALT.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).setGenome(BeeGenomeManager.getTemplateCobalt());
        if (OreDictionary.getOres((String)"nuggetCobalt").size() > 0) {
            COBALT.addSpecialty((ItemStack)OreDictionary.getOres((String)"nuggetCobalt").get(0), 18);
        } else {
            COBALT.setInactive();
        }
        COBALT.register();
        MANYULLYN.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).setGenome(BeeGenomeManager.getTemplateManyullyn());
        if (OreDictionary.getOres((String)"nuggetManyullyn").size() > 0) {
            MANYULLYN.addSpecialty((ItemStack)OreDictionary.getOres((String)"nuggetManyullyn").get(0), 16);
        } else {
            MANYULLYN.setInactive();
        }
        MANYULLYN.register();
        DIAMOND.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).addSpecialty(Config.nuggets.getStackForType(NuggetType.DIAMOND), 6).setGenome(BeeGenomeManager.getTemplateDiamond()).register();
        EMERALD.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).addSpecialty(Config.nuggets.getStackForType(NuggetType.EMERALD), 4).setGenome(BeeGenomeManager.getTemplateEmerald()).register();
        APATITE.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).addSpecialty(Config.nuggets.getStackForType(NuggetType.APATITE), 10).setGenome(BeeGenomeManager.getTemplateApatite()).register();
        MUTABLE.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.PARCHED.ordinal()), 30).addProduct(Config.combs.getStackForType(CombType.TRANSMUTED), 10).setGenome(BeeGenomeManager.getTemplateMutable()).register();
        TRANSMUTING.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.PARCHED.ordinal()), 10).addProduct(Config.combs.getStackForType(CombType.TRANSMUTED), 30).addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.SILKY.ordinal()), 5).addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.SIMMERING.ordinal()), 5).setGenome(BeeGenomeManager.getTemplateTransmuting()).register();
        CRUMBLING.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.PARCHED.ordinal()), 10).addProduct(Config.combs.getStackForType(CombType.TRANSMUTED), 30).addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.POWDERY.ordinal()), 10).addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.COCOA.ordinal()), 15).setGenome(BeeGenomeManager.getTemplateCrumbling()).register();
        INVISIBLE.addProduct(Config.combs.getStackForType(CombType.MUNDANE), 35).setGenome(BeeGenomeManager.getTemplateInvisible()).register();
        TC_AIR.addProduct(Config.combs.getStackForType(CombType.AIRY), 20).setGenome(BeeGenomeManager.getTemplateTCAir()).register();
        TC_FIRE.addProduct(Config.combs.getStackForType(CombType.FIREY), 20).setGenome(BeeGenomeManager.getTemplateTCFire()).register();
        TC_WATER.addProduct(Config.combs.getStackForType(CombType.WATERY), 20).setGenome(BeeGenomeManager.getTemplateTCWater()).register();
        TC_EARTH.addProduct(Config.combs.getStackForType(CombType.EARTHY), 20).setGenome(BeeGenomeManager.getTemplateTCEarth()).register();
        TC_ORDER.addProduct(Config.combs.getStackForType(CombType.TC_ORDER), 20).setGenome(BeeGenomeManager.getTemplateTCMagic()).register();
        TC_CHAOS.addProduct(Config.combs.getStackForType(CombType.TC_CHAOS), 20).setGenome(BeeGenomeManager.getTemplateTCStark()).register();
        TC_VIS.addProduct(Config.combs.getStackForType(CombType.INTELLECT), 10).setGenome(BeeGenomeManager.getTemplateTCVis()).register();
        TC_TAINT.addProduct(Config.combs.getStackForType(CombType.INTELLECT), 18).setGenome(BeeGenomeManager.getTemplateTCFlux()).register();
        TC_ATTRACT.addProduct(Config.combs.getStackForType(CombType.INTELLECT), 14).setGenome(BeeGenomeManager.getTemplateTCAttract()).register();
        TC_PURE.addProduct(Config.combs.getStackForType(CombType.INTELLECT), 16).setGenome(BeeGenomeManager.getTemplateTCPure()).register();
        TC_REJUVENATING.addProduct(Config.combs.getStackForType(CombType.INTELLECT), 18).setGenome(BeeGenomeManager.getTemplateTCRejuvinating()).register();
        TC_BRAINY.addProduct(Config.combs.getStackForType(CombType.FURTIVE), 10).addProduct(new ItemStack(Item.field_77737_bm), 6).setGenome(BeeGenomeManager.getTemplateTCBrainy()).register();
        TC_BATTY.addProduct(Config.combs.getStackForType(CombType.FURTIVE), 10).addSpecialty(new ItemStack(Item.field_77677_M), 4).setGenome(BeeGenomeManager.getTemplateTCBatty()).register();
        TC_WISPY.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.SILKY.ordinal()), 22).addSpecialty(new ItemStack(Config.fCraftingResource, 1, ForestryHelper.CraftingMaterial.SILK_WISP.ordinal()), 4).setGenome(BeeGenomeManager.getTemplateTCWispy()).register();
        TC_CHICKEN.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).setGenome(BeeGenomeManager.getTemplateTCChicken()).register();
        TC_BEEF.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).setGenome(BeeGenomeManager.getTemplateTCBeef()).register();
        TC_PORK.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).setGenome(BeeGenomeManager.getTemplateTCPork()).register();
        EE_MINIUM.addProduct(Config.combs.getStackForType(CombType.OCCULT), 16).setGenome(BeeGenomeManager.getTemplateEEMinium()).register();
        AM_ESSENCE.addProduct(Config.combs.getStackForType(CombType.AM_ESSENCE), 12).setGenome(BeeGenomeManager.getTemplateAMEssence()).register();
        AM_QUINTESSENCE.addProduct(Config.combs.getStackForType(CombType.AM_ESSENCE), 23).setGenome(BeeGenomeManager.getTemplateAMQuintessence()).register();
        AM_EARTH.addProduct(Config.combs.getStackForType(CombType.AM_POTENT), 12).setGenome(BeeGenomeManager.getTemplateAMEarth()).register();
        AM_AIR.addProduct(Config.combs.getStackForType(CombType.AM_POTENT), 12).setGenome(BeeGenomeManager.getTemplateAMAir()).register();
        AM_FIRE.addProduct(Config.combs.getStackForType(CombType.AM_POTENT), 12).setGenome(BeeGenomeManager.getTemplateAMFire()).register();
        AM_WATER.addProduct(Config.combs.getStackForType(CombType.AM_POTENT), 12).setGenome(BeeGenomeManager.getTemplateAMWater()).register();
        AM_LIGHTNING.addProduct(Config.combs.getStackForType(CombType.AM_POTENT), 12).setGenome(BeeGenomeManager.getTemplateAMLightning()).register();
        AM_PLANT.addProduct(Config.combs.getStackForType(CombType.AM_POTENT), 12).setGenome(BeeGenomeManager.getTemplateAMPlant()).register();
        AM_ICE.addProduct(Config.combs.getStackForType(CombType.AM_POTENT), 12).setGenome(BeeGenomeManager.getTemplateAMIce()).register();
        AM_ARCANE.addProduct(Config.combs.getStackForType(CombType.AM_POTENT), 19).setGenome(BeeGenomeManager.getTemplateAMArcane()).register();
        AM_VORTEX.addProduct(Config.combs.getStackForType(CombType.AM_ESSENCE), 10).setGenome(BeeGenomeManager.getTemplateAMVortex()).register();
        AM_WIGHT.addProduct(Config.combs.getStackForType(CombType.SOUL), 30).addProduct(Config.combs.getStackForType(CombType.FURTIVE), 10).setGenome(BeeGenomeManager.getTemplateAMWight()).register();
        if (OreDictionary.getOres((String)"ingotBronze").size() <= 0) {
            TE_BRONZE.setInactive();
        }
        if (OreDictionary.getOres((String)"ingotElectrum").size() <= 0) {
            TE_ELECTRUM.setInactive();
        }
        if (OreDictionary.getOres((String)"ingotPlatinum").size() <= 0) {
            TE_PLATINUM.setInactive();
        }
        if (OreDictionary.getOres((String)"ingotNickel").size() <= 0) {
            TE_NICKEL.setInactive();
        }
        if (OreDictionary.getOres((String)"ingotInvar").size() <= 0) {
            TE_INVAR.setInactive();
        }
        TE_ELECTRUM.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).setGenome(BeeGenomeManager.getTemplateTEElectrum());
        if (OreDictionary.getOres((String)"nuggetElectrum").size() > 0) {
            TE_ELECTRUM.addSpecialty((ItemStack)OreDictionary.getOres((String)"nuggetElectrum").get(0), 18);
        } else {
            TE_ELECTRUM.setInactive();
        }
        TE_ELECTRUM.register();
        TE_PLATINUM.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).setGenome(BeeGenomeManager.getTemplateTEPlatinum());
        if (OreDictionary.getOres((String)"nuggetPlatinum").size() > 0) {
            TE_PLATINUM.addSpecialty((ItemStack)OreDictionary.getOres((String)"nuggetPlatinum").get(0), 18);
        } else {
            TE_PLATINUM.setInactive();
        }
        TE_PLATINUM.register();
        TE_NICKEL.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).setGenome(BeeGenomeManager.getTemplateTENickel());
        if (OreDictionary.getOres((String)"nuggetNickel").size() > 0) {
            TE_NICKEL.addSpecialty((ItemStack)OreDictionary.getOres((String)"nuggetNickel").get(0), 18);
        } else {
            TE_NICKEL.setInactive();
        }
        TE_NICKEL.register();
        TE_INVAR.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).setGenome(BeeGenomeManager.getTemplateTEInvar());
        if (OreDictionary.getOres((String)"nuggetInvar").size() > 0) {
            TE_INVAR.addSpecialty((ItemStack)OreDictionary.getOres((String)"nuggetInvar").get(0), 18);
        } else {
            TE_INVAR.setInactive();
        }
        TE_INVAR.register();
        TE_BRONZE.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).setGenome(BeeGenomeManager.getTemplateTEBronze());
        if (OreDictionary.getOres((String)"nuggetBronze").size() > 0) {
            TE_BRONZE.addSpecialty((ItemStack)OreDictionary.getOres((String)"nuggetBronze").get(0), 18);
        } else {
            TE_BRONZE.setInactive();
        }
        TE_BRONZE.register();
        RSA_FLUXED.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).setGenome(BeeGenomeManager.getTemplateRSAFluxed());
        if (OreDictionary.getOres((String)"nuggetElectrumFlux").size() > 0) {
            RSA_FLUXED.addSpecialty((ItemStack)OreDictionary.getOres((String)"nuggetElectrumFlux").get(0), 18);
        } else {
            RSA_FLUXED.setInactive();
        }
        RSA_FLUXED.register();
        TE_DANTE.addProduct(Config.combs.getStackForType(CombType.FURTIVE), 10).addProduct(Config.combs.getStackForType(CombType.MOLTEN), 10).addSpecialty(new ItemStack(Item.field_77722_bw), 5).setGenome(BeeGenomeManager.getTemplateTEDante()).register();
        TE_PYRO.addProduct(Config.combs.getStackForType(CombType.FURTIVE), 10).addProduct(Config.combs.getStackForType(CombType.MOLTEN), 10).addSpecialty(new ItemStack(Item.field_77722_bw), 5).setGenome(BeeGenomeManager.getTemplateTEPyro()).register();
        TE_DESTABILIZED.addProduct(Config.combs.getStackForType(CombType.TE_DESTABILIZED), 10).addProduct(Config.combs.getStackForType(CombType.OCCULT), 10).addSpecialty(new ItemStack(Item.field_77767_aC), 5).setGenome(BeeGenomeManager.getTemplateTEDestabilized()).register();
        TE_LUX.addProduct(Config.combs.getStackForType(CombType.TE_LUX), 10).addProduct(Config.combs.getStackForType(CombType.OCCULT), 10).addSpecialty(new ItemStack(Item.field_77751_aT), 5).setGenome(BeeGenomeManager.getTemplateTELux()).register();
        TE_WINSOME.addProduct(Config.combs.getStackForType(CombType.FURTIVE), 10).addProduct(Config.combs.getStackForType(CombType.TE_ENDEARING), 5).addSpecialty(new ItemStack(Item.field_77730_bn), 5).setGenome(BeeGenomeManager.getTemplateTEWinsome()).register();
        TE_ENDEARING.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.MYSTERIOUS.ordinal()), 10).addProduct(Config.combs.getStackForType(CombType.TE_ENDEARING), 5).setGenome(BeeGenomeManager.getTemplateTEEndearing()).register();
        TE_COAL.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.HONEY.ordinal()), 10).addProduct(Config.combs.getStackForType(CombType.TE_CARBON), 5).addSpecialty(new ItemStack(Item.field_77705_m), 5).setGenome(BeeGenomeManager.getTemplateTECoal()).register();
        TE_BLIZZY.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.FROZEN.ordinal()), 10).setGenome(BeeGenomeManager.getTemplateTEBlizzy()).register();
        TE_GELID.addProduct(new ItemStack(Config.fBeeComb, 1, ForestryHelper.Comb.FROZEN.ordinal()), 10).setGenome(BeeGenomeManager.getTemplateTEGelid()).register();
    }

    private BeeSpecies(String speciesName, String genusName, IClassification classification, int firstColour, EnumTemperature preferredTemp, EnumHumidity preferredHumidity, boolean hasGlowEffect, boolean isSpeciesDominant) {
        this(speciesName, genusName, classification, firstColour, 16743462, preferredTemp, preferredHumidity, hasGlowEffect, true, true, isSpeciesDominant);
    }

    private BeeSpecies(String speciesName, String genusName, IClassification classification, int firstColour, int secondColour, EnumTemperature preferredTemp, EnumHumidity preferredHumidity, boolean hasGlowEffect, boolean isSpeciesDominant) {
        this(speciesName, genusName, classification, firstColour, secondColour, preferredTemp, preferredHumidity, hasGlowEffect, true, true, isSpeciesDominant);
    }

    private BeeSpecies(String speciesName, String genusName, IClassification classification, int firstColour, int secondColour, EnumTemperature preferredTemp, EnumHumidity preferredHumidity, boolean isSecret, boolean hasGlowEffect, boolean isSpeciesDominant) {
        this(speciesName, genusName, classification, firstColour, secondColour, preferredTemp, preferredHumidity, hasGlowEffect, isSecret, true, isSpeciesDominant);
    }

    private BeeSpecies(String speciesName, String genusName, IClassification classification, int firstColour, EnumTemperature preferredTemp, EnumHumidity preferredHumidity, boolean isSecret, boolean hasGlowEffect, boolean isSpeciesDominant) {
        this(speciesName, genusName, classification, firstColour, 16743462, preferredTemp, preferredHumidity, hasGlowEffect, isSecret, true, isSpeciesDominant);
    }

    private BeeSpecies(String speciesName, String genusName, IClassification classification, int firstColour, int secondColour, EnumTemperature preferredTemp, EnumHumidity preferredHumidity, boolean hasGlowEffect, boolean isSpeciesSecret, boolean isSpeciesCounted, boolean isSpeciesDominant) {
        this.uid = "magicbees.species" + speciesName;
        this.dominant = isSpeciesDominant;
        AlleleManager.alleleRegistry.registerAllele((IAllele)this);
        this.binomial = genusName;
        this.authority = "MysteriousAges";
        this.primaryColour = firstColour;
        this.secondaryColour = secondColour;
        this.temperature = preferredTemp;
        this.humidity = preferredHumidity;
        this.hasEffect = hasGlowEffect;
        this.isSecret = isSpeciesSecret;
        this.isCounted = isSpeciesCounted;
        this.products = new HashMap();
        this.specialties = new HashMap();
        this.branch = classification;
        this.branch.addMemberSpecies((IAlleleSpecies)this);
        this.isActive = true;
        this.isNocturnal = false;
    }

    public BeeSpecies setGenome(IAllele[] genome) {
        this.genomeTemplate = genome;
        return this;
    }

    public IAllele[] getGenome() {
        return this.genomeTemplate;
    }

    public BeeSpecies addProduct(ItemStack produce, int percentChance) {
        this.products.put(produce, percentChance);
        return this;
    }

    public BeeSpecies addSpecialty(ItemStack produce, int percentChance) {
        this.specialties.put(produce, percentChance);
        return this;
    }

    public ItemStack getBeeItem(EnumBeeType beeType) {
        return BeeManager.beeRoot.getMemberStack((IIndividual)BeeManager.beeRoot.getBee(null, BeeManager.beeRoot.templateAsGenome(this.genomeTemplate)), beeType.ordinal());
    }

    public String getName() {
        return LocalizationManager.getLocalizedString(this.getUID());
    }

    public String getDescription() {
        return LocalizationManager.getLocalizedString(this.getUID() + ".description");
    }

    public EnumTemperature getTemperature() {
        return this.temperature;
    }

    public EnumHumidity getHumidity() {
        return this.humidity;
    }

    public boolean hasEffect() {
        return this.hasEffect;
    }

    public BeeSpecies setInactive() {
        this.isActive = false;
        return this;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public boolean isSecret() {
        return this.isSecret;
    }

    public boolean isCounted() {
        return this.isCounted;
    }

    public String getBinomial() {
        return this.binomial;
    }

    public String getAuthority() {
        return this.authority;
    }

    public IClassification getBranch() {
        return this.branch;
    }

    public HashMap getProducts() {
        return this.products;
    }

    public HashMap getSpecialty() {
        return this.specialties;
    }

    public String getUID() {
        return this.uid;
    }

    public boolean isDominant() {
        return this.dominant;
    }

    public IBeeRoot getRoot() {
        return BeeManager.beeRoot;
    }

    public boolean isNocturnal() {
        return this.isNocturnal;
    }

    public boolean isJubilant(IBeeGenome genome, IBeeHousing housing) {
        return true;
    }

    private BeeSpecies register() {
        BeeManager.beeRoot.registerTemplate(this.getGenome());
        if (!this.isActive) {
            AlleleManager.alleleRegistry.blacklistAllele(this.getUID());
        }
        return this;
    }

    public int getIconColour(int renderPass) {
        int value = 0xFFFFFF;
        if (renderPass == 0) {
            value = this.primaryColour;
        } else if (renderPass == 1) {
            value = this.secondaryColour;
        }
        return value;
    }

    @SideOnly(value=Side.CLIENT)
    public IIconProvider getIconProvider() {
        return this;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(EnumBeeType type, int renderPass) {
        return this.icons[type.ordinal()][Math.min(renderPass, 2)];
    }

    public int getComplexity() {
        return 1 + this.getMutationPathLength((IAllele)this, new ArrayList<IAllele>());
    }

    private int getMutationPathLength(IAllele species, ArrayList<IAllele> excludeSpecies) {
        int own = 1;
        int highest = 0;
        excludeSpecies.add(species);
        for (IMutation mutation : this.getRoot().getPaths(species, EnumBeeChromosome.SPECIES.ordinal())) {
            int otherAdvance;
            if (!excludeSpecies.contains(mutation.getAllele0()) && (otherAdvance = this.getMutationPathLength(mutation.getAllele0(), excludeSpecies)) > highest) {
                highest = otherAdvance;
            }
            if (excludeSpecies.contains(mutation.getAllele1()) || (otherAdvance = this.getMutationPathLength(mutation.getAllele1(), excludeSpecies)) <= highest) continue;
            highest = otherAdvance;
        }
        return own + (highest > 0 ? highest : 0);
    }

    public float getResearchSuitability(ItemStack itemStack) {
        float value = 0.0f;
        if (itemStack != null) {
            for (ItemStack itemStack2 : this.products.keySet()) {
                if (!itemStack.func_77969_a(itemStack2)) continue;
                value = 1.0f;
                break;
            }
            if (value <= 0.0f) {
                for (ItemStack itemStack3 : this.specialties.keySet()) {
                    if (!itemStack3.func_77969_a(itemStack)) continue;
                    value = 1.0f;
                    break;
                }
                if (value <= 0.0f && itemStack.field_77993_c != Config.fHoneyDrop.field_77779_bT && itemStack.field_77993_c != Config.fHoneydew.field_77779_bT) {
                    if (itemStack.field_77993_c == Config.fBeeComb.field_77779_bT || itemStack.field_77993_c == Config.combs.field_77779_bT) {
                        value = 4.0f;
                    } else {
                        for (Map.Entry entry : BeeManager.beeRoot.getResearchCatalysts().entrySet()) {
                            if (!OreDictionary.itemMatches((ItemStack)itemStack, (ItemStack)((ItemStack)entry.getKey()), (boolean)false)) continue;
                            value = ((Float)entry.getValue()).floatValue();
                            break;
                        }
                    }
                }
            }
        }
        return value;
    }

    public ItemStack[] getResearchBounty(World world, String researcher, IIndividual individual, int bountyLevel) {
        ItemStack copy;
        Collection resultantMutations;
        System.out.println("Bounty level: " + bountyLevel);
        ArrayList<ItemStack> bounty = new ArrayList<ItemStack>();
        if (world.field_73012_v.nextFloat() < 10.0f / (float)bountyLevel && (resultantMutations = this.getRoot().getCombinations((IAllele)this)).size() > 0) {
            IMutation[] candidates = resultantMutations.toArray(new IMutation[resultantMutations.size()]);
            bounty.add(AlleleManager.alleleRegistry.getMutationNoteStack(researcher, candidates[world.field_73012_v.nextInt(candidates.length)]));
        }
        for (ItemStack product : this.products.keySet()) {
            copy = product.func_77946_l();
            copy.field_77994_a = 1 + world.field_73012_v.nextInt(bountyLevel / 2);
            bounty.add(copy);
        }
        for (ItemStack specialty : this.specialties.keySet()) {
            copy = specialty.func_77946_l();
            copy.field_77994_a = world.field_73012_v.nextInt(bountyLevel / 3);
            if (copy.field_77994_a <= 0) continue;
            bounty.add(copy);
        }
        return bounty.toArray(new ItemStack[bounty.size()]);
    }

    public String getEntityTexture() {
        return "/gfx/forestry/entities/bees/honeyBee.png";
    }

    public void registerIcons(IconRegister itemMap) {
        this.icons = new Icon[EnumBeeType.values().length][3];
        String root = this.getIconPath();
        Icon body1 = itemMap.func_94245_a(root + "body1");
        for (int i = 0; i < EnumBeeType.values().length; ++i) {
            if (EnumBeeType.values()[i] == EnumBeeType.NONE) continue;
            this.icons[i][0] = itemMap.func_94245_a(root + EnumBeeType.values()[i].toString().toLowerCase(Locale.ENGLISH) + ".outline");
            this.icons[i][1] = EnumBeeType.values()[i] != EnumBeeType.LARVAE ? body1 : itemMap.func_94245_a(root + EnumBeeType.values()[i].toString().toLowerCase(Locale.ENGLISH) + ".body");
            this.icons[i][2] = itemMap.func_94245_a(root + EnumBeeType.values()[i].toString().toLowerCase(Locale.ENGLISH) + ".body2");
        }
    }

    private String getIconPath() {
        String value;
        switch (this) {
            case SKULKING: 
            case GHASTLY: 
            case SPIDERY: 
            case SMOULDERING: 
            case TC_BRAINY: 
            case TC_WISPY: 
            case TC_BATTY: 
            case AM_VORTEX: 
            case AM_WIGHT: 
            case TE_BLIZZY: 
            case TE_GELID: 
            case TE_DANTE: 
            case TE_PYRO: {
                value = "magicbees:bees/skulking/";
                break;
            }
            default: {
                value = "Forestry".toLowerCase() + ":bees/default/";
            }
        }
        return value;
    }

    @SideOnly(value=Side.CLIENT)
    public Icon getIcon(short texUID) {
        return this.icons[0][0];
    }
}

