/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import magicbees.bees.AlleleEffect;
import magicbees.bees.EffectData;
import magicbees.bees.TransmutationEffectController;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraft.world.biome.BiomeGenBase;

public class AlleleEffectTransmuting
extends AlleleEffect {
    public AlleleEffectTransmuting(String id, boolean isDominant) {
        super(id, isDominant, 200);
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData == null || !(storedData instanceof EffectData)) {
            storedData = new EffectData(1, 0, 0);
        }
        return storedData;
    }

    @Override
    protected IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        int xCoord = (int)(housing.getTerritoryModifier(genome, 1.0f) * (float)genome.getTerritory()[0]);
        xCoord = housing.getXCoord() + world.field_73012_v.nextInt(xCoord) - xCoord / 2;
        int yCoord = (int)(housing.getTerritoryModifier(genome, 1.0f) * (float)genome.getTerritory()[1]);
        yCoord = housing.getYCoord() + world.field_73012_v.nextInt(yCoord) - yCoord / 2;
        int zCoord = (int)(housing.getTerritoryModifier(genome, 1.0f) * (float)genome.getTerritory()[0]);
        zCoord = housing.getZCoord() + world.field_73012_v.nextInt(zCoord) - zCoord / 2;
        BiomeGenBase biome = world.func_72807_a(xCoord, zCoord);
        TransmutationEffectController.instance.attemptTransmutations(world, biome, new ItemStack(world.func_72798_a(xCoord, yCoord, zCoord), 1, world.func_72805_g(xCoord, yCoord, zCoord)), xCoord, yCoord, zCoord);
        storedData.setInteger(0, 0);
        return storedData;
    }
}

