/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import java.util.List;
import magicbees.bees.AlleleEffect;
import magicbees.bees.EffectData;
import magicbees.item.ItemArmorApiarist;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.World;

public class AlleleEffectSpawnMob
extends AlleleEffect {
    protected boolean aggosOnPlayer = false;
    protected boolean spawnsWhilePlayerNear;
    protected String alternateMob;
    protected String mobName;
    protected String mobSound;
    protected int chanceToSpawn;
    protected int maxMobsInArea;

    public AlleleEffectSpawnMob(String id, boolean isDominant, String mobToSpawn) {
        this(id, isDominant, mobToSpawn, null);
    }

    public AlleleEffectSpawnMob(String id, boolean isDominant, String mobToSpawn, String mobSoundFx) {
        super(id, isDominant, 200);
        this.mobName = mobToSpawn;
        this.chanceToSpawn = 100;
        this.maxMobsInArea = 6;
        this.mobSound = mobSoundFx;
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData == null || !(storedData instanceof EffectData)) {
            storedData = new EffectData(1, 1, 0);
        }
        return storedData;
    }

    @Override
    public IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        if (storedData.getBoolean(0)) {
            World w = housing.getWorld();
            int roll = w.field_73012_v.nextInt(100);
            if (roll <= this.chanceToSpawn) {
                if (this.spawnsWhilePlayerNear) {
                    List<Entity> entities = this.getEntitiesWithinRange(genome, housing);
                    EntityPlayer target = null;
                    for (Entity e : entities) {
                        if (!(e instanceof EntityPlayer)) continue;
                        target = (EntityPlayer)e;
                        if (ItemArmorApiarist.getNumberPiecesWorn(target) < 4) break;
                        target = null;
                    }
                    if (target != null) {
                        storedData.setBoolean(0, !this.spawnMob(genome, target, w, housing, false));
                    } else if (this.alternateMob != null) {
                        storedData.setBoolean(0, !this.spawnMob(genome, null, w, housing, true));
                    }
                } else {
                    storedData.setBoolean(0, !this.spawnMob(genome, null, w, housing, true));
                }
            } else {
                if (this.mobSound != null && w.field_73012_v.nextInt(100) < 35) {
                    int range = genome.getTerritory()[0];
                    double x = (double)housing.getXCoord() + w.field_73012_v.nextDouble() * (double)(range * 2) - (double)range;
                    range = genome.getTerritory()[1];
                    double y = (double)housing.getYCoord() + w.field_73012_v.nextDouble() * (double)(range * 2) - (double)range;
                    range = genome.getTerritory()[2];
                    double z = (double)housing.getZCoord() + w.field_73012_v.nextDouble() * (double)(range * 2) - (double)range;
                    w.func_72908_a(x, y, z, this.mobSound, 0.5f, (w.field_73012_v.nextFloat() - w.field_73012_v.nextFloat()) * 0.2f + 1.0f);
                }
                storedData.setBoolean(0, true);
            }
        }
        return storedData;
    }

    protected boolean spawnMob(IBeeGenome bee, EntityPlayer player, World world, IBeeHousing housing, boolean spawnAlternate) {
        boolean spawnedFlag = false;
        EntityLiving mob = spawnAlternate && this.alternateMob != null ? (EntityLiving)EntityList.func_75620_a((String)this.alternateMob, (World)world) : (EntityLiving)EntityList.func_75620_a((String)this.mobName, (World)world);
        if (mob != null) {
            double[] pos = this.randomMobSpawnCoords(world, bee, housing);
            int entitiesCount = world.func_72872_a(mob.getClass(), AxisAlignedBB.func_72330_a((double)((int)pos[0]), (double)((int)pos[1]), (double)((int)pos[2]), (double)((int)pos[0] + 1), (double)((int)pos[1] + 1), (double)((int)pos[2] + 1)).func_72314_b(8.0, 4.0, 8.0)).size();
            mob.func_70080_a(pos[0], pos[1], pos[2], world.field_73012_v.nextFloat() * 360.0f, 0.0f);
            if (entitiesCount < this.maxMobsInArea && mob.func_70601_bi()) {
                spawnedFlag = world.func_72838_d((Entity)mob);
                if (this.aggosOnPlayer && player != null && ItemArmorApiarist.getNumberPiecesWorn(player) < 4) {
                    mob.func_70624_b((EntityLivingBase)player);
                }
            }
        }
        return spawnedFlag;
    }

    public AlleleEffectSpawnMob setSpawnsOnPlayerNear(String alternateMobToSpawn) {
        this.spawnsWhilePlayerNear = true;
        this.alternateMob = alternateMobToSpawn;
        return this;
    }

    public AlleleEffectSpawnMob setAggrosPlayerOnSpawn() {
        this.aggosOnPlayer = true;
        return this;
    }

    public AlleleEffectSpawnMob setThrottle(int val) {
        this.throttle = val;
        return this;
    }

    public AlleleEffectSpawnMob setChanceToSpawn(int value) {
        this.chanceToSpawn = value;
        return this;
    }

    public AlleleEffectSpawnMob setMaxMobsInSpawnZone(int value) {
        this.maxMobsInArea = value;
        return this;
    }

    protected double[] randomMobSpawnCoords(World world, IBeeGenome bee, IBeeHousing housing) {
        double[] pos = new double[]{(double)housing.getXCoord() + (world.field_73012_v.nextDouble() * (double)((float)bee.getTerritory()[0] * housing.getTerritoryModifier(bee, 1.0f)) - (double)(bee.getTerritory()[0] / 2)), housing.getYCoord() + world.field_73012_v.nextInt(3) - 1, (double)housing.getZCoord() + (world.field_73012_v.nextDouble() * (double)((float)bee.getTerritory()[2] * housing.getTerritoryModifier(bee, 1.0f)) - (double)(bee.getTerritory()[2] / 2))};
        return pos;
    }
}

