/*
 * Decompiled with CFR 0.152.
 */
package magicbees.bees;

import forestry.api.apiculture.IBeeGenome;
import forestry.api.apiculture.IBeeHousing;
import forestry.api.genetics.IEffectData;
import java.util.HashMap;
import magicbees.bees.AlleleEffect;
import magicbees.bees.EffectData;
import net.minecraft.block.Block;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import net.minecraftforge.oredict.OreDictionary;

public class AlleleEffectCrumbling
extends AlleleEffect {
    private static HashMap<ItemStack, ItemStack> crumbleMap = new HashMap();

    public static void addPairToMap(ItemStack source, ItemStack target) {
        boolean add = true;
        for (ItemStack i : crumbleMap.keySet()) {
            if (!OreDictionary.itemMatches((ItemStack)i, (ItemStack)source, (boolean)false)) continue;
            add = false;
            break;
        }
        if (add) {
            crumbleMap.put(source, target);
        }
    }

    public AlleleEffectCrumbling(String id, boolean isDominant) {
        super(id, isDominant, 600);
        AlleleEffectCrumbling.addPairToMap(new ItemStack(Block.field_71981_t), new ItemStack(Block.field_71978_w));
        AlleleEffectCrumbling.addPairToMap(new ItemStack(Block.field_71978_w), new ItemStack(Block.field_72087_ao));
        AlleleEffectCrumbling.addPairToMap(new ItemStack(Block.field_72007_bm, 1, 0), new ItemStack(Block.field_72007_bm, 1, 2));
        AlleleEffectCrumbling.addPairToMap(new ItemStack(Block.field_72007_bm, 1, 2), new ItemStack(Block.field_72007_bm, 1, 1));
        AlleleEffectCrumbling.addPairToMap(new ItemStack(Block.field_82515_ce), new ItemStack(Block.field_82515_ce, 1, 1));
        AlleleEffectCrumbling.addPairToMap(new ItemStack(Block.field_71940_F), new ItemStack(Block.field_71939_E));
    }

    @Override
    public IEffectData validateStorage(IEffectData storedData) {
        if (storedData == null || !(storedData instanceof EffectData)) {
            storedData = new EffectData(1, 0, 0);
        }
        return storedData;
    }

    @Override
    protected IEffectData doEffectThrottled(IBeeGenome genome, IEffectData storedData, IBeeHousing housing) {
        World world = housing.getWorld();
        int xCoord = (int)(housing.getTerritoryModifier(genome, 1.0f) * (float)genome.getTerritory()[0]);
        xCoord = housing.getXCoord() + world.field_73012_v.nextInt(xCoord) - xCoord / 2;
        int yCoord = (int)(housing.getTerritoryModifier(genome, 1.0f) * (float)genome.getTerritory()[1]);
        yCoord = housing.getYCoord() + world.field_73012_v.nextInt(yCoord) - yCoord / 2;
        int zCoord = (int)(housing.getTerritoryModifier(genome, 1.0f) * (float)genome.getTerritory()[0]);
        zCoord = housing.getZCoord() + world.field_73012_v.nextInt(zCoord) - zCoord / 2;
        boolean success = false;
        Block block = Block.field_71973_m[world.func_72798_a(xCoord, yCoord, zCoord)];
        if (block != null) {
            ItemStack source = new ItemStack(block, 1, world.func_72805_g(xCoord, yCoord, zCoord));
            for (ItemStack key : crumbleMap.keySet()) {
                if (!OreDictionary.itemMatches((ItemStack)source, (ItemStack)key, (boolean)false)) continue;
                ItemStack target = crumbleMap.get(key);
                world.func_72832_d(xCoord, yCoord, zCoord, target.field_77993_c, target.func_77960_j(), 2);
                break;
            }
        }
        storedData.setInteger(0, 0);
        return storedData;
    }
}

