/*
 * Decompiled with CFR 0.152.
 */
package ic2.api.energy.prefab;

import cpw.mods.fml.common.FMLCommonHandler;
import ic2.api.energy.EnergyNet;
import ic2.api.energy.event.EnergyTileLoadEvent;
import ic2.api.energy.event.EnergyTileUnloadEvent;
import ic2.api.energy.tile.IEnergySink;
import ic2.api.info.Info;
import ic2.api.item.ElectricItem;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.Event;

public class BasicSink
extends TileEntity
implements IEnergySink {
    public final TileEntity parent;
    protected int capacity;
    protected int tier;
    protected double energyStored;
    protected boolean addedToEnet;

    public BasicSink(TileEntity parent, int capacity, int tier) {
        this.parent = parent;
        this.capacity = capacity;
        this.tier = tier;
    }

    public void func_70316_g() {
        if (!this.addedToEnet) {
            this.onLoaded();
        }
    }

    public void onLoaded() {
        if (!this.addedToEnet && !FMLCommonHandler.instance().getEffectiveSide().isClient() && Info.isIc2Available()) {
            this.field_70331_k = this.parent.field_70331_k;
            this.field_70329_l = this.parent.field_70329_l;
            this.field_70330_m = this.parent.field_70330_m;
            this.field_70327_n = this.parent.field_70327_n;
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileLoadEvent(this));
            this.addedToEnet = true;
        }
    }

    public void func_70313_j() {
        super.func_70313_j();
        this.onChunkUnload();
    }

    public void onChunkUnload() {
        if (this.addedToEnet && Info.isIc2Available()) {
            MinecraftForge.EVENT_BUS.post((Event)new EnergyTileUnloadEvent(this));
            this.addedToEnet = false;
        }
    }

    public void func_70307_a(NBTTagCompound tag) {
        super.func_70307_a(tag);
        NBTTagCompound data = tag.func_74775_l("IC2BasicSink");
        this.energyStored = data.func_74769_h("energy");
    }

    public void func_70310_b(NBTTagCompound tag) {
        try {
            super.func_70310_b(tag);
        }
        catch (RuntimeException e) {
            // empty catch block
        }
        NBTTagCompound data = new NBTTagCompound();
        data.func_74780_a("energy", this.energyStored);
        tag.func_74782_a("IC2BasicSink", (NBTBase)data);
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public int getTier() {
        return this.tier;
    }

    public void setTier(int tier) {
        this.tier = tier;
    }

    public double getEnergyStored() {
        return this.energyStored;
    }

    public void setEnergyStored(double amount) {
        this.energyStored = amount;
    }

    public boolean canUseEnergy(double amount) {
        return this.energyStored >= amount;
    }

    public boolean useEnergy(double amount) {
        if (this.canUseEnergy(amount) && !FMLCommonHandler.instance().getEffectiveSide().isClient()) {
            this.energyStored -= amount;
            return true;
        }
        return false;
    }

    public boolean discharge(ItemStack stack, int limit) {
        if (stack == null || !Info.isIc2Available()) {
            return false;
        }
        int amount = (int)Math.floor((double)this.capacity - this.energyStored);
        if (amount <= 0) {
            return false;
        }
        if (limit > 0 && limit < amount) {
            amount = limit;
        }
        amount = ElectricItem.manager.discharge(stack, amount, this.tier, limit > 0, false);
        this.energyStored += (double)amount;
        return amount > 0;
    }

    @Deprecated
    public void onUpdateEntity() {
        this.func_70316_g();
    }

    @Deprecated
    public void onInvalidate() {
        this.func_70313_j();
    }

    @Deprecated
    public void onOnChunkUnload() {
        this.onChunkUnload();
    }

    @Deprecated
    public void onReadFromNbt(NBTTagCompound tag) {
        this.func_70307_a(tag);
    }

    @Deprecated
    public void onWriteToNbt(NBTTagCompound tag) {
        this.func_70310_b(tag);
    }

    @Override
    public boolean acceptsEnergyFrom(TileEntity emitter, ForgeDirection direction) {
        return true;
    }

    @Override
    public double demandedEnergyUnits() {
        return Math.max(0.0, (double)this.capacity - this.energyStored);
    }

    @Override
    public double injectEnergyUnits(ForgeDirection directionFrom, double amount) {
        this.energyStored += amount;
        return 0.0;
    }

    @Override
    public int getMaxSafeInput() {
        return EnergyNet.instance.getPowerFromTier(this.tier);
    }
}

