/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines;

import binnie.core.machines.Machine;
import binnie.core.machines.component.ComponentRecipe;
import binnie.core.machines.component.IComponentRecipe;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.network.INetwork;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IErrorStateSource;
import binnie.craftgui.minecraft.IMachineInformation;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.ICarpentryWood;
import binnie.extratrees.api.IDesign;
import binnie.extratrees.carpentry.BlockCarpentry;
import binnie.extratrees.carpentry.EnumDesign;
import binnie.extratrees.carpentry.ModuleCarpentry;
import binnie.extratrees.core.ExtraTreeTexture;
import binnie.extratrees.core.ExtraTreesGUID;
import binnie.extratrees.machines.ExtraTreeMachine;
import binnie.extratrees.machines.Validators;
import cpw.mods.fml.relauncher.Side;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public abstract class Woodworker {
    public static int beeswaxSlot = 0;
    public static int wood1Slot = 1;
    public static int wood2Slot = 2;

    public static class ComponentWoodworkerRecipe
    extends ComponentRecipe
    implements IComponentRecipe,
    INetwork.GUI,
    INetwork.CraftGUIAction,
    IErrorStateSource {
        int guiDesignIndex;
        public boolean panel = false;
        private IDesign design = EnumDesign.Diamond;

        public ComponentWoodworkerRecipe(Machine machine, boolean panel) {
            super(machine);
            this.panel = panel;
            this.guiDesignIndex = this.getUniqueProgressBarID();
        }

        @Override
        public void addGUINetworkData(Map<Integer, Integer> data) {
            data.put(this.guiDesignIndex, CarpentryManager.carpentryInterface.getDesignIndex(this.getDesign()));
        }

        @Override
        public void recieveGUINetworkData(int id, int data) {
            if (id == this.guiDesignIndex) {
                this.setDesign(CarpentryManager.carpentryInterface.getDesign(data));
            }
        }

        @Override
        public void readFromNBT(NBTTagCompound nbttagcompound) {
            super.readFromNBT(nbttagcompound);
            this.setDesign(CarpentryManager.carpentryInterface.getDesign(nbttagcompound.func_74762_e("design")));
        }

        @Override
        public void writeToNBT(NBTTagCompound nbttagcompound) {
            super.writeToNBT(nbttagcompound);
            nbttagcompound.func_74768_a("design", CarpentryManager.carpentryInterface.getDesignIndex(this.design));
        }

        @Override
        public boolean isRecipe() {
            return this.getProduct() != null;
        }

        @Override
        public ItemStack getProduct() {
            ItemStack plank1 = this.getUtil().getStack(wood1Slot);
            ItemStack plank2 = this.getUtil().getStack(wood2Slot);
            if (plank1 == null && plank2 == null) {
                return null;
            }
            ICarpentryWood type1 = CarpentryManager.carpentryInterface.getCarpentryWood(plank1);
            ICarpentryWood type2 = CarpentryManager.carpentryInterface.getCarpentryWood(plank2);
            IDesign design = this.getDesign();
            int stackSize = 2;
            if (plank1 == null) {
                type1 = type2;
                stackSize = 1;
            }
            if (plank2 == null) {
                type2 = type1;
                stackSize = 1;
            }
            if (design == EnumDesign.Blank) {
                type2 = type1;
                stackSize = 1;
            }
            ItemStack stack = ModuleCarpentry.getItemStack((BlockCarpentry)(this.panel ? ExtraTrees.blockPanel : ExtraTrees.blockCarpentry), type1, type2, design);
            stack.field_77994_a = stackSize;
            return stack;
        }

        public int getOutputStackSize() {
            return this.panel ? 8 : 2;
        }

        @Override
        public ItemStack doRecipe(boolean takeItem) {
            if (!this.isRecipe()) {
                return null;
            }
            if (this.canWork() != null) {
                return null;
            }
            ItemStack product = this.getProduct();
            if (takeItem) {
                ItemStack a = this.getUtil().decreaseStack(wood1Slot, 1);
                if (a == null) {
                    this.getUtil().decreaseStack(wood2Slot, 1);
                } else if (this.design != EnumDesign.Blank) {
                    this.getUtil().decreaseStack(wood2Slot, 1);
                }
                this.getUtil().decreaseStack(beeswaxSlot, 1);
            }
            return product;
        }

        public IDesign getDesign() {
            return this.design;
        }

        @Override
        public void recieveNBT(Side side, EntityPlayer player, NBTTagCompound nbt) {
            if (nbt.func_74740_e().equals("recipe")) {
                int fit;
                InventoryPlayer playerInv = player.field_71071_by;
                ItemStack recipe = this.doRecipe(false);
                if (recipe == null) {
                    return;
                }
                if (playerInv.func_70445_o() == null) {
                    playerInv.func_70437_b(this.doRecipe(true));
                } else if (playerInv.func_70445_o().func_77969_a(recipe) && ItemStack.func_77970_a((ItemStack)playerInv.func_70445_o(), (ItemStack)recipe) && (fit = recipe.func_77973_b().func_77639_j() - (recipe.field_77994_a + playerInv.func_70445_o().field_77994_a)) >= 0) {
                    ItemStack rec = this.doRecipe(true);
                    rec.field_77994_a += playerInv.func_70445_o().field_77994_a;
                    playerInv.func_70437_b(rec);
                }
                player.field_71070_bA.func_75142_b();
                if (player instanceof EntityPlayerMP) {
                    ((EntityPlayerMP)player).func_71113_k();
                }
            } else if (nbt.func_74740_e().equals("design")) {
                this.setDesign(CarpentryManager.carpentryInterface.getDesign(nbt.func_74765_d("D")));
            }
        }

        private void setDesign(IDesign design) {
            this.design = design;
        }

        @Override
        public ErrorState canWork() {
            if (this.getUtil().isSlotEmpty(beeswaxSlot)) {
                return new ErrorState.NoItem("No Wood Polish for Woodworking", beeswaxSlot);
            }
            return null;
        }

        @Override
        public ErrorState canProgress() {
            return null;
        }
    }

    public static abstract class PackageCarpenter
    extends ExtraTreeMachine.PackageExtraTreeMachine
    implements IMachineInformation {
        boolean panel = false;

        public PackageCarpenter(boolean panel) {
            super(panel ? "panelworker" : "woodworker", panel ? ExtraTreeTexture.panelerTexture : ExtraTreeTexture.carpenterTexture);
            this.panel = panel;
        }

        @Override
        public void createMachine(Machine machine) {
            new ExtraTreeMachine.ComponentExtraTreeGUI(machine, ExtraTreesGUID.Woodworker);
            ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
            inventory.addSlot(beeswaxSlot, "Polish Slot");
            inventory.addSlot(wood1Slot, "Wood Slot");
            inventory.addSlot(wood2Slot, "Wood Slot");
            inventory.getSlot(beeswaxSlot).setValidator(new Validators.SlotValidatorBeeswax());
            inventory.getSlot(wood1Slot).setValidator(new Validators.SlotValidatorPlanks());
            inventory.getSlot(wood2Slot).setValidator(new Validators.SlotValidatorPlanks());
            new ComponentWoodworkerRecipe(machine, this.panel);
        }
    }

    public static class PackagePanelworker
    extends PackageCarpenter {
        public PackagePanelworker() {
            super(true);
        }
    }

    public static class PackageWoodworker
    extends PackageCarpenter {
        public PackageWoodworker() {
            super(false);
        }
    }
}

