/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.machines;

import binnie.core.item.ItemMisc;
import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.inventory.ComponentInventorySlots;
import binnie.core.machines.inventory.ComponentTankContainer;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.SlotValidator;
import binnie.core.machines.inventory.TankValidator;
import binnie.core.machines.power.ComponentPowerReceptor;
import binnie.core.machines.power.ComponentProcess;
import binnie.core.machines.power.ErrorState;
import binnie.core.machines.power.IProcess;
import binnie.craftgui.minecraft.IMachineInformation;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.core.ExtraTreeTexture;
import binnie.extratrees.core.ExtraTreesGUID;
import binnie.extratrees.item.ExtraTreeItems;
import binnie.extratrees.machines.ExtraTreeMachine;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.ShapedRecipes;
import net.minecraft.item.crafting.ShapelessRecipes;
import net.minecraft.tileentity.TileEntity;
import net.minecraftforge.oredict.OreDictionary;
import net.minecraftforge.oredict.ShapelessOreRecipe;

public class Lumbermill {
    public static int slotWood = 0;
    public static int slotPlanks = 1;
    public static int slotBark = 2;
    public static int slotSawdust = 3;
    public static int tankWater = 0;

    public static ItemStack getPlankProduct(ItemStack item) {
        ItemStack stack = null;
        for (Object recipeO : CraftingManager.func_77594_a().func_77592_b()) {
            Object input;
            ShapelessRecipes recipe;
            if (recipeO instanceof ShapelessRecipes) {
                recipe = (ShapelessRecipes)recipeO;
                if (recipe.field_77579_b.size() > 1) continue;
                input = recipe.field_77579_b.get(0);
                if (input instanceof ItemStack && ((ItemStack)input).func_77969_a(item)) {
                    stack = recipe.func_77571_b().func_77946_l();
                }
            }
            if (recipeO instanceof ShapedRecipes) {
                recipe = (ShapedRecipes)recipeO;
                if (recipe.field_77574_d.length > 1) continue;
                input = recipe.field_77574_d[0];
                if (input.func_77969_a(item)) {
                    stack = recipe.func_77571_b().func_77946_l();
                }
            }
            if (!(recipeO instanceof ShapelessOreRecipe) || (recipe = (ShapelessOreRecipe)recipeO).getInput().size() > 1 || !((input = recipe.getInput().get(0)) instanceof ItemStack) || !((ItemStack)input).func_77969_a(item)) continue;
            stack = recipe.func_77571_b().func_77946_l();
        }
        if (stack != null) {
            stack.field_77994_a = (int)((float)stack.field_77994_a * 1.5f);
        }
        return stack;
    }

    public static class SlotValidatorLog
    extends SlotValidator {
        public SlotValidatorLog() {
            super(SlotValidator.IconBlock);
        }

        @Override
        public boolean isValid(ItemStack itemStack) {
            String name = OreDictionary.getOreName((int)OreDictionary.getOreID((ItemStack)itemStack));
            return name.contains("logWood") && Lumbermill.getPlankProduct(itemStack) != null;
        }

        @Override
        public String getTooltip() {
            return "Logs";
        }
    }

    public static class ComponentLumbermillLogic
    extends ComponentProcess
    implements IProcess {
        public ComponentLumbermillLogic(Machine machine) {
            super(machine, 90, 30);
        }

        @Override
        public ErrorState canWork() {
            ItemStack currentPlank;
            if (this.getUtil().isSlotEmpty(slotWood)) {
                return new ErrorState.NoItem("No Wood", slotWood);
            }
            ItemStack result = Lumbermill.getPlankProduct(this.getUtil().getStack(slotWood));
            if (!(this.getUtil().isSlotEmpty(slotPlanks) || result == null || result.func_77969_a(currentPlank = this.getUtil().getStack(slotPlanks)) && result.field_77994_a + currentPlank.field_77994_a <= currentPlank.func_77976_d())) {
                return new ErrorState.NoSpace("No room for new planks", new int[]{slotPlanks});
            }
            return super.canWork();
        }

        @Override
        public ErrorState canProgress() {
            if (!this.getUtil().liquidInTank(tankWater, 5)) {
                return new ErrorState.InsufficientLiquid("Not Enough Water", tankWater);
            }
            return super.canProgress();
        }

        @Override
        protected void onFinishTask() {
            ItemStack result = Lumbermill.getPlankProduct(this.getUtil().getStack(slotWood));
            if (result == null) {
                return;
            }
            this.getUtil().addStack(slotPlanks, result);
            this.getUtil().addStack(slotSawdust, ((ItemMisc)ExtraTrees.itemMisc).getStack(ExtraTreeItems.Sawdust, 1));
            this.getUtil().addStack(slotBark, ((ItemMisc)ExtraTrees.itemMisc).getStack(ExtraTreeItems.Bark, 1));
            this.getUtil().decreaseStack(slotWood, 1);
        }

        @Override
        protected void onTickTask() {
            this.getUtil().drainTank(tankWater, 10);
        }
    }

    public static class PackageLumbermill
    extends ExtraTreeMachine.PackageExtraTreeMachine
    implements IMachineInformation {
        public PackageLumbermill() {
            super("lumbermill", ExtraTreeTexture.lumbermillTexture);
        }

        @Override
        public void createMachine(Machine machine) {
            new ExtraTreeMachine.ComponentExtraTreeGUI(machine, ExtraTreesGUID.Lumbermill);
            ComponentInventorySlots inventory = new ComponentInventorySlots(machine);
            inventory.addSlot(slotWood, InventorySlot.NameInput);
            inventory.getSlot(slotWood).setValidator(new SlotValidatorLog());
            inventory.getSlot(slotWood).forbidExtraction();
            inventory.addSlot(slotPlanks, InventorySlot.NameOutput);
            inventory.addSlot(slotBark, "Byproduct Slot");
            inventory.addSlot(slotSawdust, "Byproduct Slot");
            inventory.getSlot(slotPlanks).setReadOnly();
            inventory.getSlot(slotBark).setReadOnly();
            inventory.getSlot(slotSawdust).setReadOnly();
            ComponentTankContainer tanks = new ComponentTankContainer(machine);
            tanks.addTank(tankWater, "Water Tank", 10000);
            tanks.getTankSlot(tankWater).setValidator(new TankValidator.Basic("water"));
            new ComponentPowerReceptor(machine);
            new ComponentLumbermillLogic(machine);
        }

        @Override
        public TileEntity createTileEntity() {
            return new TileEntityMachine(this);
        }

        @Override
        public void register() {
        }
    }
}

