/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.carpentry;

import binnie.core.block.BlockMetadata;
import binnie.core.block.TileEntityMetadata;
import binnie.extratrees.PluginExtraTrees;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.IDesign;
import binnie.extratrees.api.IToolHammer;
import binnie.extratrees.block.PlankType;
import binnie.extratrees.carpentry.CarpentryBlock;
import binnie.extratrees.carpentry.CarpentryBlockRenderer;
import binnie.extratrees.carpentry.EnumPattern;
import binnie.extratrees.carpentry.ModuleCarpentry;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.event.ForgeSubscribe;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;

public class BlockCarpentry
extends BlockMetadata {
    public static final ForgeDirection[] RENDER_DIRECTIONS = new ForgeDirection[]{ForgeDirection.DOWN, ForgeDirection.UP, ForgeDirection.EAST, ForgeDirection.WEST, ForgeDirection.NORTH, ForgeDirection.SOUTH};

    @ForgeSubscribe
    public void onClick(PlayerInteractEvent event) {
        if (event.action != PlayerInteractEvent.Action.RIGHT_CLICK_BLOCK) {
            return;
        }
        World world = event.entityPlayer.field_70170_p;
        EntityPlayer player = event.entityPlayer;
        int x = event.x;
        int y = event.y;
        int z = event.z;
        if (!(Block.field_71973_m[world.func_72798_a(x, y, z)] instanceof BlockCarpentry)) {
            return;
        }
        BlockCarpentry blockC = (BlockCarpentry)Block.field_71973_m[world.func_72798_a(x, y, z)];
        ItemStack item = player.func_70694_bm();
        if (item == null) {
            return;
        }
        if (!(item.func_77973_b() instanceof IToolHammer)) {
            return;
        }
        if (!((IToolHammer)item.func_77973_b()).isActive(item)) {
            return;
        }
        CarpentryBlock block = blockC.getCarpentryBlock((IBlockAccess)world, x, y, z);
        TileEntityMetadata tile = (TileEntityMetadata)world.func_72796_p(x, y, z);
        block.rotate(event.face, item, player, world, x, y, z);
        tile.setTileMetadata(block.getBlockMetadata());
        world.func_72845_h(x, y, z);
    }

    public BlockCarpentry(int id) {
        super(id, Material.field_76245_d);
        this.func_71849_a(Tabs.tabArboriculture);
        this.func_71864_b("carpentry");
        this.func_71894_b(5.0f);
        this.func_71848_c(2.0f);
        this.func_71884_a(field_71967_e);
    }

    public void func_71879_a(int par1, CreativeTabs par2CreativeTabs, List itemList) {
        for (IDesign design : CarpentryManager.carpentryInterface.getSortedDesigns()) {
            itemList.add(ModuleCarpentry.getItemStack(this, PlankType.ExtraTreePlanks.Apple, PlankType.VanillaPlanks.BIRCH, design));
        }
    }

    public int func_71857_b() {
        return PluginExtraTrees.carpentryID;
    }

    @Override
    public String getBlockName(ItemStack stack) {
        CarpentryBlock block = ModuleCarpentry.getCarpentryBlock(TileEntityMetadata.getItemDamage(stack));
        return block.getDesign().getName() + " Wooden Tile";
    }

    public CarpentryBlock getCarpentryBlock(IBlockAccess world, int x, int y, int z) {
        return ModuleCarpentry.getCarpentryBlock(TileEntityMetadata.getTileMetadata(world, x, y, z));
    }

    @SideOnly(value=Side.CLIENT)
    public int func_71920_b(IBlockAccess world, int x, int y, int z) {
        CarpentryBlock block = this.getCarpentryBlock(world, x, y, z);
        return CarpentryBlockRenderer.isSecondLayer() ? block.getSecondaryColour() : block.getPrimaryColour();
    }

    public int colorMultiplier(int meta) {
        CarpentryBlock block = ModuleCarpentry.getCarpentryBlock(meta);
        return CarpentryBlockRenderer.isSecondLayer() ? block.getSecondaryColour() : block.getPrimaryColour();
    }

    public Icon func_71858_a(int side, int damage) {
        CarpentryBlock block = ModuleCarpentry.getCarpentryBlock(damage);
        Icon icon = CarpentryBlockRenderer.isSecondLayer() ? block.getSecondaryIcon(RENDER_DIRECTIONS[side]) : block.getPrimaryIcon(RENDER_DIRECTIONS[side]);
        return icon;
    }

    @Override
    public void getBlockTooltip(ItemStack stack, List par3List) {
        CarpentryBlock block = ModuleCarpentry.getCarpentryBlock(TileEntityMetadata.getItemDamage(stack));
        if (block.getPrimaryWood() != block.getSecondaryWood()) {
            par3List.add(block.getPrimaryWood().getName() + " and " + block.getSecondaryWood().getName());
        } else {
            par3List.add(block.getPrimaryWood().getName());
        }
    }

    public int primaryColor(int damage) {
        CarpentryBlock block = ModuleCarpentry.getCarpentryBlock(damage);
        return block.getPrimaryColour();
    }

    public int secondaryColor(int damage) {
        CarpentryBlock block = ModuleCarpentry.getCarpentryBlock(damage);
        return block.getSecondaryColour();
    }

    public ItemStack getItemStack(int plank1, int plank2, int design) {
        return TileEntityMetadata.getItemStack(this.field_71990_ca, BlockCarpentry.getMetadata(plank1, plank2, design));
    }

    public static int getMetadata(int plank1, int plank2, int design) {
        return plank1 + (plank2 << 9) + (design << 18);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94332_a(IconRegister register) {
        for (EnumPattern pattern : EnumPattern.values()) {
            pattern.registerIcons(register);
        }
    }

    @Override
    public int getDroppedMeta(int blockMeta, int tileMeta) {
        CarpentryBlock block = ModuleCarpentry.getCarpentryBlock(tileMeta);
        return block.getItemMetadata();
    }
}

