/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.block;

import binnie.core.block.TileEntityMetadata;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.api.ICarpentryWood;
import binnie.extratrees.block.PlankType;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.core.BlockInterface;
import net.minecraft.block.Block;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public interface ILogType {
    public void placeBlock(World var1, int var2, int var3, int var4);

    public ItemStack getItemStack();

    public int getColour();

    public static enum VanillaLog implements ILogType
    {
        Oak(6376752),
        Spruce(2759179),
        Birch(6376752),
        Jungle(5456154);

        int colour;

        private VanillaLog(int colour) {
            this.colour = colour;
        }

        @Override
        public void placeBlock(World world, int x, int y, int z) {
            world.func_72832_d(x, y, z, Block.field_71951_J.field_71990_ca, this.ordinal(), 2);
        }

        @Override
        public ItemStack getItemStack() {
            return new ItemStack(Block.field_71951_J, 1, this.ordinal());
        }

        @Override
        public int getColour() {
            return this.colour;
        }
    }

    public static enum ForestryLog implements ILogType
    {
        LARCH(1, 0, 6376529),
        TEAK(1, 1, 3486249),
        ACACIA(1, 2, 7565906),
        LIME(1, 3, 7431512),
        CHESTNUT(2, 0, 6183484),
        WENGE(2, 1, 6444875),
        BAOBAB(2, 2, 14326376),
        SEQUOIA(2, 3, 11563861),
        KAPOK(3, 0, 5396559),
        EBONY(3, 1, 10453073),
        MAHOGANY(3, 2, 9403501),
        BALSA(3, 3, 8551285),
        WILLOW(4, 0, 10590869),
        WALNUT(4, 1, 9474682),
        GREENHEART(4, 2, 7956050),
        CHERRY(4, 3, 6296064),
        MAHOE(5, 0, 6382152),
        POPLAR(5, 1, 9217671),
        PALM(5, 2, 8941379),
        PAPAYA(5, 3, 9069862),
        PINE(6, 0, 7558729),
        PLUM(6, 1, 11961953),
        MAPLE(6, 2, 9078657),
        CITRUS(6, 3, 5983033);

        int block;
        int metadata;
        int colour;

        private ForestryLog(int blockOffset, int meta, int colour) {
            this.block = blockOffset;
            this.metadata = meta;
            this.colour = colour;
        }

        @Override
        public void placeBlock(World world, int x, int y, int z) {
            int blockID = BlockInterface.getBlock((String)new StringBuilder().append((String)"log").append((int)this.block).toString()).func_77973_b().field_77779_bT;
            world.func_72832_d(x, y, z, blockID, this.metadata, 2);
        }

        @Override
        public ItemStack getItemStack() {
            return new ItemStack(BlockInterface.getBlock((String)new StringBuilder().append((String)"log").append((int)this.block).toString()).func_77973_b().field_77779_bT, 1, this.metadata);
        }

        @Override
        public int getColour() {
            return this.colour;
        }
    }

    public static enum ExtraTreeLog implements ILogType
    {
        Apple("Apple", 0x7B7A7B, PlankType.ExtraTreePlanks.Apple),
        Fig("Fig", 8418135, PlankType.ExtraTreePlanks.Fig),
        Butternut("Butternut", 12037536, PlankType.ExtraTreePlanks.Butternut),
        Cherry("Cherry", 7432272, PlankType.ForestryPlanks.CHERRY),
        Whitebeam("Whitebeam", 7891565, PlankType.ExtraTreePlanks.Whitebeam),
        Rowan("Rowan", 11972763, PlankType.ExtraTreePlanks.Rowan),
        Hemlock("Hemlock", 11379611, PlankType.ExtraTreePlanks.Hemlock),
        Ash("Ash", 0x898982, PlankType.ExtraTreePlanks.Ash),
        Alder("Alder", 13025464, PlankType.ExtraTreePlanks.Alder),
        Beech("Beech", 11702654, PlankType.ExtraTreePlanks.Beech),
        Hawthorn("Hawthorn", 6248261, PlankType.ExtraTreePlanks.Hawthorn),
        Banana("Banana", 8753743),
        Yew("Yew", 13745089, PlankType.ExtraTreePlanks.Yew),
        Cypress("Cypress", 10126467, PlankType.ExtraTreePlanks.Cypress),
        Fir("Fir", 0x828382, PlankType.ExtraTreePlanks.Fir),
        Hazel("Hazel", 11180143, PlankType.ExtraTreePlanks.Hazel),
        Hickory("Hickory", 4076848, PlankType.ExtraTreePlanks.Hickory),
        Elm("Elm", 8684422, PlankType.ExtraTreePlanks.Elm),
        Elder("Elder", 14202996, PlankType.ExtraTreePlanks.Elder),
        Holly("Holly", 11905669, PlankType.ExtraTreePlanks.Holly),
        Hornbeam("Hornbeam", 10719862, PlankType.ExtraTreePlanks.Hornbeam),
        Cedar("Cedar", 11368015, PlankType.ExtraTreePlanks.Cedar),
        Olive("Olive", 8089706, PlankType.ExtraTreePlanks.Olive),
        Sweetgum("Sweetgum", 10592668, PlankType.ExtraTreePlanks.Sweetgum),
        Locust("Locust", 11381948, PlankType.ExtraTreePlanks.Locust),
        Pear("Pear", 11048825, PlankType.ExtraTreePlanks.Pear),
        Maclura("Maclura", 9131828, PlankType.ExtraTreePlanks.Maclura),
        Brazilwood("Brazilwood", 10387560, PlankType.ExtraTreePlanks.Brazilwood),
        Logwood("Logwood", 16376530, PlankType.ExtraTreePlanks.Logwood),
        Rosewood("Rosewood", 0x998666, PlankType.ExtraTreePlanks.Rosewood),
        Purpleheart("Purpleheart", 9671330, PlankType.ExtraTreePlanks.Purpleheart),
        Iroko("Iroko", 6315099, PlankType.ExtraTreePlanks.Iroko),
        Gingko("Gingko", 11382428, PlankType.ExtraTreePlanks.Gingko),
        Eucalyptus("Eucalyptus", 0xEADEDA, PlankType.ExtraTreePlanks.Eucalyptus),
        Eucalyptus2("Eucalyptus", 8814181, PlankType.ExtraTreePlanks.Eucalyptus),
        Box("Box", 11235159, PlankType.ExtraTreePlanks.Box),
        Syzgium("Syzgium", 11235159, PlankType.ExtraTreePlanks.Syzgium),
        Eucalyptus3("Eucalyptus", 7123007, PlankType.ExtraTreePlanks.Eucalyptus),
        Cinnamon("Cinnamon", 8804412, PlankType.VanillaPlanks.JUNGLE),
        PinkIvory("Pink Ivory", 8349012, PlankType.ExtraTreePlanks.PinkIvory);

        String name;
        int color;
        ICarpentryWood plank = null;
        Icon trunk;
        Icon bark;

        private ExtraTreeLog(String name, int color) {
            this.name = name;
            this.color = color;
        }

        private ExtraTreeLog(String name, int color, ICarpentryWood plank) {
            this.name = name;
            this.color = color;
            this.plank = plank;
        }

        public String getName() {
            return this.name;
        }

        public void addRecipe() {
            if (this.plank == null) {
                return;
            }
            ItemStack log = this.getItemStack();
            ItemStack result = this.plank.getPlank();
            result.field_77994_a = 4;
            GameRegistry.addShapelessRecipe((ItemStack)result, (Object[])new Object[]{log});
        }

        @Override
        public void placeBlock(World world, int x, int y, int z) {
            world.func_72832_d(x, y, z, ExtraTrees.blockLog.field_71990_ca, 0, 2);
            if (world.func_72796_p(x, y, z) != null) {
                ((TileEntityMetadata)world.func_72796_p(x, y, z)).setTileMetadata(this.ordinal());
            }
        }

        public Icon getTrunk() {
            return this.trunk;
        }

        public Icon getBark() {
            return this.bark;
        }

        public static void registerIcons(IconRegister register) {
            for (ExtraTreeLog log : ExtraTreeLog.values()) {
                log.trunk = ExtraTrees.proxy.getIcon(register, "logs/" + log.toString().toLowerCase() + "Trunk");
                log.bark = ExtraTrees.proxy.getIcon(register, "logs/" + log.toString().toLowerCase() + "Bark");
            }
        }

        @Override
        public ItemStack getItemStack() {
            return TileEntityMetadata.getItemStack(ExtraTrees.blockLog.field_71990_ca, this.ordinal()).func_77946_l();
        }

        @Override
        public int getColour() {
            return this.color;
        }
    }
}

