/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol.drink;

import binnie.extratrees.alcohol.AlcoholEffect;
import binnie.extratrees.alcohol.Cocktail;
import binnie.extratrees.alcohol.Glassware;
import binnie.extratrees.alcohol.drink.CocktailType;
import binnie.extratrees.alcohol.drink.IDrinkType;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.core.Tabs;
import java.util.List;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumAction;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.world.World;

public class ItemDrink
extends Item {
    static ItemDrink item;

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack par1ItemStack, EntityPlayer par2EntityPlayer, List par3List, boolean par4) {
        IDrinkType type = IDrinkType.getDrinkType(par1ItemStack);
        if (type != null) {
            type.getInformation(par3List);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public int func_82790_a(ItemStack stack, int par2) {
        IDrinkType type = IDrinkType.getDrinkType(stack);
        if (type == null) {
            return 0xFFFFFF;
        }
        return par2 == 0 ? type.getColour() : type.getGlasswareColour();
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int metadata) {
        return 2;
    }

    public Icon getIcon(ItemStack stack, int pass) {
        IDrinkType type = IDrinkType.getDrinkType(stack);
        Glassware glassware = Glassware.Highball;
        if (type != null) {
            glassware = type.getGlassware();
        }
        return pass == 0 ? glassware.contents : glassware.glass;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister par1IconRegister) {
        for (Glassware glassware : Glassware.values()) {
            glassware.registerIcons(par1IconRegister);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int par1, CreativeTabs par2CreativeTabs, List par3List) {
        for (Cocktail cocktail : Cocktail.values()) {
            CocktailType ct = new CocktailType(cocktail.glassware, cocktail);
            par3List.add(ItemDrink.getCocktailItem(ct, 1));
        }
    }

    public static ItemStack getCocktailItem(IDrinkType cocktail, int i) {
        NBTTagCompound nbt = new NBTTagCompound();
        ItemStack stack = new ItemStack((Item)item, i, 0);
        cocktail.writeToNBT(nbt);
        stack.func_77982_d(nbt);
        return stack;
    }

    public String func_77628_j(ItemStack par1ItemStack) {
        IDrinkType type = IDrinkType.getDrinkType(par1ItemStack);
        if (type != null) {
            return type.getName();
        }
        return null;
    }

    public ItemDrink(int id) {
        super(id);
        this.field_77787_bX = true;
        this.func_77637_a(Tabs.tabArboriculture);
        this.func_77625_d(1);
        item = this;
    }

    public EnumAction func_77661_b(ItemStack par1ItemStack) {
        return EnumAction.drink;
    }

    public int func_77626_a(ItemStack par1ItemStack) {
        return 32;
    }

    public ItemStack func_77654_b(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        IDrinkType type = IDrinkType.getDrinkType(par1ItemStack);
        AlcoholEffect.makeDrunk(par3EntityPlayer, 1.0f * ((float)type.getVolume() / 1000.0f));
        par2World.func_72956_a((Entity)par3EntityPlayer, "random.burp", 0.5f, par2World.field_73012_v.nextFloat() * 0.1f + 0.9f);
        return type.getGlassware().get(1);
    }

    public ItemStack func_77659_a(ItemStack par1ItemStack, World par2World, EntityPlayer par3EntityPlayer) {
        par3EntityPlayer.func_71008_a(par1ItemStack, this.func_77626_a(par1ItemStack));
        return par1ItemStack;
    }
}

