/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol;

import binnie.core.BinnieCore;
import binnie.core.liquid.IFluidType;
import binnie.core.liquid.ItemFluidContainer;
import binnie.core.liquid.LiquidManager;
import binnie.core.plugin.IBinnieModule;
import binnie.extratrees.alcohol.Alcohol;
import binnie.extratrees.alcohol.Cocktail;
import binnie.extratrees.alcohol.CocktailRenderer;
import binnie.extratrees.alcohol.ICocktailIngredient;
import binnie.extratrees.alcohol.ItemGlassware;
import binnie.extratrees.alcohol.Juice;
import binnie.extratrees.alcohol.Liqueur;
import binnie.extratrees.alcohol.Spirit;
import binnie.extratrees.alcohol.drink.ItemDrink;
import binnie.extratrees.config.ConfigurationMain;
import binnie.extratrees.machines.Brewery;
import binnie.extratrees.machines.Distillery;
import binnie.extratrees.machines.Press;
import forestry.api.recipes.RecipeManagers;
import java.util.Map;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.oredict.OreDictionary;

public class ModuleAlcohol
implements IBinnieModule {
    @Override
    public void preInit() {
        new ItemGlassware(ConfigurationMain.glasswareID);
        ItemDrink cocktail = new ItemDrink(ConfigurationMain.cocktailID);
        BinnieCore.proxy.registerCustomItemRenderer(cocktail.field_77779_bT, new CocktailRenderer());
        LiquidManager.createLiquids(Juice.values(), ItemFluidContainer.LiquidJuice);
        LiquidManager.createLiquids(Alcohol.values(), ItemFluidContainer.LiquidAlcohol);
        LiquidManager.createLiquids(Spirit.values(), ItemFluidContainer.LiquidSpirit);
        LiquidManager.createLiquids(Liqueur.values(), ItemFluidContainer.LiquidLiqueuer);
        for (Juice juice : Juice.values()) {
            Cocktail.registerIngredient(juice);
        }
        for (Enum enum_ : Alcohol.values()) {
            Cocktail.registerIngredient((ICocktailIngredient)((Object)enum_));
        }
        for (Enum enum_ : Spirit.values()) {
            Cocktail.registerIngredient((ICocktailIngredient)((Object)enum_));
        }
        for (Enum enum_ : Liqueur.values()) {
            Cocktail.registerIngredient((ICocktailIngredient)((Object)enum_));
        }
    }

    @Override
    public void doInit() {
    }

    @Override
    public void postInit() {
        for (Juice juice : Juice.values()) {
            String oreDict = juice.squeezing;
            for (ItemStack stack : OreDictionary.getOres((String)oreDict)) {
                for (Map.Entry entry : RecipeManagers.squeezerManager.getRecipes().entrySet()) {
                    try {
                        ItemStack input = (ItemStack)((Object[])entry.getKey())[0];
                        FluidStack output = (FluidStack)((Object[])entry.getValue())[1];
                        if (!ItemStack.func_77989_b((ItemStack)stack, (ItemStack)input)) continue;
                        int amount = output.amount;
                        if (output.getFluid().getName() == "seedoil") {
                            amount *= 2;
                        }
                        Press.addRecipe(input, juice.get(amount));
                    }
                    catch (Exception e) {}
                }
            }
        }
        for (Enum enum_ : Alcohol.values()) {
            for (String fermentLiquid : ((Alcohol)enum_).fermentationLiquid) {
                FluidStack fluid = LiquidManager.getLiquidStack(fermentLiquid, 5);
                if (fluid == null) continue;
                Brewery.addRecipe(fluid, ((Alcohol)enum_).get(5));
            }
        }
        Brewery.addBeerAndMashRecipes();
        this.addDistillery(Alcohol.Apple, Spirit.AppleBrandy, Spirit.AppleLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Apricot, Spirit.ApricotBrandy, Spirit.ApricotLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Cherry, Spirit.CherryBrandy, Spirit.CherryLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Elderberry, Spirit.ElderberryBrandy, Spirit.ElderberryLiquor, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Barley, Spirit.Whiskey, Spirit.Vodka, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Wheat, Spirit.WheatWhiskey, Spirit.Vodka, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Rye, Spirit.RyeWhiskey, Spirit.Vodka, Spirit.NeutralSpirit);
        this.addDistillery(Alcohol.Corn, Spirit.CornWhiskey, Spirit.Vodka, Spirit.NeutralSpirit);
    }

    private void addDistillery(IFluidType source, IFluidType a, IFluidType b, IFluidType c) {
        Distillery.addRecipe(source.get(5), a.get(3), 0);
        Distillery.addRecipe(source.get(5), b.get(2), 1);
        Distillery.addRecipe(source.get(5), c.get(1), 2);
    }
}

