/*
 * Decompiled with CFR 0.152.
 */
package binnie.extratrees.alcohol;

import binnie.core.liquid.IFluidType;
import binnie.core.liquid.LiquidContainer;
import binnie.core.liquid.LiquidManager;
import binnie.extratrees.alcohol.ICocktailLiquid;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.util.Icon;
import net.minecraftforge.fluids.FluidStack;

public enum MiscFluid implements IFluidType,
ICocktailLiquid
{
    CarbonatedWater("Carbonated Water", "water.carbonated", 0xFFFFFF, (double)0.1f),
    TonicWater("Tonic Water", "water.carbonated", 0xFFFFFF, (double)0.1f),
    Cream("Carbonated Water", "water.carbonated", 0xEAEADE, 2.0),
    GingerAle("Ginger Ale", "gingerAle", 0xFFFFFF, (double)0.6f),
    Coffee("Coffee", "coffee", 5910789, (double)0.3f),
    SugarSyrup("Simple Syrup", "syrup.simple", 16120049, (double)0.1f),
    AgaveNectar("Agave Nectar", "syrup.agave", 13598245, (double)0.7f),
    GrenadineSyrup("Grenadine Syrup", "water.carbonated", 16009573, (double)0.8f);

    String name;
    String ident;
    Icon icon;
    int colour;
    float transparency;

    private MiscFluid(String name, String ident, int colour, double transparency) {
        this.name = name;
        this.ident = ident;
        this.colour = colour;
        this.transparency = (float)transparency;
    }

    public String toString() {
        return this.name;
    }

    @Override
    public boolean canBePlacedInContainer(LiquidContainer container) {
        return true;
    }

    @Override
    public Icon getIcon() {
        return this.icon;
    }

    @Override
    public void registerIcon(IconRegister register) {
        this.icon = LiquidManager.loadLiquidIcon(register, this);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getIdentifier() {
        return "binnie." + this.ident;
    }

    @Override
    public int getColour() {
        return this.colour;
    }

    @Override
    public FluidStack get(int amount) {
        return LiquidManager.getLiquidStack(this.getIdentifier(), amount);
    }

    @Override
    public int getTransparency() {
        return (int)(Math.min(1.0, (double)this.transparency + 0.3) * 255.0);
    }

    @Override
    public String getTooltip(int ratio) {
        return ratio + " Part" + (ratio > 1 ? "s " : " ") + this.getName();
    }
}

