/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.worldgen;

import binnie.core.plugin.IBinnieModule;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.config.ConfigurationMain;
import binnie.extrabees.genetics.EnumExtraBeeSpecies;
import binnie.extrabees.worldgen.BlockExtraBeeHive;
import binnie.extrabees.worldgen.EnumHiveType;
import binnie.extrabees.worldgen.HiveDrop;
import binnie.extrabees.worldgen.ItemBeehive;
import binnie.extrabees.worldgen.MaterialBeehive;
import binnie.extrabees.worldgen.WorldGenHiveNether;
import binnie.extrabees.worldgen.WorldGenHiveRock;
import binnie.extrabees.worldgen.WorldGenHiveWater;
import buildcraft.api.core.BuildCraftAPI;
import cpw.mods.fml.common.IWorldGenerator;
import cpw.mods.fml.common.registry.GameRegistry;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.world.World;
import net.minecraft.world.chunk.IChunkProvider;
import net.minecraftforge.common.MinecraftForge;

public class ModuleGeneration
implements IWorldGenerator,
IBinnieModule {
    static int waterRate = 2;
    static int rockRate = 2;
    static int netherRate = 2;
    static int marbleRate = 2;

    @Override
    public void preInit() {
        ExtraBees.materialBeehive = new MaterialBeehive();
        ExtraBees.hive = new BlockExtraBeeHive(ConfigurationMain.hiveID);
        GameRegistry.registerBlock((Block)ExtraBees.hive, ItemBeehive.class, (String)"extrabees.block.hive");
    }

    @Override
    public void doInit() {
        waterRate = ConfigurationMain.waterHiveRate;
        rockRate = ConfigurationMain.rockHiveRate;
        netherRate = ConfigurationMain.netherHiveRate;
        GameRegistry.registerWorldGenerator((IWorldGenerator)new ModuleGeneration());
        if (!ConfigurationMain.canQuarryMineHives) {
            BuildCraftAPI.softBlocks[ExtraBees.hive.field_71990_ca] = true;
        }
    }

    @Override
    public void postInit() {
        EnumHiveType.Water.drops.add(new HiveDrop(EnumExtraBeeSpecies.WATER, 80));
        EnumHiveType.Water.drops.add(new HiveDrop(EnumExtraBeeSpecies.getVanilla("Valiant"), 3));
        EnumHiveType.Rock.drops.add(new HiveDrop(EnumExtraBeeSpecies.ROCK, 80));
        EnumHiveType.Rock.drops.add(new HiveDrop(EnumExtraBeeSpecies.getVanilla("Valiant"), 3));
        EnumHiveType.Nether.drops.add(new HiveDrop(EnumExtraBeeSpecies.BASALT, 80));
        EnumHiveType.Nether.drops.add(new HiveDrop(EnumExtraBeeSpecies.getVanilla("Valiant"), 3));
        MinecraftForge.setBlockHarvestLevel((Block)ExtraBees.hive, (int)0, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ExtraBees.hive, (int)1, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ExtraBees.hive, (int)2, (String)"scoop", (int)0);
        MinecraftForge.setBlockHarvestLevel((Block)ExtraBees.hive, (int)3, (String)"scoop", (int)0);
    }

    public void generate(Random rand, int chunkX, int chunkZ, World world, IChunkProvider chunkGenerator, IChunkProvider chunkProvider) {
        int randPosZ;
        int randPosY;
        int randPosX;
        int i;
        chunkX <<= 4;
        chunkZ <<= 4;
        for (i = 0; i < waterRate; ++i) {
            randPosX = chunkX + rand.nextInt(16);
            randPosY = rand.nextInt(50) + 20;
            randPosZ = chunkZ + rand.nextInt(16);
            new WorldGenHiveWater().func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        for (i = 0; i < rockRate; ++i) {
            randPosX = chunkX + rand.nextInt(16);
            randPosY = rand.nextInt(50) + 20;
            randPosZ = chunkZ + rand.nextInt(16);
            new WorldGenHiveRock().func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
        for (i = 0; i < netherRate; ++i) {
            randPosX = chunkX + rand.nextInt(16);
            randPosY = rand.nextInt(50) + 20;
            randPosZ = chunkZ + rand.nextInt(16);
            new WorldGenHiveNether().func_76484_a(world, rand, randPosX, randPosY, randPosZ);
        }
    }
}

