/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.machines.tile;

import binnie.core.Binnie;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.inventory.MachineSide;
import binnie.core.machines.inventory.TankValidator;
import binnie.core.machines.power.ErrorState;
import binnie.extrabees.core.ExtraBeeGUID;
import binnie.extrabees.engineering.ItemTemplate;
import binnie.extrabees.engineering.ModuleEngineering;
import binnie.extrabees.machines.logic.SlotValidatorBee;
import binnie.extrabees.machines.logic.SlotValidatorTemplate;
import binnie.extrabees.machines.tile.TileEntityMachine;
import buildcraft.api.power.IPowerReceptor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.world.World;

public class TileEntitySplicer
extends TileEntityMachine
implements IPowerReceptor {
    public static final int[] SlotReserve = new int[]{6, 7, 8, 9, 10, 11};
    public static final int[] SlotFinished = new int[]{12, 13, 14, 15, 16, 17};
    public static final int SlotBee = 5;
    public static final int SlotBeeAfter = 4;
    public static final int SlotTemplate = 2;
    int fxCounter = 0;

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onFX(World world, int x, int y, int z, float efficiency) {
    }

    public TileEntitySplicer() {
        super("Splicer", 15000, 1000, 25000);
        this.addSlot(5, InventorySlot.NameProcess);
        this.getSlot(5).setValidator(new SlotValidatorBee(SlotValidatorBee.Mode.Bee));
        this.getSlot(5).setReadOnly();
        this.getSlot(5).forbidInteraction();
        this.addSlotArray(SlotReserve, InventorySlot.NameInput);
        for (InventorySlot slot : this.getSlots(SlotReserve)) {
            slot.setValidator(new SlotValidatorBee(SlotValidatorBee.Mode.Bee));
            slot.forbidExtraction();
        }
        this.addSlotArray(SlotFinished, InventorySlot.NameOutput);
        for (InventorySlot slot : this.getSlots(SlotFinished)) {
            slot.setValidator(new SlotValidatorBee(SlotValidatorBee.Mode.Bee));
            slot.setReadOnly();
            slot.setOutputSides(MachineSide.Sides);
        }
        this.addSlot(4, InventorySlot.NameOutput);
        this.getSlot(4).setValidator(new SlotValidatorBee(SlotValidatorBee.Mode.Bee));
        this.getSlot(4).setReadOnly();
        this.getSlot(4).forbidInteraction();
        this.addSlot(2, "Template Slot");
        this.getSlot(2).setValidator(new SlotValidatorTemplate(SlotValidatorTemplate.Mode.Written2));
        this.getSlot(2).setOutputSides(MachineSide.TopAndBottom);
        this.addTank(0, "DNA Tank", 2000);
        this.getTankSlot(0).setValidator(new TankValidator.Basic("liquiddna"));
        this.transfer.addRestock(SlotReserve, 5);
        this.transfer.addStorage(4, SlotFinished);
    }

    @Override
    public ExtraBeeGUID getGUI() {
        return ExtraBeeGUID.Splicer;
    }

    @Override
    public ErrorState canWork() {
        if (this.func_70301_a(5) == null) {
            return new ErrorState.NoItem("No Bee for splicing", new int[]{5, 6, 7, 8, 9, 10, 11});
        }
        if (this.func_70301_a(2) == null) {
            return new ErrorState.NoItem("No Template for splicing", 2);
        }
        if (this.func_70301_a(4) != null) {
            return new ErrorState.NoSpace("No space for finished bees", SlotFinished);
        }
        return super.canWork();
    }

    @Override
    public ErrorState canProgress() {
        if (this.getTank(0).drain(500, false) == null || this.getTank((int)0).drain((int)500, (boolean)false).amount != 500) {
            return new ErrorState.InsufficientLiquid("Not enough Liquid DNA", 0);
        }
        return super.canProgress();
    }

    @Override
    public void onFinishTask() {
        ItemStack template = this.func_70301_a(2);
        IAlleleBeeSpecies species = ItemTemplate.getSpecies(template);
        if (species == null) {
            return;
        }
        IBee bee = Binnie.Genetics.getBeeRoot().getMember(this.getSlot(5).getItemStack());
        if (species == null || bee == null) {
            return;
        }
        IBeeGenome genome = Binnie.Genetics.getBeeRoot().templateAsGenome(Binnie.Genetics.getBeeRoot().getTemplate(species.getUID()));
        ItemStack beeItem = this.getSlot(5).getItemStack().func_77946_l();
        NBTTagCompound beeNBT = beeItem.func_77978_p();
        NBTTagCompound genomeNBT = beeNBT.func_74775_l("Genome");
        NBTTagList chromosomes = genomeNBT.func_74761_m("Chromosomes");
        EnumBeeChromosome[] possibleGenes = new EnumBeeChromosome[]{EnumBeeChromosome.SPECIES, EnumBeeChromosome.SPECIES, EnumBeeChromosome.SPECIES, EnumBeeChromosome.SPECIES, EnumBeeChromosome.SPECIES, EnumBeeChromosome.SPECIES, EnumBeeChromosome.EFFECT, EnumBeeChromosome.EFFECT, EnumBeeChromosome.EFFECT, EnumBeeChromosome.FLOWER_PROVIDER, EnumBeeChromosome.FLOWER_PROVIDER, EnumBeeChromosome.FLOWER_PROVIDER, EnumBeeChromosome.NOCTURNAL, EnumBeeChromosome.TOLERANT_FLYER, EnumBeeChromosome.CAVE_DWELLING, EnumBeeChromosome.NOCTURNAL, EnumBeeChromosome.TOLERANT_FLYER, EnumBeeChromosome.CAVE_DWELLING, EnumBeeChromosome.SPEED, EnumBeeChromosome.SPEED, EnumBeeChromosome.SPEED, EnumBeeChromosome.LIFESPAN, EnumBeeChromosome.LIFESPAN, EnumBeeChromosome.TEMPERATURE_TOLERANCE, EnumBeeChromosome.TEMPERATURE_TOLERANCE, EnumBeeChromosome.HUMIDITY_TOLERANCE, EnumBeeChromosome.HUMIDITY_TOLERANCE, EnumBeeChromosome.FERTILITY, EnumBeeChromosome.FERTILITY, EnumBeeChromosome.FLOWERING, EnumBeeChromosome.TERRITORY};
        int n = this.field_70331_k.field_73012_v.nextInt(4) + 4;
        for (int i = 0; i < n; ++i) {
            int id = this.field_70331_k.field_73012_v.nextBoolean() ? 1 : 0;
            EnumBeeChromosome chrom = possibleGenes[this.field_70331_k.field_73012_v.nextInt(possibleGenes.length)];
            NBTTagCompound chromosome = (NBTTagCompound)chromosomes.func_74743_b(chrom.ordinal() > 6 ? chrom.ordinal() - 1 : chrom.ordinal());
            chromosome.func_74778_a("UID" + id, genome.getActiveAllele(chrom.ordinal()).getUID());
        }
        beeItem.func_77982_d(beeNBT);
        ModuleEngineering.doBadStuff(beeItem, this.func_70301_a(2));
        bee = Binnie.Genetics.getBeeRoot().getMember(beeItem);
        if (bee.getGenome().getPrimary().getUID().equals(species.getUID())) {
            this.getSlot(5).setItemStack(null);
            this.getSlot(4).setItemStack(beeItem);
        }
        if (this.field_70331_k.field_73012_v.nextInt(10) == 0) {
            this.getSlot(2).setItemStack(null);
        }
        this.func_70296_d();
    }

    @Override
    public String getInformation() {
        return "The Splicer writes a template onto other bee species, changing their alleles.";
    }
}

