/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.machines.tile;

import binnie.core.Binnie;
import binnie.core.BinnieCore;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.power.ErrorState;
import binnie.core.network.INetworkedEntity;
import binnie.core.network.packet.PacketPayload;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.core.ExtraBeeGUID;
import binnie.extrabees.engineering.ItemTemplate;
import binnie.extrabees.machines.logic.LogicMachine;
import binnie.extrabees.machines.logic.SlotValidatorBee;
import binnie.extrabees.machines.logic.SlotValidatorTemplate;
import binnie.extrabees.machines.tile.TileEntityMachine;
import buildcraft.api.power.IPowerReceptor;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;

public class TileEntitySequencer
extends TileEntityMachine
implements IPowerReceptor,
INetworkedEntity {
    public static final int[] SlotReserves = new int[]{5, 6, 7, 8, 9, 10};
    public static final int SlotBee = 2;
    public static final int SlotTemplateBlank = 3;
    public static final int SlotTemplateWritten = 4;
    public float DNAProgress = 0.0f;
    public String SpeciesUID = "";

    @Override
    @SideOnly(value=Side.CLIENT)
    public void onFX(World world, int x, int y, int z, float efficiency) {
    }

    @Override
    public ExtraBeeGUID getGUI() {
        return ExtraBeeGUID.Sequencer;
    }

    public TileEntitySequencer() {
        super("Sequencer", 5000, 500, 10000);
        this.addSlot(2, InventorySlot.NameProcess);
        this.getSlot(2).setValidator(new SlotValidatorBee(SlotValidatorBee.Mode.Bee));
        this.getSlot(2).setReadOnly();
        this.getSlot(2).forbidExtraction();
        this.addSlotArray(SlotReserves, InventorySlot.NameInput);
        for (InventorySlot slot : this.getSlots(SlotReserves)) {
            slot.setValidator(new SlotValidatorBee(SlotValidatorBee.Mode.Bee));
            slot.forbidExtraction();
        }
        this.addSlot(3, "Template Slot");
        this.getSlot(3).setValidator(new SlotValidatorTemplate(SlotValidatorTemplate.Mode.Blank));
        this.getSlot(3).forbidExtraction();
        this.addSlot(4, InventorySlot.NameOutput);
        this.getSlot(4).setValidator(new SlotValidatorTemplate(SlotValidatorTemplate.Mode.Written));
        this.getSlot(4).setReadOnly();
        this.transfer.addRestock(SlotReserves, 2, 1);
    }

    @Override
    protected void onUpdate() {
        BinnieCore.proxy.sendNetworkEntityPacket(this);
    }

    @Override
    public void onFinishTask() {
        IBee bee = Binnie.Genetics.getBeeRoot().getMember(this.func_70301_a(2));
        float amount = LogicMachine.getSequencerAmount(this.func_70301_a(2));
        if (amount > 0.0f) {
            this.SpeciesUID = bee.getGenome().getPrimary().getUID();
            this.func_70299_a(2, null);
            this.DNAProgress += amount;
            if (this.DNAProgress >= 100.0f) {
                ItemStack stack = new ItemStack(ExtraBees.template, 1, 0);
                NBTTagCompound nbt = new NBTTagCompound();
                nbt.func_74778_a("species", this.SpeciesUID);
                nbt.func_74768_a("quality", this.field_70331_k.field_73012_v.nextInt(11));
                stack.func_77982_d(nbt);
                this.func_70299_a(4, stack);
                this.func_70298_a(3, 1);
                this.SpeciesUID = "";
                this.DNAProgress = 0.0f;
            }
        }
    }

    @Override
    public ErrorState canWork() {
        if (this.func_70301_a(3) == null) {
            this.SpeciesUID = "";
            this.DNAProgress = 0.0f;
            return new ErrorState.NoItem("No Blank Templates", 3);
        }
        if (this.func_70301_a(4) != null) {
            return new ErrorState.NoItem("No space for new templates", 4);
        }
        if (this.func_70301_a(2) == null) {
            return new ErrorState.NoItem("No Bee to sequence", 2);
        }
        IAlleleBeeSpecies species = Binnie.Genetics.getBeeRoot().getMember(this.func_70301_a(2)).getGenome().getPrimary();
        if (!this.SpeciesUID.equals("") && !species.getUID().equals(this.SpeciesUID)) {
            return new ErrorState.Item("Incorrect Species", "Bee does not match current species", new int[]{2});
        }
        if (this.SpeciesUID.equals("") && !ItemTemplate.canObtainSpecies(species.getUID())) {
            return new ErrorState.Item("Invalid Species", "Cannot create template for this species", new int[]{2});
        }
        return super.canWork();
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        nbttagcompound.func_74776_a("dnaProgress", this.DNAProgress);
        nbttagcompound.func_74778_a("speciesUID", this.SpeciesUID);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        this.DNAProgress = nbttagcompound.func_74760_g("dnaProgress");
        this.SpeciesUID = nbttagcompound.func_74779_i("speciesUID");
    }

    @Override
    public void writeToPacket(PacketPayload data) {
        data.addString(this.SpeciesUID);
        data.addFloat(this.DNAProgress);
    }

    @Override
    public void readFromPacket(PacketPayload data) {
        this.SpeciesUID = data.getString();
        this.DNAProgress = data.getFloat();
    }

    @Override
    public String getInformation() {
        return "The Sequencer reads DNA from certain bee species to create a template.";
    }
}

