/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.machines.tile;

import binnie.core.machines.inventory.TankValidator;
import binnie.core.machines.power.ErrorState;
import binnie.core.triggers.TriggerData;
import binnie.core.triggers.TriggerInventory;
import binnie.extrabees.core.ExtraBeeGUID;
import binnie.extrabees.engineering.ModuleEngineering;
import binnie.extrabees.machines.logic.SlotValidatorSerum;
import binnie.extrabees.machines.tile.TileEntityMachine;
import buildcraft.api.power.IPowerReceptor;
import java.util.List;
import net.minecraft.inventory.IInventory;

public class TileEntityPurifier
extends TileEntityMachine
implements IInventory,
IPowerReceptor {
    public static final int SlotSerum = 2;

    @Override
    public ExtraBeeGUID getGUI() {
        return ExtraBeeGUID.Purifier;
    }

    public TileEntityPurifier() {
        super("Purifier", 30000, 300, 50000);
        this.addSlot(2, "Serum Slot");
        this.getSlot(2).setValidator(new SlotValidatorSerum(SlotValidatorSerum.Mode.Serum));
        this.addTank(0, "DNA Tank", 4000);
        this.getTankSlot(0).setValidator(new TankValidator.Basic("liquiddna"));
    }

    @Override
    public void onFinishTask() {
        int amount = 100;
        this.getTank(0).drain(amount, true);
        ModuleEngineering.changeQuality(this.getSlot(2).getItemStack(), 1);
    }

    @Override
    public ErrorState canWork() {
        if (this.getSlot(2).getItemStack() == null) {
            return new ErrorState.NoItem("No Serum to purify", 2);
        }
        if (ModuleEngineering.getQuality(this.getSlot(2).getItemStack()) == 10) {
            return new ErrorState.InvalidItem("Serum already highest quality", 2);
        }
        return super.canWork();
    }

    @Override
    public ErrorState canProgress() {
        if (this.getTank(0).drain(100, false) != null && this.getTank((int)0).drain((int)100, (boolean)false).amount == 100) {
            return super.canProgress();
        }
        return new ErrorState.InsufficientLiquid("Not enough Liquid DNA", 0);
    }

    @Override
    public void getTriggers(List<TriggerData> triggers) {
        super.getTriggers(triggers);
        triggers.add(TriggerInventory.serumPure(this, 2));
    }

    @Override
    public String getInformation() {
        return "The Purifier increases the quality of a serum, at the expense of the quantity of DNA within it.";
    }
}

