/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.machines.tile;

import binnie.core.Binnie;
import binnie.core.BinnieCore;
import binnie.core.machines.inventory.SetList;
import binnie.core.machines.transfer.TransferRequest;
import binnie.extrabees.core.ExtraBeeGUID;
import binnie.extrabees.machines.tile.TileEntityMachine;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.ForgeDirection;

public class TileEntityIndexer
extends TileEntityMachine
implements IInventory {
    List<ItemStack> indexerInventory = new SetList<ItemStack>();
    public List<Integer> sortedInventory = new SetList<Integer>();
    Mode sortingMode = Mode.None;
    boolean needsSorting = true;
    public int guiRefreshCounter = 0;
    int indexerSize = 0;
    int guiIndexerSize = this.nextGuiID++;

    @Override
    public boolean func_94041_b(int slot, ItemStack itemStack) {
        return Binnie.Genetics.getBeeRoot().isMember(itemStack);
    }

    @Override
    public void func_70310_b(NBTTagCompound nbttagcompound) {
        super.func_70310_b(nbttagcompound);
        NBTTagList indexerNBT = new NBTTagList();
        for (ItemStack item : this.indexerInventory) {
            NBTTagCompound itemNBT = new NBTTagCompound();
            item.func_77955_b(itemNBT);
            indexerNBT.func_74742_a((NBTBase)itemNBT);
        }
        nbttagcompound.func_74782_a("indexer", (NBTBase)indexerNBT);
    }

    @Override
    public void func_70307_a(NBTTagCompound nbttagcompound) {
        super.func_70307_a(nbttagcompound);
        NBTTagList indexerNBT = nbttagcompound.func_74761_m("indexer");
        this.indexerInventory.clear();
        for (int i = 0; i < indexerNBT.func_74745_c(); ++i) {
            NBTTagCompound itemNBT = (NBTTagCompound)indexerNBT.func_74743_b(i);
            ItemStack stack = ItemStack.func_77949_a((NBTTagCompound)itemNBT);
            if (stack.field_77994_a == 0) {
                stack.field_77994_a = 1;
            }
            this.func_70299_a(i, stack);
        }
        this.needsSorting = true;
        this.func_70296_d();
    }

    @Override
    public void func_70316_g() {
        super.func_70316_g();
        this.Sort();
    }

    public void Sort() {
        int i = 0;
        while (i < this.indexerInventory.size()) {
            if (this.indexerInventory.get(i) == null) {
                this.indexerInventory.remove(i);
                continue;
            }
            ++i;
        }
        if (BinnieCore.proxy.isSimulating(this.field_70331_k)) {
            return;
        }
        if (!this.needsSorting) {
            return;
        }
        this.needsSorting = false;
        ++this.guiRefreshCounter;
        block0 : switch (this.sortingMode) {
            case Species: 
            case Type: {
                class SpeciesList {
                    public List<Integer> drones = new ArrayList<Integer>();
                    public List<Integer> queens = new ArrayList<Integer>();
                    public List<Integer> princesses = new ArrayList<Integer>();
                    public List<ItemStack> bees = new ArrayList<ItemStack>();

                    SpeciesList() {
                    }

                    public void add(ItemStack stack) {
                        this.bees.add(stack);
                    }
                }
                HashMap<String, SpeciesList> speciesList = new HashMap<String, SpeciesList>();
                for (ItemStack itemStack : this.indexerInventory) {
                    if (itemStack == null || !Binnie.Genetics.getBeeRoot().isMember(itemStack)) continue;
                    String species = Binnie.Genetics.getBeeRoot().getMember(itemStack).getGenome().getPrimary().getUID();
                    if (!speciesList.containsKey(species)) {
                        speciesList.put(species, new SpeciesList());
                    }
                    ((SpeciesList)speciesList.get(species)).add(itemStack);
                }
                for (SpeciesList sortableList : speciesList.values()) {
                    for (ItemStack beeStack : sortableList.bees) {
                        if (Binnie.Genetics.getBeeRoot().isDrone(beeStack)) {
                            sortableList.drones.add(this.indexerInventory.indexOf(beeStack));
                            continue;
                        }
                        if (Binnie.Genetics.getBeeRoot().isMated(beeStack)) {
                            sortableList.queens.add(this.indexerInventory.indexOf(beeStack));
                            continue;
                        }
                        sortableList.princesses.add(this.indexerInventory.indexOf(beeStack));
                    }
                }
                this.sortedInventory = new SetList<Integer>();
                switch (this.sortingMode) {
                    case Species: {
                        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
                            if (!speciesList.containsKey(allele.getUID())) continue;
                            this.sortedInventory.addAll(((SpeciesList)speciesList.get((Object)allele.getUID())).queens);
                            this.sortedInventory.addAll(((SpeciesList)speciesList.get((Object)allele.getUID())).princesses);
                            this.sortedInventory.addAll(((SpeciesList)speciesList.get((Object)allele.getUID())).drones);
                        }
                        break block0;
                    }
                    case Type: {
                        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
                            if (!speciesList.containsKey(allele.getUID())) continue;
                            this.sortedInventory.addAll(((SpeciesList)speciesList.get((Object)allele.getUID())).queens);
                        }
                        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
                            if (!speciesList.containsKey(allele.getUID())) continue;
                            this.sortedInventory.addAll(((SpeciesList)speciesList.get((Object)allele.getUID())).princesses);
                        }
                        for (IAllele allele : AlleleManager.alleleRegistry.getRegisteredAlleles().values()) {
                            if (!speciesList.containsKey(allele.getUID())) continue;
                            this.sortedInventory.addAll(((SpeciesList)speciesList.get((Object)allele.getUID())).drones);
                        }
                        break block0;
                    }
                }
                break;
            }
            default: {
                this.sortedInventory.clear();
                for (i = 0; i < this.indexerInventory.size(); ++i) {
                    this.sortedInventory.add(i);
                }
            }
        }
    }

    @Override
    public ExtraBeeGUID getGUI() {
        return ExtraBeeGUID.Indexer;
    }

    @Override
    public int func_70302_i_() {
        if (this.indexerSize > 0) {
            return this.indexerSize + 1;
        }
        return this.indexerInventory.size() + 1;
    }

    @Override
    public ItemStack func_70301_a(int index) {
        if (index >= 0 && index < this.indexerInventory.size()) {
            ItemStack ret = this.indexerInventory.get(index);
            return ret;
        }
        return null;
    }

    @Override
    public ItemStack func_70298_a(int index, int amount) {
        if (index >= 0) {
            if (this.func_70301_a(index) == null) {
                return null;
            }
            if (amount >= this.func_70301_a((int)index).field_77994_a) {
                ItemStack returnStack = this.func_70301_a(index).func_77946_l();
                this.func_70299_a(index, null);
                return returnStack;
            }
            ItemStack returnStack = this.func_70301_a(index).func_77946_l();
            this.func_70301_a((int)index).field_77994_a -= amount;
            returnStack.field_77994_a = amount;
            return returnStack;
        }
        return null;
    }

    @Override
    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public void func_70296_d() {
        super.func_70296_d();
        ++this.guiRefreshCounter;
    }

    @Override
    public void func_70299_a(int index, ItemStack itemStack) {
        if (itemStack != null && !Binnie.Genetics.getBeeRoot().isMember(itemStack)) {
            return;
        }
        if (index >= 0 && index < this.indexerInventory.size()) {
            this.indexerInventory.set(index, itemStack);
        } else if (itemStack != null) {
            this.indexerInventory.add(itemStack);
        }
        this.needsSorting = true;
        this.func_70296_d();
    }

    @Override
    public String func_70303_b() {
        return "";
    }

    @Override
    public int func_70297_j_() {
        return 64;
    }

    @Override
    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    @Override
    public void func_70295_k_() {
    }

    @Override
    public void func_70305_f() {
    }

    public void setMode(Mode mode) {
        this.sortingMode = mode;
        this.needsSorting = true;
    }

    public Mode getMode() {
        return this.sortingMode;
    }

    @Override
    public void addGUINetworkData(Map<Integer, Integer> data) {
        super.addGUINetworkData(data);
        data.put(this.guiIndexerSize, this.indexerInventory.size());
    }

    @Override
    public void recieveGUINetworkData(int id, int data) {
        super.recieveGUINetworkData(id, data);
        if (id == this.guiIndexerSize) {
            this.indexerSize = data;
        }
    }

    public TileEntityIndexer() {
        super("Indexer");
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        ItemStack result = new TransferRequest(stack, this).transfer(doAdd);
        return result == null ? stack.field_77994_a : stack.field_77994_a - result.field_77994_a;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        if (this.indexerInventory.size() == 0 || this.indexerInventory.get(0) == null) {
            return new ItemStack[0];
        }
        ItemStack extracted = this.indexerInventory.get(0).func_77946_l();
        if (extracted.field_77994_a > maxItemCount) {
            extracted.field_77994_a = maxItemCount;
        }
        if (doRemove) {
            extracted = this.func_70298_a(0, maxItemCount);
        }
        return new ItemStack[]{extracted};
    }

    @Override
    public String getInformation() {
        return "The Indexer holds up to 1000 bees, and can be sorted by species or gender.";
    }

    @Override
    public int[] func_94128_d(int var1) {
        int[] info = new int[this.indexerInventory.size()];
        for (int i = 0; i < this.indexerInventory.size(); ++i) {
            info[i] = i;
        }
        return info;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.func_94041_b(i, itemstack);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return true;
    }

    public static enum Mode {
        None,
        Species,
        Type;

    }
}

