/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.machines.logic;

import binnie.core.Binnie;
import forestry.api.apiculture.EnumBeeChromosome;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.apiculture.IBee;
import forestry.api.apiculture.IBeeGenome;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IChromosome;
import java.util.Random;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class LogicMachine {
    public static int getDNAAmount(ItemStack beeStack) {
        if (!Binnie.Genetics.getBeeRoot().isMember(beeStack)) {
            return 0;
        }
        Random rand = new Random();
        int typeWorth = 0;
        typeWorth = Binnie.Genetics.getBeeRoot().isDrone(beeStack) ? 50 : (Binnie.Genetics.getBeeRoot().isMated(beeStack) ? 500 : 250);
        if (Binnie.Genetics.getBeeRoot().getMember(beeStack).isAnalyzed()) {
            typeWorth *= 2;
        }
        return typeWorth;
    }

    public static float getSequencerAmount(ItemStack beeStack) {
        if (!Binnie.Genetics.getBeeRoot().isMember(beeStack)) {
            return 0.0f;
        }
        IBee bee = Binnie.Genetics.getBeeRoot().getMember(beeStack);
        IBeeGenome genome = bee.getGenome();
        float typeWorth = 5.0f;
        typeWorth = Binnie.Genetics.getBeeRoot().isDrone(beeStack) ? 5.0f : (Binnie.Genetics.getBeeRoot().isMated(beeStack) ? 25.0f : 20.0f);
        if (bee.isPureBred(EnumBeeChromosome.SPECIES.ordinal())) {
            typeWorth *= 2.0f;
        }
        return typeWorth;
    }

    public static void spliceBee(ItemStack beeStack, IAlleleBeeSpecies species) {
        Random rand = new Random();
        IBee bee = Binnie.Genetics.getBeeRoot().getMember(beeStack);
        IBeeGenome genome = bee.getGenome();
        IChromosome[] chromosomes = genome.getChromosomes();
        IAllele[] template = Binnie.Genetics.getBeeRoot().getTemplate(species.getUID());
        IBeeGenome newGenome = Binnie.Genetics.getBeeRoot().templateAsGenome(template, template);
        if (rand.nextInt(8) == 0) {
            bee.setIsNatural(false);
        }
        NBTTagCompound genomeNBT = new NBTTagCompound();
        newGenome.writeToNBT(genomeNBT);
        genome.readFromNBT(genomeNBT);
        NBTTagCompound beeNBT = new NBTTagCompound();
        bee.writeToNBT(beeNBT);
        beeStack.func_77982_d(beeNBT);
    }
}

