/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.machines;

import binnie.core.BinnieCore;
import binnie.core.liquid.FluidType;
import binnie.core.liquid.ItemFluidContainer;
import binnie.core.liquid.LiquidManager;
import binnie.core.machines.inventory.ValidatorIcon;
import binnie.core.plugin.IBinnieModule;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.config.ConfigurationMachines;
import binnie.extrabees.machines.block.BlockAdvancedGeneticMachine;
import binnie.extrabees.machines.block.BlockApiaristMachine;
import binnie.extrabees.machines.block.BlockGeneticMachine;
import binnie.extrabees.machines.item.ItemAdvancedGeneticMachine;
import binnie.extrabees.machines.item.ItemApiaristMachine;
import binnie.extrabees.machines.item.ItemGeneticMachine;
import binnie.extrabees.machines.logic.LogicAcclimatiser;
import binnie.extrabees.machines.tile.TileEntityAcclimatiser;
import binnie.extrabees.machines.tile.TileEntityAdvancedGeneticMachine;
import binnie.extrabees.machines.tile.TileEntityApiaristMachine;
import binnie.extrabees.machines.tile.TileEntityDatabank;
import binnie.extrabees.machines.tile.TileEntityGenepool;
import binnie.extrabees.machines.tile.TileEntityGeneticMachine;
import binnie.extrabees.machines.tile.TileEntityIndexer;
import binnie.extrabees.machines.tile.TileEntityInoculator;
import binnie.extrabees.machines.tile.TileEntityIsolator;
import binnie.extrabees.machines.tile.TileEntityPurifier;
import binnie.extrabees.machines.tile.TileEntityReplicator;
import binnie.extrabees.machines.tile.TileEntitySequencer;
import binnie.extrabees.machines.tile.TileEntitySplicer;
import binnie.extrabees.machines.tile.TileEntitySynthesizer;
import cpw.mods.fml.common.registry.GameRegistry;
import forestry.api.core.ItemInterface;
import net.minecraft.block.Block;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class ModuleMachines
implements IBinnieModule {
    public static int modelMachine;
    public static ValidatorIcon IconSerum;
    public static ValidatorIcon IconTemplate;

    @Override
    public void doInit() {
        LiquidManager.createLiquid(new FluidType("liquiddna", ExtraBees.instance, "dna", "liquids/dna"), ItemFluidContainer.LiquidDNA);
        IconSerum = new ValidatorIcon(ExtraBees.instance, "validator/serum.0", "validator/serum.1");
        IconTemplate = new ValidatorIcon(ExtraBees.instance, "validator/template.0", "validator/template.1");
        Block apiaristMachine = ExtraBees.apiaristMachine = new BlockApiaristMachine(ConfigurationMachines.apiaristMachineID);
        GameRegistry.registerBlock((Block)apiaristMachine, ItemApiaristMachine.class, (String)"extrabees.block.apiaristMachine");
        Block geneticMachine = ExtraBees.geneticMachine = new BlockGeneticMachine(ConfigurationMachines.geneticMachineID);
        GameRegistry.registerBlock((Block)geneticMachine, ItemGeneticMachine.class, (String)"extrabees.block.geneticMachine");
        Block advGeneticMachine = ExtraBees.advGeneticMachine = new BlockAdvancedGeneticMachine(ConfigurationMachines.advGeneticMachineID);
        GameRegistry.registerBlock((Block)advGeneticMachine, ItemAdvancedGeneticMachine.class, (String)"extrabees.block.advGeneticMachine");
        modelMachine = BinnieCore.proxy.getUniqueRenderID();
        Object renderer = BinnieCore.proxy.createObject("binnie.extrabees.machines.render.RendererMachine");
        BinnieCore.proxy.registerTileEntity(TileEntityApiaristMachine.class, "extrabees.apiaristMachine", renderer);
        BinnieCore.proxy.registerTileEntity(TileEntityGeneticMachine.class, "extrabees.geneticMachine", renderer);
        BinnieCore.proxy.registerTileEntity(TileEntityAdvancedGeneticMachine.class, "extrabees.advGeneticMachine", renderer);
        BinnieCore.proxy.registerTileEntity(TileEntityAcclimatiser.class, "extrabees.acclimatiser", renderer);
        BinnieCore.proxy.registerTileEntity(TileEntityDatabank.class, "extrabees.databank", renderer);
        BinnieCore.proxy.registerTileEntity(TileEntityIndexer.class, "extrabees.indexer", renderer);
        BinnieCore.proxy.registerTileEntity(TileEntityGenepool.class, "extrabees.genepool", renderer);
        BinnieCore.proxy.registerTileEntity(TileEntitySequencer.class, "extrabees.sequencer", renderer);
        BinnieCore.proxy.registerTileEntity(TileEntitySplicer.class, "extrabees.splicer", renderer);
        BinnieCore.proxy.registerTileEntity(TileEntityIsolator.class, "extrabees.isolator", renderer);
        BinnieCore.proxy.registerTileEntity(TileEntityReplicator.class, "extrabees.replicator", renderer);
        BinnieCore.proxy.registerTileEntity(TileEntityPurifier.class, "extrabees.purifier", renderer);
        BinnieCore.proxy.registerTileEntity(TileEntityInoculator.class, "extrabees.inoculator", renderer);
        BinnieCore.proxy.registerTileEntity(TileEntitySynthesizer.class, "extrabees.synthesizer", renderer);
        BinnieCore.proxy.registerBlockRenderer(renderer);
    }

    @Override
    public void postInit() {
        Block apiaristMachine = ExtraBees.apiaristMachine;
        Block geneticMachine = ExtraBees.geneticMachine;
        Block advGeneticMachine = ExtraBees.advGeneticMachine;
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(apiaristMachine, 1, 0), new Object[]{"SRS", "SMS", "SRS", Character.valueOf('S'), "ingotCopper", Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('M'), ItemInterface.getItem((String)"sturdyCasing")}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(geneticMachine, 1, 0), new Object[]{"SRS", "SMS", "SES", Character.valueOf('S'), Item.field_77703_o, Character.valueOf('R'), new ItemStack(Item.field_77756_aW, 1, 4), Character.valueOf('M'), new ItemStack(apiaristMachine, 1, 0), Character.valueOf('E'), new ItemStack(ItemInterface.getItem((String)"circuitboards").func_77973_b(), 1, 0)}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(advGeneticMachine, 1, 0), new Object[]{"SRS", "SMS", "SES", Character.valueOf('S'), Item.field_77717_p, Character.valueOf('R'), Item.field_77702_n, Character.valueOf('M'), new ItemStack(geneticMachine, 1, 0), Character.valueOf('E'), new ItemStack(ItemInterface.getItem((String)"circuitboards").func_77973_b(), 1, 1)}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(apiaristMachine, 1, 1), new Object[]{"WRL", "WML", "WRL", Character.valueOf('W'), ItemInterface.getItem((String)"canWater"), Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('M'), new ItemStack(apiaristMachine, 1, 0), Character.valueOf('L'), ItemInterface.getItem((String)"canLava")}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(apiaristMachine, 1, 2), new Object[]{"GDG", "GMG", "GRG", Character.valueOf('G'), Block.field_71946_M, Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('M'), new ItemStack(apiaristMachine, 1, 0), Character.valueOf('D'), ExtraBees.dictionary}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(apiaristMachine, 1, 3), new Object[]{"GDG", "GMG", "GRG", Character.valueOf('G'), Block.field_72077_au, Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('M'), new ItemStack(apiaristMachine, 1, 0), Character.valueOf('D'), Item.field_77702_n}));
        Block tankBlock = null;
        try {
            tankBlock = (Block)Class.forName("buildcraft.BuildCraftFactory").getField("tankBlock").get(null);
        }
        catch (Exception e) {
            // empty catch block
        }
        ItemStack tank = new ItemStack(Block.field_71946_M);
        if (tankBlock != null) {
            tank = new ItemStack(tankBlock);
        }
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(geneticMachine, 1, 1), new Object[]{"TGT", "TMT", "gRg", Character.valueOf('T'), tank, Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('M'), new ItemStack(geneticMachine, 1, 0), Character.valueOf('G'), Block.field_71946_M, Character.valueOf('g'), Item.field_77717_p}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(geneticMachine, 1, 2), new Object[]{"ggg", "GMG", "LRL", Character.valueOf('G'), Block.field_71946_M, Character.valueOf('l'), new ItemStack(Item.field_77756_aW, 1, 6), Character.valueOf('M'), new ItemStack(geneticMachine, 1, 0), Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('g'), Block.field_72014_bd}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(geneticMachine, 1, 3), new Object[]{"DDD", "TMT", "GRG", Character.valueOf('G'), Block.field_71946_M, Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('T'), tank, Character.valueOf('M'), new ItemStack(geneticMachine, 1, 0), Character.valueOf('D'), Item.field_77702_n}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(advGeneticMachine, 1, 1), new Object[]{"KKK", "XMX", "XRX", Character.valueOf('K'), Item.field_77817_bH, Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('M'), new ItemStack(advGeneticMachine, 1, 0), Character.valueOf('X'), Item.field_77731_bo}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(advGeneticMachine, 1, 2), new Object[]{"SSS", "TMT", "TRT", Character.valueOf('T'), new ItemStack(ExtraBees.serumEmpty), Character.valueOf('S'), Item.field_77748_bA, Character.valueOf('M'), new ItemStack(advGeneticMachine, 1, 0), Character.valueOf('R'), Item.field_77767_aC}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(advGeneticMachine, 1, 3), new Object[]{"FFF", "TMT", "TRT", Character.valueOf('F'), Item.field_77732_bp, Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('T'), tank, Character.valueOf('M'), new ItemStack(advGeneticMachine, 1, 0)}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(advGeneticMachine, 1, 4), new Object[]{"BBB", "BMB", "SRS", Character.valueOf('B'), Item.field_77725_bx, Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('S'), ExtraBees.serumEmpty, Character.valueOf('M'), new ItemStack(advGeneticMachine, 1, 0)}));
        CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(advGeneticMachine, 1, 5), new Object[]{"SGS", "TMT", "SRS", Character.valueOf('G'), Block.field_71946_M, Character.valueOf('S'), Block.field_72013_bc, Character.valueOf('M'), new ItemStack(advGeneticMachine, 1, 0), Character.valueOf('R'), Item.field_77767_aC, Character.valueOf('T'), tank}));
        LogicAcclimatiser.postInit();
    }

    @Override
    public void preInit() {
    }
}

