/*
 * Decompiled with CFR 0.152.
 */
package binnie.extrabees.genetics;

import binnie.core.Binnie;
import binnie.core.language.LocalisedString;
import binnie.extrabees.ExtraBees;
import binnie.extrabees.genetics.EnumExtraBeeSpecies;
import forestry.api.apiculture.IAlleleBeeSpecies;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IClassification;
import java.util.LinkedHashSet;
import java.util.Set;

public enum EnumExtraBeeBranch implements IClassification
{
    BARREN("Vacapis"),
    HOSTILE("Infenapis"),
    ROCKY("Monapis"),
    METALLIC("Lamminapis"),
    METALLIC2("Metalapis"),
    ALLOY("Allapis"),
    PRECIOUS("Pluriapis"),
    MINERAL("Niphapis"),
    GEMSTONE("Gemmapis"),
    NUCLEAR("Levapis"),
    HISTORIC("Priscapis"),
    FOSSILIZED("Fosiapis"),
    REFINED("Petrapis"),
    AQUATIC("Aquapis"),
    SACCHARINE("Sacchapis"),
    CLASSICAL("Grecapis"),
    VOLCANIC("Irrapis"),
    VIRULENT("Virapis"),
    VISCOUS("Viscapis"),
    CAUSTIC("Morbapis"),
    ENERGETIC("Incitapis"),
    FARMING("Agriapis"),
    SHADOW("Pullapis"),
    PRIMARY("Primapis"),
    SECONDARY("Secapis"),
    TERTIARY("Tertiapis"),
    FTB("Eftebeapis"),
    QUANTUM("Quantapis");

    private String uid = "";
    private String scientific = "";
    private LocalisedString name = Binnie.Language.register(ExtraBees.instance, "branch." + this.toString().toLowerCase() + ".name");
    private LocalisedString description = Binnie.Language.register(ExtraBees.instance, "branch." + this.toString().toLowerCase() + ".desc");
    private Set<IAlleleBeeSpecies> speciesSet = new LinkedHashSet<IAlleleBeeSpecies>();
    IClassification parent;

    public String getUID() {
        return "extrabees.genus." + this.uid;
    }

    public String getName() {
        return this.name.get();
    }

    public String getScientific() {
        return this.scientific;
    }

    public String getDescription() {
        return this.description.getOrBlank();
    }

    private EnumExtraBeeBranch(String scientific) {
        this.scientific = scientific;
        this.uid = this.toString().toLowerCase();
    }

    public void register() {
        if (!this.speciesSet.isEmpty()) {
            AlleleManager.alleleRegistry.registerClassification((IClassification)this);
            IClassification parent = AlleleManager.alleleRegistry.getClassification("family.apidae");
            if (parent != null) {
                parent.addMemberGroup((IClassification)this);
                this.setParent(parent);
            }
        }
    }

    public static void doInit() {
        IClassification austereBranch;
        IClassification festiveBranch;
        IClassification boggyBranch;
        IClassification agrarianBranch;
        IClassification frozenBranch = AlleleManager.alleleRegistry.getClassification("genus.bees.frozen");
        if (frozenBranch != null) {
            frozenBranch.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.ARTIC);
            EnumExtraBeeSpecies.ARTIC.setBranch(frozenBranch);
            frozenBranch.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.FREEZING);
            EnumExtraBeeSpecies.FREEZING.setBranch(frozenBranch);
        }
        if ((agrarianBranch = AlleleManager.alleleRegistry.getClassification("genus.bees.agrarian")) != null) {
            agrarianBranch.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.FARM);
            EnumExtraBeeSpecies.FARM.setBranch(agrarianBranch);
            EnumExtraBeeSpecies.GROWING.setBranch(agrarianBranch);
            EnumExtraBeeSpecies.THRIVING.setBranch(agrarianBranch);
            EnumExtraBeeSpecies.BLOOMING.setBranch(agrarianBranch);
        }
        if ((boggyBranch = AlleleManager.alleleRegistry.getClassification("genus.bees.boggy")) != null) {
            boggyBranch.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.SWAMP);
            boggyBranch.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.BOGGY);
            boggyBranch.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.FUNGAL);
            EnumExtraBeeSpecies.SWAMP.setBranch(boggyBranch);
            EnumExtraBeeSpecies.BOGGY.setBranch(boggyBranch);
            EnumExtraBeeSpecies.FUNGAL.setBranch(boggyBranch);
        }
        if ((festiveBranch = AlleleManager.alleleRegistry.getClassification("genus.bees.festive")) != null) {
            festiveBranch.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.CELEBRATORY);
            EnumExtraBeeSpecies.CELEBRATORY.setBranch(festiveBranch);
        }
        if ((austereBranch = AlleleManager.alleleRegistry.getClassification("genus.bees.austere")) != null) {
            austereBranch.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.HAZARDOUS);
            EnumExtraBeeSpecies.HAZARDOUS.setBranch(austereBranch);
        }
        FARMING.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.ALCOHOL);
        FARMING.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.MILK);
        FARMING.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.COFFEE);
        FARMING.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.CITRUS);
        FARMING.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.MINT);
        FARMING.register();
        BARREN.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.ARID);
        BARREN.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.BARREN);
        BARREN.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.DESOLATE);
        BARREN.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.DECOMPOSING);
        BARREN.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.GNAWING);
        BARREN.register();
        HOSTILE.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.ROTTEN);
        HOSTILE.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.BONE);
        HOSTILE.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.CREEPER);
        HOSTILE.register();
        ROCKY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.ROCK);
        ROCKY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.STONE);
        ROCKY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.GRANITE);
        ROCKY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.MINERAL);
        ROCKY.register();
        METALLIC.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.IRON);
        METALLIC.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.COPPER);
        METALLIC.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.TIN);
        METALLIC.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.LEAD);
        METALLIC.register();
        METALLIC2.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.NICKEL);
        METALLIC2.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.ZINC);
        METALLIC2.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.TUNGSTATE);
        METALLIC2.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.TITANIUM);
        METALLIC2.register();
        ALLOY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.BRONZE);
        ALLOY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.BRASS);
        ALLOY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.STEEL);
        ALLOY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.INVAR);
        ALLOY.register();
        PRECIOUS.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.SILVER);
        PRECIOUS.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.GOLD);
        PRECIOUS.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.ELECTRUM);
        PRECIOUS.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.PLATINUM);
        PRECIOUS.register();
        MINERAL.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.LAPIS);
        MINERAL.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.SODALITE);
        MINERAL.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.PYRITE);
        MINERAL.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.BAUXITE);
        MINERAL.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.CINNABAR);
        MINERAL.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.SPHALERITE);
        MINERAL.register();
        GEMSTONE.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.EMERALD);
        GEMSTONE.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.RUBY);
        GEMSTONE.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.SAPPHIRE);
        GEMSTONE.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.OLIVINE);
        GEMSTONE.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.DIAMOND);
        GEMSTONE.register();
        NUCLEAR.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.UNSTABLE);
        NUCLEAR.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.NUCLEAR);
        NUCLEAR.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.RADIOACTIVE);
        NUCLEAR.register();
        HISTORIC.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.ANCIENT);
        HISTORIC.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.PRIMEVAL);
        HISTORIC.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.PREHISTORIC);
        HISTORIC.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.RELIC);
        HISTORIC.register();
        FOSSILIZED.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.COAL);
        FOSSILIZED.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.RESIN);
        FOSSILIZED.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.OIL);
        FOSSILIZED.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.PEAT);
        FOSSILIZED.register();
        REFINED.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.DISTILLED);
        REFINED.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.FUEL);
        REFINED.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.CREOSOTE);
        REFINED.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.LATEX);
        REFINED.register();
        AQUATIC.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.WATER);
        AQUATIC.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.RIVER);
        AQUATIC.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.OCEAN);
        AQUATIC.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.INK);
        AQUATIC.register();
        SACCHARINE.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.SWEET);
        SACCHARINE.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.SUGAR);
        SACCHARINE.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.FRUIT);
        SACCHARINE.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.RIPENING);
        SACCHARINE.register();
        CLASSICAL.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.MARBLE);
        CLASSICAL.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.ROMAN);
        CLASSICAL.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.GREEK);
        CLASSICAL.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.CLASSICAL);
        CLASSICAL.register();
        VOLCANIC.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.BASALT);
        VOLCANIC.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.TEMPERED);
        VOLCANIC.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.ANGRY);
        VOLCANIC.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.VOLCANIC);
        VOLCANIC.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.GLOWSTONE);
        VOLCANIC.register();
        VISCOUS.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.VISCOUS);
        VISCOUS.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.GLUTINOUS);
        VISCOUS.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.STICKY);
        VISCOUS.register();
        VIRULENT.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.MALICIOUS);
        VIRULENT.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.INFECTIOUS);
        VIRULENT.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.VIRULENT);
        VIRULENT.register();
        CAUSTIC.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.CORROSIVE);
        CAUSTIC.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.CAUSTIC);
        CAUSTIC.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.ACIDIC);
        CAUSTIC.register();
        ENERGETIC.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.EXCITED);
        ENERGETIC.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.ENERGETIC);
        ENERGETIC.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.ECSTATIC);
        ENERGETIC.register();
        SHADOW.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.SHADOW);
        SHADOW.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.DARKENED);
        SHADOW.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.ABYSS);
        SHADOW.register();
        PRIMARY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.RED);
        PRIMARY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.YELLOW);
        PRIMARY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.BLUE);
        PRIMARY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.GREEN);
        PRIMARY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.BLACK);
        PRIMARY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.WHITE);
        PRIMARY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.BROWN);
        PRIMARY.register();
        SECONDARY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.ORANGE);
        SECONDARY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.CYAN);
        SECONDARY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.PURPLE);
        SECONDARY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.GRAY);
        SECONDARY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.LIGHTBLUE);
        SECONDARY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.PINK);
        SECONDARY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.LIMEGREEN);
        SECONDARY.register();
        TERTIARY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.MAGENTA);
        TERTIARY.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.LIGHTGRAY);
        TERTIARY.register();
        FTB.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.JADED);
        FTB.register();
        QUANTUM.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.UNUSUAL);
        QUANTUM.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.SPATIAL);
        QUANTUM.addMemberSpecies((IAlleleSpecies)EnumExtraBeeSpecies.QUANTUM);
        QUANTUM.register();
    }

    public IClassification.EnumClassLevel getLevel() {
        return IClassification.EnumClassLevel.GENUS;
    }

    public IClassification[] getMemberGroups() {
        return null;
    }

    public void addMemberGroup(IClassification group) {
    }

    public IAlleleSpecies[] getMemberSpecies() {
        return this.speciesSet.toArray(new IAlleleSpecies[0]);
    }

    public void addMemberSpecies(IAlleleSpecies species) {
        this.speciesSet.add((IAlleleBeeSpecies)species);
        if (species instanceof EnumExtraBeeSpecies) {
            ((EnumExtraBeeSpecies)species).setBranch(this);
        }
    }

    public IClassification getParent() {
        return this.parent;
    }

    public void setParent(IClassification parent) {
        this.parent = parent;
    }
}

