/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.minecraft;

import binnie.craftgui.controls.ControlTextEdit;
import binnie.craftgui.controls.button.ControlButton;
import binnie.craftgui.controls.listbox.ControlOption;
import binnie.craftgui.controls.scroll.ControlScrollBar;
import binnie.craftgui.controls.tab.ControlTab;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.Widget;
import binnie.craftgui.core.geometry.Area;
import binnie.craftgui.core.geometry.Direction;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.IPosition;
import binnie.craftgui.core.geometry.Position;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.core.renderer.IRenderer;
import binnie.craftgui.core.renderer.IRendererWidget;
import binnie.craftgui.minecraft.MinecraftGUI;
import binnie.craftgui.resource.ITexture;
import binnie.craftgui.resource.minecraft.CraftGUITexture;
import binnie.craftgui.window.Panel;
import org.lwjgl.opengl.GL11;

public class RendererWidgetMinecraft
implements IRendererWidget {
    IRenderer renderer;

    public RendererWidgetMinecraft(IRenderer renderer) {
        this.renderer = renderer;
    }

    IRenderer getRenderer() {
        return this.renderer;
    }

    @Override
    public void preRender(IWidget widget) {
        this.getRenderer().setColour(widget.getColour());
        this.getRenderer().setWidget(widget);
        if (widget.isCroppedWidet()) {
            IWidget cropRelative = widget.getCropWidget() != null ? widget.getCropWidget() : widget;
            IPosition pos = cropRelative.getAbsolutePosition();
            IArea cropZone = widget.getCroppedZone();
            this.getRenderer().limitArea(new Area(pos.add(cropZone.pos()), cropZone.size()));
            GL11.glEnable((int)3089);
        }
    }

    @Override
    public void postRender(Widget widget) {
        if (widget.isCroppedWidet()) {
            GL11.glDisable((int)3089);
        }
        this.getRenderer().setWidget(null);
    }

    @Override
    public void render(IWidget widget, int renderLevel) {
        if (widget instanceof Panel && renderLevel == 0) {
            this.renderPanel((Panel)widget);
            return;
        }
        if (widget instanceof ControlTextEdit && renderLevel == 0) {
            this.renderTextEdit((ControlTextEdit)widget);
            return;
        }
        if (widget instanceof ControlTab && renderLevel == 0) {
            this.renderTab((ControlTab)widget);
            return;
        }
        if (widget instanceof ControlScrollBar && renderLevel == 0) {
            this.renderScroll((ControlScrollBar)widget);
            return;
        }
        if (widget instanceof ControlOption && renderLevel == 0) {
            this.renderListBoxOption((ControlOption)widget);
            return;
        }
        if (widget instanceof ControlButton && renderLevel == 0) {
            this.renderButton((ControlButton)widget);
            return;
        }
    }

    private void renderButton(ControlButton widget) {
        CraftGUITexture texture = CraftGUITexture.ButtonDisabled;
        if (widget.isMouseOver()) {
            texture = CraftGUITexture.ButtonHighlighted;
        } else if (widget.isEnabled()) {
            texture = CraftGUITexture.Button;
        }
        this.getRenderer().renderTexture((Object)texture, widget.getArea());
    }

    private void renderListBoxOption(ControlOption widget) {
        if (widget.isCurrentSelection()) {
            this.getRenderer().renderTexture((Object)CraftGUITexture.Outline, widget.getArea());
        }
    }

    private void renderScroll(ControlScrollBar widget) {
        float height = widget.getBarHeight();
        if (height < 6.0f) {
            height = 6.0f;
        }
        widget.setSize(new Vector2f(widget.getSize().x(), height));
        CraftGUITexture texture = CraftGUITexture.ScrollDisabled;
        if (widget.isMouseOver()) {
            texture = CraftGUITexture.ScrollHighlighted;
        } else if (widget.isEnabled()) {
            texture = CraftGUITexture.Scroll;
        }
        this.getRenderer().renderTexture((Object)texture, widget.getArea());
    }

    public void renderPanel(Panel panel) {
        Panel.IPanelType panelType = panel.getType();
        if (panelType instanceof MinecraftGUI.PanelType) {
            switch ((MinecraftGUI.PanelType)panelType) {
                case Black: {
                    this.getRenderer().renderTexture((Object)CraftGUITexture.PanelBlack, panel.getArea());
                    break;
                }
                case Gray: {
                    this.getRenderer().renderTexture((Object)CraftGUITexture.PanelGray, panel.getArea());
                    break;
                }
                case Tinted: {
                    this.getRenderer().renderTexture((Object)CraftGUITexture.PanelTinted, panel.getArea());
                    break;
                }
            }
        }
    }

    public void renderTextEdit(ControlTextEdit textEdit) {
        this.getRenderer().renderTexture((Object)CraftGUITexture.Slot, textEdit.getArea());
    }

    public void renderTab(ControlTab widget) {
        CraftGUITexture texture = CraftGUITexture.TabDisabled;
        if (widget.isMouseOver()) {
            texture = CraftGUITexture.TabHighlighted;
        } else if (widget.isCurrentSelection()) {
            texture = CraftGUITexture.Tab;
        }
        ITexture iTexture = this.getRenderer().getTexture((Object)texture);
        Position position = widget.getTabPosition();
        switch (position) {
            case Bottom: {
                iTexture = iTexture.subTexture(Direction.Upwards, iTexture.h() - 8);
                break;
            }
            case Right: {
                iTexture = iTexture.subTexture(Direction.Right, iTexture.w() - 8);
                break;
            }
            case Top: {
                iTexture = iTexture.subTexture(Direction.Downwards, iTexture.w() - 8);
                break;
            }
            default: {
                iTexture = iTexture.subTexture(Direction.Left, iTexture.w() - 8);
            }
        }
        IArea area = widget.getArea();
        if (texture == CraftGUITexture.TabDisabled) {
            if (position == Position.Top || position == Position.Left) {
                area.setPosition(area.getPosition().sub(new Vector2f(4 * position.x(), 4 * position.y())));
                area.setSize(area.getSize().add(new Vector2f(4 * position.x(), 4 * position.y())));
            } else {
                area.setSize(area.getSize().sub(new Vector2f(4 * position.x(), 4 * position.y())));
            }
        }
        this.getRenderer().renderTexture((Object)iTexture, area);
    }

    @Override
    public void renderTooltip(IPosition mousePosition, Tooltip tooltip) {
    }
}

