/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.minecraft;

import binnie.craftgui.controls.core.Control;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.Widget;
import binnie.craftgui.core.geometry.IPosition;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.minecraft.IRendererMinecraft;
import binnie.craftgui.minecraft.Window;
import net.minecraft.item.ItemStack;
import org.lwjgl.opengl.GL11;

public class ControlItemDisplay
extends Control
implements ITooltip {
    ItemStack itemStack = null;
    public boolean hastooltip = false;

    public void setTooltip() {
        this.hastooltip = true;
        this.addAttribute(Attribute.MouseOver);
    }

    public ControlItemDisplay(IWidget parent, int x, int y) {
        this(parent, x, y, 16);
    }

    public ControlItemDisplay(IWidget parent, int x, int y, int size) {
        super(parent, x, y, size, size);
    }

    @Override
    public void onRenderForeground() {
        IPosition relativeToWindow = this.getAbsolutePosition().sub(this.getSuperParent().getPosition());
        if (relativeToWindow.x() > ((Widget)Window.get(this)).getSize().x() + 100.0f || relativeToWindow.y() > ((Widget)Window.get(this)).getSize().y() + 100.0f) {
            return;
        }
        if (this.itemStack != null) {
            if (this.getSize().x() != 16.0f) {
                GL11.glPushMatrix();
                float scale = this.getSize().x() / 16.0f;
                GL11.glScalef((float)scale, (float)scale, (float)1.0f);
                this.getRenderer().subRenderer(IRendererMinecraft.class).renderItem(Vector2f.ZERO, this.itemStack);
                GL11.glPopMatrix();
            } else {
                this.getRenderer().subRenderer(IRendererMinecraft.class).renderItem(Vector2f.ZERO, this.itemStack);
            }
        }
    }

    public void setItemStack(ItemStack itemStack) {
        this.itemStack = itemStack;
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        if (this.hastooltip && this.itemStack != null) {
            tooltip.add(this.itemStack.func_82840_a(((Window)this.getSuperParent()).getPlayer(), false));
        }
    }
}

