/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.minecraft;

import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.core.machines.power.IPoweredMachine;
import binnie.core.machines.power.IProcess;
import binnie.craftgui.controls.core.Control;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.CraftGUIUtil;
import binnie.craftgui.core.geometry.Direction;
import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.minecraft.MinecraftTooltip;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.resource.minecraft.CraftGUITexture;
import net.minecraft.inventory.IInventory;
import org.lwjgl.opengl.GL11;

public class ControlEnergyBar
extends Control
implements ITooltip {
    public static boolean isError;
    protected Direction direction;

    public ControlEnergyBar(IWidget parent, int x, int y, int width, int height, Direction direction) {
        super(parent, x, y, width, height);
        this.direction = direction;
        this.addAttribute(Attribute.MouseOver);
    }

    public IPoweredMachine getClientPower() {
        IInventory inventory = ((Window)Window.get(this)).getInventory();
        TileEntityMachine machine = (TileEntityMachine)(inventory instanceof TileEntityMachine ? inventory : null);
        if (machine == null) {
            return null;
        }
        IPoweredMachine clientPower = machine.getMachine().getInterface(IPoweredMachine.class);
        return clientPower;
    }

    public float getPercentage() {
        float percentage = 100.0f * this.getStoredEnergy() / this.getMaxEnergy();
        if (percentage > 100.0f) {
            percentage = 100.0f;
        }
        return percentage;
    }

    private float getStoredEnergy() {
        return ((Window)Window.get(this)).getContainer().getPowerInfo().getStoredEnergy();
    }

    private float getMaxEnergy() {
        return ((Window)Window.get(this)).getContainer().getPowerInfo().getMaxEnergy();
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        if (tooltip.getType() == Tooltip.Type.Help) {
            tooltip.add("Energy Bar");
            tooltip.add("Current: " + this.getStoredEnergy() + " MJ (" + (int)this.getPercentage() + "%)");
            tooltip.add("Capacity: " + this.getMaxEnergy() + " MJ");
            tooltip.add("Max Input: " + ((Window)Window.get(this)).getContainer().getPowerInfo().getMaxInput() + " MJ");
            IProcess process = Machine.getInterface(IProcess.class, ((Window)Window.get(this)).getInventory());
            if (process != null) {
                tooltip.add("Usage: " + (int)process.getEnergyPerTick() + " MJ");
            }
        } else {
            tooltip.add((int)this.getPercentage() + "% charged");
            tooltip.add(this.getStoredEnergy() + "/" + this.getMaxEnergy() + " MJ");
        }
    }

    @Override
    public void onRenderBackground() {
        this.getRenderer().renderTexture((Object)CraftGUITexture.EnergyBarBack, this.getArea());
        float percentage = this.getPercentage() / 100.0f;
        this.getRenderer().setColour(this.getColourFromPercentage(percentage));
        IArea area = this.getArea();
        switch (this.direction) {
            case Downwards: 
            case Upwards: {
                float height = area.size().y() * percentage;
                area.setSize(new Vector2f(area.size().x(), height));
                break;
            }
            case Left: 
            case Right: {
                float width = area.size().x() * percentage;
                area.setSize(new Vector2f(width, area.size().y()));
            }
        }
        if (this.isMouseOver() && ((Window)Window.get(this)).getGui().getTooltipType() == Tooltip.Type.Help) {
            int c = -1442840576 + MinecraftTooltip.getOutline(Tooltip.Type.Help);
            this.getRenderer().renderGradientRect(CraftGUIUtil.getPaddedArea(this.getArea(), 1), c, c);
        } else if (isError) {
            int c = -1442840576 + MinecraftTooltip.getOutline(MinecraftTooltip.Type.Error);
            this.getRenderer().renderGradientRect(CraftGUIUtil.getPaddedArea(this.getArea(), 1), c, c);
        }
        this.getRenderer().renderTexture((Object)CraftGUITexture.EnergyBarGlow, area);
        GL11.glColor3d((double)1.0, (double)1.0, (double)1.0);
        this.getRenderer().renderTexture((Object)CraftGUITexture.EnergyBarGlass, this.getArea());
    }

    @Override
    public void onRenderOverlay() {
        if (this.isMouseOver() && ((Window)Window.get(this)).getGui().getTooltipType() == Tooltip.Type.Help) {
            IArea area = this.getArea();
            this.getRenderer().setColour(MinecraftTooltip.getOutline(Tooltip.Type.Help));
            this.getRenderer().renderTexture((Object)CraftGUITexture.Outline, CraftGUIUtil.getPaddedArea(area, -1));
        } else if (isError) {
            IArea area = this.getArea();
            this.getRenderer().setColour(MinecraftTooltip.getOutline(MinecraftTooltip.Type.Error));
            this.getRenderer().renderTexture((Object)CraftGUITexture.Outline, CraftGUIUtil.getPaddedArea(area, -1));
        }
    }

    public int getColourFromPercentage(float percentage) {
        int colour = 0xFFFFFF;
        if ((double)percentage > 0.5) {
            int r = (int)((1.0 - 2.0 * ((double)percentage - 0.5)) * 255.0);
            colour = (r << 16) + 65280;
        } else {
            int g = (int)(255.0f * (2.0f * percentage));
            colour = 0xFF0000 + (g << 8);
        }
        return colour;
    }
}

