/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.extratrees.kitchen;

import binnie.core.IBinnieMod;
import binnie.craftgui.controls.ControlTextEdit;
import binnie.craftgui.controls.core.Control;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.events.EventValueChanged;
import binnie.craftgui.events.core.EventHandler;
import binnie.craftgui.extratrees.kitchen.ControlCocktailIngredient;
import binnie.craftgui.extratrees.kitchen.ControlLineBrowser;
import binnie.craftgui.extratrees.kitchen.ControlSlotCocktail;
import binnie.craftgui.extratrees.kitchen.ControlSlotFluid;
import binnie.craftgui.extratrees.kitchen.ControlSlotGlassware;
import binnie.craftgui.minecraft.MinecraftGUI;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.window.Panel;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.alcohol.Cocktail;
import binnie.extratrees.alcohol.Glassware;
import binnie.extratrees.alcohol.ICocktailIngredient;
import binnie.extratrees.alcohol.drink.CocktailType;
import cpw.mods.fml.relauncher.Side;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraftforge.fluids.FluidStack;

public class WindowBar
extends Window {
    Map<ICocktailIngredient, Integer> currentIngredients = new HashMap<ICocktailIngredient, Integer>();
    int totalFluidAmount = 0;
    Glassware glassware = Glassware.Cocktail;
    ControlTextEdit cocktailName;
    public Panel ingredientsPanel;
    ControlSlotCocktail preview;

    public WindowBar(EntityPlayer player, IInventory inventory, Side side) {
        super(340.0f, 192.0f, player, inventory, side);
    }

    @Override
    protected IBinnieMod getMod() {
        return ExtraTrees.instance;
    }

    @Override
    protected String getName() {
        return "Bar";
    }

    @EventHandler(origin=EventHandler.Origin.Any)
    public void onValueChanged(EventValueChanged event) {
        if (event.isOrigin(this.cocktailName)) {
            this.updateCocktail();
        }
    }

    @EventHandler(origin=EventHandler.Origin.Any)
    public void onGenericClick(EventMouse.Down event) {
        if (event.getOrigin() instanceof ControlSlotGlassware) {
            this.glassware = ((ControlSlotGlassware)event.getOrigin()).getValue();
        }
        ICocktailIngredient ingr = null;
        if (event.getOrigin() instanceof ControlSlotFluid) {
            FluidStack fluid = ((ControlSlotFluid)event.getOrigin()).getFluidStack();
            ingr = Cocktail.getIngredient(fluid.getFluid().getName());
        } else if (event.getOrigin() instanceof ControlCocktailIngredient) {
            ingr = ((ControlCocktailIngredient)event.getOrigin()).ingredient;
        } else if (event.getOrigin().getParent() instanceof ControlCocktailIngredient) {
            ingr = ((ControlCocktailIngredient)event.getOrigin().getParent()).ingredient;
        }
        if (ingr != null) {
            if (event.getButton() == 0) {
                if (this.currentIngredients.containsKey(ingr)) {
                    this.currentIngredients.put(ingr, this.currentIngredients.get(ingr) + 1);
                } else {
                    this.currentIngredients.put(ingr, 1);
                }
            } else if (this.currentIngredients.containsKey(ingr)) {
                if (this.currentIngredients.get(ingr) == 1) {
                    this.currentIngredients.remove(ingr);
                } else {
                    this.currentIngredients.put(ingr, this.currentIngredients.get(ingr) - 1);
                }
            }
        }
        this.updateCocktail();
    }

    public void updateCocktail() {
        CocktailType cocktail = new CocktailType(this.glassware, this.currentIngredients);
        if (!this.cocktailName.getValue().isEmpty()) {
            cocktail.setName(this.cocktailName.getValue());
        }
        this.preview.setValue(cocktail);
        this.ingredientsPanel.deleteAllChildren();
        int y = 1;
        for (Map.Entry<ICocktailIngredient, Integer> ingr2 : this.currentIngredients.entrySet()) {
            new ControlCocktailIngredient(this.ingredientsPanel, 1.0f, y).setValue(ingr2.getKey(), ingr2.getValue());
            y += 14;
        }
    }

    @Override
    public void initialize() {
        this.setTitle("Bar");
        this.preview = new ControlSlotCocktail((IWidget)this, 20, 50, null);
        this.preview.setSize(new Vector2f(72.0f, 72.0f));
        CocktailType cocktail = new CocktailType(Glassware.Pint, Cocktail.Cosmopolitan);
        this.preview.setValue(cocktail);
        this.cocktailName = new ControlTextEdit(this, 172.0f, 24.0f, 130.0f, 16.0f);
        this.ingredientsPanel = new Panel(this, 100.0f, 50.0f, 202.0f, 82.0f, MinecraftGUI.PanelType.Black);
        ControlLineBrowser browser = new ControlLineBrowser(this, 12.0f, 140.0f, 220.0f, 20.0f);
        int x = 1;
        int y = 1;
        Glassware[] glassware = Glassware.values();
        Control glasswareControl = new Control(browser, 1.0f, 1.0f, 18 * glassware.length, 18.0f);
        for (Glassware glass : Glassware.values()) {
            ControlSlotGlassware control = new ControlSlotGlassware((IWidget)glasswareControl, x + 18 * glass.ordinal(), y, glass);
        }
        browser.setScrollableContent(glasswareControl);
    }

    public static Window create(EntityPlayer player, IInventory inventory, Side side) {
        return new WindowBar(player, inventory, side);
    }
}

