/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.extratrees.dictionary;

import binnie.core.Binnie;
import binnie.craftgui.controls.ControlText;
import binnie.craftgui.controls.core.Control;
import binnie.craftgui.controls.scroll.ControlScrollableContent;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.geometry.Area;
import binnie.craftgui.core.geometry.TextJustification;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.extratrees.dictionary.ControlBlockIconDisplay;
import binnie.craftgui.minecraft.ControlItemDisplay;
import binnie.craftgui.mod.database.DatabaseTab;
import binnie.craftgui.mod.database.PageSpecies;
import forestry.api.arboriculture.IAlleleTreeSpecies;
import forestry.api.arboriculture.ITree;
import forestry.api.arboriculture.ITreeGenome;
import forestry.api.core.ForestryAPI;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import java.util.ArrayList;
import net.minecraft.item.ItemStack;
import net.minecraft.util.Icon;

public class PageSpeciesTreeGenome
extends PageSpecies {
    public PageSpeciesTreeGenome(IWidget parent, DatabaseTab tab) {
        super(parent, tab);
    }

    @Override
    public void onValueChanged(IAlleleSpecies species) {
        ItemStack log;
        this.deleteAllChildren();
        IAllele[] template = Binnie.Genetics.getTreeRoot().getTemplate(species.getUID());
        if (template == null) {
            return;
        }
        ITree tree = (ITree)Binnie.Genetics.getTreeRoot().templateAsIndividual(template);
        if (tree == null) {
            return;
        }
        ITreeGenome genome = tree.getGenome();
        IAlleleTreeSpecies treeSpecies = genome.getPrimary();
        int w = 144;
        int h = 176;
        new ControlText(this, new Area(0.0f, 4.0f, w, 16.0f), "Genome", TextJustification.MiddleCenter);
        ControlScrollableContent<Control> scrollable = new ControlScrollableContent<Control>(this, 4.0f, 20.0f, w - 8, h - 8 - 16, 12.0f);
        Control contents = new Control(scrollable, 0.0f, 0.0f, w - 8 - 12, h - 8 - 16);
        int tw = w - 8 - 12;
        int w1 = 55;
        int w2 = tw - 50;
        int y = 0;
        int th = 14;
        int th2 = 18;
        new ControlText(contents, new Area(0.0f, y, w1, th), "Type : ", TextJustification.MiddleRight);
        new ControlText(contents, new Area(w1, y, w2, th), treeSpecies.getPlantType().toString(), TextJustification.MiddleLeft);
        new ControlText(contents, new Area(0.0f, y += th, w1, th), "Temp. : ", TextJustification.MiddleRight);
        new ControlText(contents, new Area(w1, y, w2, th), treeSpecies.getTemperature().getName(), TextJustification.MiddleLeft);
        y += th;
        Icon leaf = ForestryAPI.textureManager.getIcon(treeSpecies.getLeafIconIndex(tree, false));
        Icon fruit = null;
        int fruitColour = 0xFFFFFF;
        try {
            fruit = ForestryAPI.textureManager.getIcon(genome.getFruitProvider().getIconIndex(genome, null, 0, 0, 0, 100, false));
            fruitColour = genome.getFruitProvider().getColour(genome, null, 0, 0, 0, 100);
        }
        catch (Exception e) {
            // empty catch block
        }
        if (leaf != null) {
            new ControlText(contents, new Area(0.0f, y, w1, th2), "Leaves : ", TextJustification.MiddleRight);
            new ControlBlockIconDisplay(contents, w1, y, leaf).setColour(treeSpecies.getLeafColour(tree));
            if (fruit != null && !treeSpecies.getUID().equals("forestry.treeOak")) {
                new ControlBlockIconDisplay(contents, w1, y, fruit).setColour(fruitColour);
            }
            y += th2;
        }
        ItemStack itemStack = log = treeSpecies.getLogStacks().length > 0 ? treeSpecies.getLogStacks()[0] : null;
        if (log != null) {
            new ControlText(contents, new Area(0.0f, y, w1, th2), "Log : ", TextJustification.MiddleRight);
            ControlItemDisplay display = new ControlItemDisplay(contents, w1, y);
            display.setItemStack(log);
            display.setTooltip();
            y += th2;
        }
        new ControlText(contents, new Area(0.0f, y, w1, th), "Growth : ", TextJustification.MiddleRight);
        new ControlText(contents, new Area(w1, y, w2, th), genome.getGrowthProvider().getDescription(), TextJustification.MiddleLeft);
        new ControlText(contents, new Area(0.0f, y += th, w1, th), "Height : ", TextJustification.MiddleRight);
        new ControlText(contents, new Area(w1, y, w2, th), genome.getHeight() + "x", TextJustification.MiddleLeft);
        new ControlText(contents, new Area(0.0f, y += th, w1, th), "Fertility : ", TextJustification.MiddleRight);
        new ControlText(contents, new Area(w1, y, w2, th), genome.getFertility() + "x", TextJustification.MiddleLeft);
        y += th;
        ArrayList<ItemStack> fruits = new ArrayList<ItemStack>();
        for (ItemStack stack : genome.getFruitProvider().getProducts()) {
            fruits.add(stack);
        }
        if (!fruits.isEmpty()) {
            new ControlText(contents, new Area(0.0f, y, w1, th2), "Fruits : ", TextJustification.MiddleRight);
            for (ItemStack fruitw : fruits) {
                ControlItemDisplay display = new ControlItemDisplay(contents, w1, y);
                display.setItemStack(fruitw);
                display.setTooltip();
                y += th2;
            }
        }
        new ControlText(contents, new Area(0.0f, y, w1, th), "Yield : ", TextJustification.MiddleRight);
        new ControlText(contents, new Area(w1, y, w2, th), genome.getYield() + "x", TextJustification.MiddleLeft);
        new ControlText(contents, new Area(0.0f, y += th, w1, th), "Sappns. : ", TextJustification.MiddleRight);
        new ControlText(contents, new Area(w1, y, w2, th), genome.getSappiness() + "x", TextJustification.MiddleLeft);
        new ControlText(contents, new Area(0.0f, y += th, w1, th), "Maturtn. : ", TextJustification.MiddleRight);
        new ControlText(contents, new Area(w1, y, w2, th), genome.getMaturationTime() + "x", TextJustification.MiddleLeft);
        new ControlText(contents, new Area(0.0f, y += th, w1, th), "Girth : ", TextJustification.MiddleRight);
        new ControlText(contents, new Area(w1, y, w2, th), genome.getGirth() + "x" + genome.getGirth(), TextJustification.MiddleLeft);
        contents.setSize(new Vector2f(contents.size().x(), y += th));
        scrollable.setScrollableContent(contents);
    }

    public static String tolerated(boolean t) {
        if (t) {
            return "Tolerated";
        }
        return "Not Tolerated";
    }
}

