/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.extratrees.dictionary;

import binnie.core.machines.Machine;
import binnie.core.machines.TileEntityMachine;
import binnie.craftgui.controls.ControlText;
import binnie.craftgui.controls.core.Control;
import binnie.craftgui.controls.core.IControlValue;
import binnie.craftgui.controls.scroll.IControlScrollable;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.TopLevelWidget;
import binnie.craftgui.core.geometry.CraftGUIUtil;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.events.core.EventHandler;
import binnie.craftgui.minecraft.IRendererMinecraft;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.resource.minecraft.CraftGUITexture;
import binnie.extratrees.ExtraTrees;
import binnie.extratrees.api.CarpentryManager;
import binnie.extratrees.api.IDesign;
import binnie.extratrees.api.IDesignCategory;
import binnie.extratrees.block.PlankType;
import binnie.extratrees.carpentry.BlockCarpentry;
import binnie.extratrees.carpentry.EnumDesign;
import binnie.extratrees.carpentry.ModuleCarpentry;
import binnie.extratrees.machines.Woodworker;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class ControlTileSelect
extends Control
implements IControlValue<IDesign>,
IControlScrollable {
    IDesign value = EnumDesign.Blank;
    float shownHeight = 92.0f;

    protected ControlTileSelect(IWidget parent, float x, float y) {
        super(parent, x, y, 102.0f, 20 * (CarpentryManager.carpentryInterface.getSortedDesigns().size() / 4) + 22);
        this.refresh("");
    }

    @Override
    public float getPercentageIndex() {
        return 0.0f;
    }

    @Override
    public float getPercentageShown() {
        return 0.0f;
    }

    @Override
    public IDesign getValue() {
        return this.value;
    }

    @Override
    public void movePercentage(float percentage) {
    }

    @Override
    public void onUpdate() {
        super.onUpdate();
        TileEntityMachine tile = (TileEntityMachine)((Window)Window.get(this)).getInventory();
        if (tile == null) {
            return;
        }
        Woodworker.ComponentWoodworkerRecipe recipe = tile.getMachine().getComponent(Woodworker.ComponentWoodworkerRecipe.class);
        this.setValue(recipe.getDesign());
    }

    public void refresh(String filterText) {
        this.deleteAllChildren();
        int cx = 2;
        int cy = 2;
        HashMap designs = new HashMap();
        for (IDesignCategory category : CarpentryManager.carpentryInterface.getAllDesignCategories()) {
            designs.put(category, new ArrayList());
            for (IDesign tile : category.getDesigns()) {
                if (filterText != "" && !tile.getName().toLowerCase().contains(filterText)) continue;
                ((List)designs.get(category)).add(tile);
            }
            if (!((List)designs.get(category)).isEmpty()) continue;
            designs.remove(category);
        }
        for (IDesignCategory category : designs.keySet()) {
            cx = 2;
            new ControlText((IWidget)this, new Vector2f(cx, cy + 3), category.getName());
            cy += 16;
            for (IDesign tile : (List)designs.get(category)) {
                if (cx > 90) {
                    cx = 2;
                    cy += 20;
                }
                new ControlTile(this, cx, cy, tile);
                cx += 20;
            }
            cy += 20;
        }
        int height = cy;
        this.setSize(new Vector2f(this.getSize().x(), height));
    }

    @Override
    public void setPercentageIndex(float index) {
    }

    @Override
    public void setValue(IDesign value) {
        this.value = value;
    }

    public static class ControlTile
    extends Control
    implements IControlValue<IDesign>,
    ITooltip {
        IDesign value;
        boolean panel;

        protected ControlTile(IWidget parent, float x, float y, IDesign value) {
            super(parent, x, y, 18.0f, 18.0f);
            this.setValue(value);
            this.addAttribute(Attribute.MouseOver);
            this.panel = Machine.getInterface(Woodworker.ComponentWoodworkerRecipe.class, (Object)((Window)Window.get((IWidget)this)).getInventory()).panel;
        }

        @Override
        public void getTooltip(Tooltip tooltip) {
            tooltip.add(this.getValue().getName() + " Pattern");
        }

        @Override
        public IDesign getValue() {
            return this.value;
        }

        @EventHandler(origin=EventHandler.Origin.Self)
        public void onMouseClick(EventMouse.Down event) {
            TileEntityMachine tile = (TileEntityMachine)((Window)Window.get(this)).getInventory();
            if (tile == null) {
                return;
            }
            Woodworker.ComponentWoodworkerRecipe recipe = tile.getMachine().getComponent(Woodworker.ComponentWoodworkerRecipe.class);
            NBTTagCompound nbt = new NBTTagCompound("design");
            nbt.func_74777_a("D", (short)CarpentryManager.carpentryInterface.getDesignIndex(this.getValue()));
            ((Window)Window.get(this)).sendClientAction(nbt);
        }

        @Override
        public void onRenderBackground() {
            this.getRenderer().renderTexture((Object)CraftGUITexture.Slot, Vector2f.ZERO);
        }

        @Override
        public void onRenderForeground() {
            ItemStack image = ModuleCarpentry.getItemStack((BlockCarpentry)(this.panel ? ExtraTrees.blockPanel : ExtraTrees.blockCarpentry), PlankType.ExtraTreePlanks.Apple, PlankType.VanillaPlanks.BIRCH, this.getValue());
            this.getRenderer().subRenderer(IRendererMinecraft.class).renderItem(new Vector2f(1.0f, 1.0f), image);
            if (((IControlValue)this.getParent()).getValue() != this.getValue()) {
                if (((TopLevelWidget)Window.get(this)).getMousedOverWidget() == this) {
                    this.getRenderer().renderGradientRect(CraftGUIUtil.getPaddedArea(this.getArea(), 1), 0x44FFFFFF, 0x44FFFFFF);
                } else {
                    this.getRenderer().renderGradientRect(CraftGUIUtil.getPaddedArea(this.getArea(), 1), -1433892728, -1433892728);
                }
            }
        }

        @Override
        public void setValue(IDesign value) {
            this.value = value;
        }
    }
}

