/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.extratrees.dictionary;

import binnie.core.machines.Machine;
import binnie.core.machines.power.IProcess;
import binnie.craftgui.core.Attribute;
import binnie.craftgui.core.ITooltip;
import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Tooltip;
import binnie.craftgui.core.geometry.Area;
import binnie.craftgui.core.geometry.Vector2f;
import binnie.craftgui.events.EventMouse;
import binnie.craftgui.events.core.EventHandler;
import binnie.craftgui.minecraft.ControlProgressBase;
import binnie.craftgui.minecraft.IRendererMinecraft;
import binnie.craftgui.minecraft.Window;
import binnie.craftgui.resource.ITexture;
import binnie.craftgui.resource.minecraft.StandardTexture;
import binnie.extratrees.core.ExtraTreeTexture;
import binnie.extratrees.machines.Press;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class ControlFruitPressProgress
extends ControlProgressBase
implements ITooltip {
    static ITexture PressTexture = new StandardTexture(6, 0, 24, 52, ExtraTreeTexture.Gui);
    static ITexture PressSlot = new StandardTexture(9, 52, 34, 17, ExtraTreeTexture.Gui);
    float progress = 0.0f;

    @Override
    public void onUpdate() {
        IProcess process = Machine.getInterface(IProcess.class, ((Window)Window.get(this)).getInventory());
        if (process == null) {
            return;
        }
        this.progress = process.getProgress() / 100.0f;
    }

    @Override
    public void onRenderBackground() {
        this.getRenderer().renderTexture((Object)PressSlot, new Vector2f(3.0f, 52.0f));
        ItemStack input = ((Window)Window.get(this)).getContainer().func_75147_a(((Window)Window.get(this)).getInventory(), Press.slotCurrent).func_75211_c();
        if (input == null || Press.getOutput(input) == null) {
            return;
        }
        Fluid fluid = Press.getOutput(input).getFluid();
        int hex = fluid.getColor();
        int r = (hex & 0xFF0000) >> 16;
        int g = (hex & 0xFF00) >> 8;
        int b = hex & 0xFF;
        Icon icon = fluid.getIcon();
        GL11.glColor4f((float)((float)r / 255.0f), (float)((float)g / 255.0f), (float)((float)b / 255.0f), (float)1.0f);
        GL11.glEnable((int)3042);
        GL11.glBlendFunc((int)770, (int)771);
        this.getRenderer().subRenderer(IRendererMinecraft.class).renderBlockIcon(new Vector2f(4.0f, 52.0f), fluid.getIcon());
        GL11.glDisable((int)3042);
        icon = input.func_77954_c();
        this.getRenderer(IRendererMinecraft.class).renderItemIcon(new Vector2f(4.0f, 52.0f), icon);
    }

    @Override
    public void onRenderForeground() {
        this.getRenderer().renderTexture((Object)PressTexture, new Vector2f(0.0f, 16.0f * this.progress));
    }

    protected ControlFruitPressProgress(IWidget parent, float x, float y) {
        super(parent, x, y, 37.0f, 69.0f);
        this.addAttribute(Attribute.MouseOver);
    }

    @EventHandler(origin=EventHandler.Origin.Self)
    public void onClick(EventMouse.Down event) {
        if (event.getButton() == 0) {
            NBTTagCompound action = new NBTTagCompound("fruitpress-click");
            ((Window)Window.get(this)).sendClientAction(action);
        } else if (event.getButton() == 1 && new Area(3.0f, 52.0f, 18.0f, 17.0f).contains(this.getRelativeMousePosition())) {
            NBTTagCompound action = new NBTTagCompound("clear-fruit");
            ((Window)Window.get(this)).sendClientAction(action);
        }
    }

    @Override
    public void getTooltip(Tooltip tooltip) {
        if (new Area(3.0f, 52.0f, 18.0f, 17.0f).contains(this.getRelativeMousePosition())) {
            ItemStack input = ((Window)Window.get(this)).getContainer().func_75147_a(((Window)Window.get(this)).getInventory(), Press.slotCurrent).func_75211_c();
            if (input == null) {
                return;
            }
            FluidStack fluid = Press.getOutput(input);
            if (fluid == null) {
                return;
            }
            tooltip.add(input.func_82833_r());
            tooltip.add("Squeezes to " + fluid.getFluid().getLocalizedName());
        }
    }
}

