/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.core.geometry;

import binnie.craftgui.core.geometry.IArea;
import binnie.craftgui.core.geometry.IPosition;
import binnie.craftgui.core.geometry.Vector2f;

public class Area
implements IArea {
    private IPosition pos;
    private IPosition size;

    public Area(IArea area) {
        this(area.pos().x(), area.pos().y(), area.size().x(), area.size().y());
    }

    public Area(IPosition pos, IPosition size) {
        this(pos.x(), pos.y(), size.x(), size.y());
    }

    public Area(float x, float y, float w, float h) {
        this.setPosition(new Vector2f(x, y));
        this.setSize(new Vector2f(w, h));
    }

    @Override
    public IPosition pos() {
        return this.pos;
    }

    @Override
    public IPosition getPosition() {
        return this.pos;
    }

    @Override
    public void setPosition(IPosition position) {
        this.pos = position.copy();
    }

    @Override
    public IPosition size() {
        return this.size;
    }

    @Override
    public IPosition getSize() {
        return this.size;
    }

    @Override
    public void setSize(IPosition size) {
        this.size = size.copy();
    }

    public String toString() {
        return super.toString() + " [" + this.pos().x() + "," + this.pos().y() + "] [" + this.size().x() + "," + this.size().y() + "]";
    }

    @Override
    public boolean contains(IPosition position) {
        return position.x() > this.pos().x() && position.y() > this.pos.y() && position.x() < this.pos().x() + this.size().x() && position.y() < this.pos().y() + this.size().y();
    }

    @Override
    public float x() {
        return this.pos().x();
    }

    @Override
    public float y() {
        return this.pos().y();
    }

    @Override
    public float w() {
        return this.size().x();
    }

    @Override
    public float h() {
        return this.size().y();
    }
}

