/*
 * Decompiled with CFR 0.152.
 */
package binnie.craftgui.core;

import binnie.craftgui.core.IWidget;
import binnie.craftgui.core.Widget;
import binnie.craftgui.events.Event;
import binnie.craftgui.events.core.EventHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;

public class WidgetData {
    Class<?> widgetClass;
    List<EventListener> listeners = new ArrayList<EventListener>();

    public WidgetData(Class<? extends IWidget> widgetClass) {
        this.widgetClass = widgetClass;
        Class<? extends IWidget> currentClass = widgetClass;
        while (!currentClass.equals(Widget.class)) {
            try {
                for (Method method : currentClass.getMethods()) {
                    if (!method.isAnnotationPresent(EventHandler.class)) continue;
                    Class<?> eventClass = method.getParameterTypes()[0];
                    this.listeners.add(new EventListener(this, method, eventClass));
                    System.out.println(widgetClass + " has listener for event " + eventClass);
                }
            }
            catch (Exception e) {
                System.err.println("Error when registering widget class " + currentClass.getName());
                e.printStackTrace(System.err);
            }
            currentClass = currentClass.getSuperclass();
        }
    }

    public void handleEvent(IWidget widget, Event event) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
        for (EventListener listener : this.listeners) {
            if (!listener.handlesEvent(widget, event)) continue;
            listener.invoke(widget, event);
        }
    }

    static class EventListener {
        WidgetData widgetdata;
        Method method;
        EventHandler eventHandler;
        Class<? extends Event> eventClass;

        private EventListener(WidgetData widgetdata, Method method, Class<? extends Event> eventClass) {
            this.widgetdata = widgetdata;
            this.method = method;
            this.eventClass = eventClass;
            this.eventHandler = method.getAnnotation(EventHandler.class);
        }

        public boolean handlesEvent(IWidget widget, Event event) {
            return this.eventClass.isInstance(event) && this.eventHandler.origin().handlesEvent(widget, event);
        }

        public void invoke(IWidget widget, Event event) throws IllegalArgumentException, IllegalAccessException, InvocationTargetException {
            this.method.invoke((Object)widget, event);
        }
    }
}

