/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.transfer;

import binnie.core.liquid.LiquidManager;
import binnie.core.machines.Machine;
import binnie.core.machines.inventory.IInventorySlots;
import binnie.core.machines.inventory.IValidatedTankContainer;
import binnie.core.machines.power.ITankMachine;
import binnie.extratrees.alcohol.Cocktail;
import binnie.extratrees.alcohol.Glassware;
import binnie.extratrees.alcohol.ItemGlassware;
import binnie.extratrees.alcohol.drink.DrinkType;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class TransferRequest {
    ItemStack itemToTransfer = null;
    ItemStack returnItem = null;
    IInventory origin;
    IInventory destination;
    int[] targetSlots = new int[0];
    int[] targetTanks = new int[0];
    boolean transferLiquids = true;
    boolean ignoreReadOnly = false;
    List<TransferSlot> insertedSlots = new ArrayList<TransferSlot>();
    List<Integer> insertedTanks = new ArrayList<Integer>();

    public TransferRequest(ItemStack toTransfer, IInventory destination) {
        int[] target = new int[destination.func_70302_i_()];
        for (int i = 0; i < target.length; ++i) {
            target[i] = i;
        }
        int[] targetTanks = new int[]{};
        if (destination instanceof ITankMachine) {
            targetTanks = new int[((ITankMachine)destination).getTanks().length];
            for (int i = 0; i < targetTanks.length; ++i) {
                targetTanks[i] = i;
            }
        }
        if (toTransfer != null) {
            this.setItemToTransfer(toTransfer.func_77946_l());
            this.setReturnItem(toTransfer.func_77946_l());
        }
        this.setOrigin(null);
        this.setDestination(destination);
        this.setTargetSlots(target);
        this.setTargetTanks(targetTanks);
        this.transferLiquids = true;
    }

    private void setItemToTransfer(ItemStack itemToTransfer) {
        this.itemToTransfer = itemToTransfer;
    }

    private void setReturnItem(ItemStack returnItem) {
        this.returnItem = returnItem;
    }

    public TransferRequest setOrigin(IInventory origin) {
        this.origin = origin;
        return this;
    }

    private void setDestination(IInventory destination) {
        this.destination = destination;
    }

    public TransferRequest setTargetSlots(int[] targetSlots) {
        this.targetSlots = targetSlots;
        return this;
    }

    public TransferRequest setTargetTanks(int[] targetTanks) {
        this.targetTanks = targetTanks;
        return this;
    }

    public TransferRequest ignoreValidation() {
        this.ignoreReadOnly = true;
        return this;
    }

    public ItemStack getReturnItem() {
        return this.returnItem;
    }

    public ItemStack transfer(boolean doAdd) {
        ItemStack item = this.returnItem;
        if (item == null || this.destination == null) {
            return null;
        }
        for (int slot : this.targetSlots) {
            if (!this.destination.func_94041_b(slot, item) && !this.ignoreReadOnly || this.destination instanceof IInventorySlots && ((IInventorySlots)this.destination).getSlot(slot) != null && ((IInventorySlots)this.destination).getSlot(slot).isRecipe() || this.destination.func_70301_a(slot) == null || !item.func_77985_e()) continue;
            ItemStack merged = this.destination.func_70301_a(slot).func_77946_l();
            ItemStack[] newStacks = TransferRequest.mergeStacks(item.func_77946_l(), merged.func_77946_l());
            item = newStacks[0];
            if (!TransferRequest.areItemsEqual(merged, newStacks[1])) {
                this.insertedSlots.add(new TransferSlot(slot, this.destination));
            }
            if (doAdd) {
                this.destination.func_70299_a(slot, newStacks[1]);
            }
            if (item != null) continue;
            return null;
        }
        for (int slot : this.targetSlots) {
            if (!this.destination.func_94041_b(slot, item) && !this.ignoreReadOnly || this.destination instanceof IInventorySlots && ((IInventorySlots)this.destination).getSlot(slot) != null && ((IInventorySlots)this.destination).getSlot(slot).isRecipe() || this.destination.func_70301_a(slot) != null || item == null) continue;
            this.insertedSlots.add(new TransferSlot(slot, this.destination));
            if (doAdd) {
                this.destination.func_70299_a(slot, item.func_77946_l());
            }
            return null;
        }
        if (this.transferLiquids && this.destination instanceof ITankMachine) {
            for (int tankID : this.targetTanks) {
                item = this.transferToTank(item, this.origin, (ITankMachine)this.destination, tankID, doAdd);
                item = this.transferFromTank(item, this.origin, (ITankMachine)this.destination, tankID, doAdd);
            }
        }
        this.setReturnItem(item);
        return this.getReturnItem();
    }

    private static boolean areItemsEqual(ItemStack merged, ItemStack itemstack) {
        return ItemStack.func_77970_a((ItemStack)itemstack, (ItemStack)merged) && itemstack.func_77969_a(merged);
    }

    public static ItemStack[] mergeStacks(ItemStack itemstack, ItemStack merged) {
        int space;
        if (TransferRequest.areItemsEqual(itemstack, merged) && (space = merged.func_77976_d() - merged.field_77994_a) > 0) {
            if (itemstack.field_77994_a > space) {
                itemstack.field_77994_a -= space;
                merged.field_77994_a += space;
            } else if (itemstack.field_77994_a <= space) {
                merged.field_77994_a += itemstack.field_77994_a;
                itemstack = null;
            }
        }
        return new ItemStack[]{itemstack, merged};
    }

    private ItemStack transferToTank(ItemStack item, IInventory origin, ITankMachine destination, int tankID, boolean doAdd) {
        TransferRequest containersDump;
        ItemStack containersThatCantBeDumped;
        if (item == null) {
            return item;
        }
        FluidStack containerLiquid = null;
        FluidContainerRegistry.FluidContainerData containerLiquidData = null;
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (!data.filledContainer.func_77969_a(item)) continue;
            containerLiquidData = data;
            containerLiquid = data.fluid.copy();
            break;
        }
        if (containerLiquid == null) {
            return item;
        }
        IFluidTank tank = destination.getTanks()[tankID];
        IValidatedTankContainer validated = Machine.getInterface(IValidatedTankContainer.class, destination);
        if (validated != null && !validated.isLiquidValidForTank(containerLiquid, tankID)) {
            return item;
        }
        FluidStack largeAmountOfLiquid = containerLiquid.copy();
        largeAmountOfLiquid.amount = tank.getCapacity();
        int amountAdded = tank.fill(largeAmountOfLiquid, false);
        int numberOfContainersToAdd = amountAdded / containerLiquid.amount;
        if (numberOfContainersToAdd > item.field_77994_a) {
            numberOfContainersToAdd = item.field_77994_a;
        }
        ItemStack leftOverContainers = item.func_77946_l();
        leftOverContainers.field_77994_a -= numberOfContainersToAdd;
        if (leftOverContainers.field_77994_a <= 0) {
            leftOverContainers = null;
        }
        ItemStack emptyContainers = containerLiquidData.emptyContainer.func_77946_l();
        emptyContainers.field_77994_a = 0;
        emptyContainers.field_77994_a += numberOfContainersToAdd;
        if (emptyContainers.field_77994_a <= 0) {
            emptyContainers = null;
        }
        if ((containersThatCantBeDumped = (containersDump = new TransferRequest(emptyContainers, origin)).transfer(false)) != null) {
            return item;
        }
        if (doAdd) {
            FluidStack liquidToFillTank = containerLiquid.copy();
            liquidToFillTank.amount *= numberOfContainersToAdd;
            tank.fill(liquidToFillTank, true);
            containersDump.transfer(true);
        }
        return leftOverContainers;
    }

    private ItemStack transferFromTank(ItemStack item, IInventory origin, ITankMachine destination, int tankID, boolean doAdd) {
        TransferRequest containersDump;
        ItemStack containersThatCantBeDumped;
        if (item == null) {
            return item;
        }
        IFluidTank tank = destination.getTanks()[tankID];
        FluidStack liquidInTank = tank.getFluid();
        if (liquidInTank == null) {
            return item;
        }
        FluidContainerRegistry.FluidContainerData containerLiquidData = null;
        for (FluidContainerRegistry.FluidContainerData data : FluidContainerRegistry.getRegisteredFluidContainerData()) {
            if (!data.emptyContainer.func_77969_a(item) || !liquidInTank.isFluidEqual(data.fluid)) continue;
            containerLiquidData = data;
            break;
        }
        FluidStack fluid = null;
        ItemStack filled = null;
        if (containerLiquidData != null) {
            fluid = containerLiquidData.fluid;
            filled = containerLiquidData.filledContainer;
        } else if (ItemGlassware.item != null && item.field_77993_c == ItemGlassware.item.field_77779_bT && Cocktail.isIngredient(liquidInTank.getFluid().getName())) {
            Glassware glassware = Glassware.values()[item.func_77960_j()];
            fluid = LiquidManager.getLiquidStack(liquidInTank.getFluid().getName(), glassware.getCapacity());
            filled = DrinkType.get(glassware, fluid.getFluid().getName(), 1);
        }
        if (fluid == null || filled == null) {
            return item;
        }
        int maximumExtractedLiquid = item.field_77994_a * fluid.amount;
        FluidStack drainedLiquid = tank.drain(maximumExtractedLiquid, false);
        int amountInTank = drainedLiquid == null ? 0 : drainedLiquid.amount;
        int numberOfContainersToFill = amountInTank / fluid.amount;
        if (numberOfContainersToFill > item.field_77994_a) {
            numberOfContainersToFill = item.field_77994_a;
        }
        ItemStack leftOverContainers = item.func_77946_l();
        leftOverContainers.field_77994_a -= numberOfContainersToFill;
        if (leftOverContainers.field_77994_a <= 0) {
            leftOverContainers = null;
        }
        ItemStack filledContainers = filled.func_77946_l();
        filledContainers.field_77994_a = 0;
        filledContainers.field_77994_a += numberOfContainersToFill;
        if (filledContainers.field_77994_a <= 0) {
            filledContainers = null;
        }
        if ((containersThatCantBeDumped = (containersDump = new TransferRequest(filledContainers, origin)).transfer(false)) != null) {
            return item;
        }
        if (doAdd) {
            tank.drain(maximumExtractedLiquid, true);
            containersDump.transfer(true);
        }
        return leftOverContainers;
    }

    public List<TransferSlot> getInsertedSlots() {
        return this.insertedSlots;
    }

    public List<Integer> getInsertedTanks() {
        return this.insertedTanks;
    }

    public static class TransferSlot {
        public int id;
        public IInventory inventory;

        public TransferSlot(int id, IInventory inventory) {
            this.id = id;
            this.inventory = inventory;
        }
    }
}

