/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.power;

import binnie.core.machines.power.ITankMachine;
import forestry.api.core.INBTTagable;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class TankInfo
implements INBTTagable {
    public FluidStack liquid;
    float capacity = 0.0f;

    public TankInfo(IFluidTank tank) {
        this.capacity = tank.getCapacity();
        this.liquid = tank.getFluid();
    }

    public TankInfo() {
    }

    public float getAmount() {
        return this.liquid == null ? 0.0f : (float)this.liquid.amount;
    }

    public float getCapacity() {
        return this.capacity;
    }

    public boolean isEmpty() {
        return this.liquid == null;
    }

    public Icon getIcon() {
        return this.liquid.getFluid().getStillIcon();
    }

    public String getName() {
        return this.liquid == null ? "" : this.liquid.getFluid().getLocalizedName();
    }

    public void readFromNBT(NBTTagCompound nbt) {
        this.capacity = nbt.func_74762_e("capacity");
        if (nbt.func_74764_b("liquid")) {
            this.liquid = FluidStack.loadFluidStackFromNBT((NBTTagCompound)nbt.func_74775_l("liquid"));
        }
    }

    public void writeToNBT(NBTTagCompound nbt) {
        nbt.func_74768_a("capacity", (int)this.getCapacity());
        if (this.liquid == null) {
            return;
        }
        NBTTagCompound tag = new NBTTagCompound();
        this.liquid.writeToNBT(tag);
        nbt.func_74782_a("liquid", (NBTBase)tag);
    }

    public static TankInfo[] get(ITankMachine machine) {
        TankInfo[] info = new TankInfo[machine.getTanks().length];
        for (int i = 0; i < info.length; ++i) {
            info[i] = new TankInfo(machine.getTanks()[i]);
        }
        return info;
    }
}

