/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.power;

import binnie.core.machines.IMachine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.component.IBuildcraft;
import binnie.core.machines.power.IPoweredMachine;
import binnie.core.machines.power.PowerInfo;
import binnie.core.triggers.TriggerData;
import binnie.core.triggers.TriggerPower;
import buildcraft.api.power.PowerHandler;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeDirection;

public class ComponentPowerReceptor
extends MachineComponent
implements IPoweredMachine,
IBuildcraft.TriggerProvider {
    PowerHandler handler;
    float previousPower = 0.0f;
    LinkedList<Float> inputs = new LinkedList();
    static final int inputAverageTicks = 20;
    int[] config;

    public ComponentPowerReceptor(IMachine machine) {
        this(machine, 1000);
    }

    public ComponentPowerReceptor(IMachine machine, int storage) {
        super(machine);
        this.handler = new PowerHandler(this, PowerHandler.Type.MACHINE);
        this.setConfig(10, 5, 40, 20, storage);
        this.handler.configurePowerPerdition(0, 100);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.handler.readFromNBT(nbttagcompound);
        this.getPowerHandler().configure(this.config[1], this.config[2], this.config[3], this.config[4]);
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        this.handler.writeToNBT(nbttagcompound);
    }

    @Override
    public void onUpdate() {
        this.handler.update();
    }

    @Override
    public PowerInfo getPowerInfo() {
        return new PowerInfo(this, 0.0f);
    }

    @Override
    public final void getTriggers(List<TriggerData> triggers) {
        triggers.add(TriggerPower.powerNone(this));
        triggers.add(TriggerPower.powerLow(this));
        triggers.add(TriggerPower.powerMedium(this));
        triggers.add(TriggerPower.powerHigh(this));
        triggers.add(TriggerPower.powerFull(this));
    }

    @Override
    public void setConfig(int latency, int minEnergy, int maxEnergy, int activeEnergy, int storage) {
        this.config = new int[]{latency, minEnergy, maxEnergy, activeEnergy, storage};
        this.getPowerHandler().configure(minEnergy, maxEnergy, activeEnergy, storage);
    }

    @Override
    public PowerHandler.PowerReceiver getPowerReceiver(ForgeDirection side) {
        return this.getPowerHandler().getPowerReceiver();
    }

    @Override
    public void doWork(PowerHandler workProvider) {
    }

    @Override
    public World getWorld() {
        return this.getMachine().getWorld();
    }

    @Override
    public PowerHandler getPowerHandler() {
        return this.handler;
    }
}

