/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.machines.IMachine;
import binnie.core.machines.MachineComponent;
import binnie.core.machines.inventory.MachineSide;
import binnie.core.machines.inventory.TankSlot;
import binnie.core.machines.power.ITankMachine;
import binnie.core.machines.power.TankInfo;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.ForgeDirection;
import net.minecraftforge.fluids.Fluid;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidTankInfo;
import net.minecraftforge.fluids.IFluidTank;

public class ComponentTankContainer
extends MachineComponent
implements ITankMachine {
    Map<Integer, TankSlot> tanks = new LinkedHashMap<Integer, TankSlot>();

    public ComponentTankContainer(IMachine machine) {
        super(machine);
    }

    @Override
    public final void addTank(int index, String name, int capacity) {
        this.tanks.put(index, new TankSlot(index, name, capacity));
    }

    public final int fill(ForgeDirection from, FluidStack resource, boolean doFill) {
        int index = this.getTankIndexToFill(from, resource);
        if (this.tanks.containsKey(index)) {
            return this.fill(index, resource, doFill);
        }
        return 0;
    }

    public final FluidStack drain(ForgeDirection from, int maxDrain, boolean doDrain) {
        int index = this.getTankIndexToDrain(from);
        if (this.tanks.containsKey(index)) {
            return this.drain(index, maxDrain, doDrain);
        }
        return null;
    }

    public final int fill(int tankIndex, FluidStack resource, boolean doFill) {
        if (!this.tanks.containsKey(tankIndex)) {
            return 0;
        }
        if (!this.isLiquidValidForTank(resource, tankIndex)) {
            return 0;
        }
        TankSlot tank = this.tanks.get(tankIndex);
        return tank.getTank().fill(resource, doFill);
    }

    public final FluidStack drain(int tankIndex, int maxDrain, boolean doDrain) {
        if (!this.tanks.containsKey(tankIndex)) {
            return null;
        }
        TankSlot tank = this.tanks.get(tankIndex);
        return tank.getTank().drain(maxDrain, doDrain);
    }

    public int getTankIndexToFill(ForgeDirection from, FluidStack resource) {
        for (TankSlot tank : this.tanks.values()) {
            if (!MachineSide.contains(tank.getInputSides(), from) || tank.getContent() != null && !tank.getContent().isFluidEqual(resource)) continue;
            return tank.getIndex();
        }
        return -1;
    }

    public int getTankIndexToDrain(ForgeDirection from) {
        for (TankSlot tank : this.tanks.values()) {
            if (tank.getContent() == null || !MachineSide.contains(tank.getOutputSides(), from)) continue;
            return tank.getIndex();
        }
        return -1;
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("liquidTanks")) {
            NBTTagList tanksNBT = nbttagcompound.func_74761_m("liquidTanks");
            for (int i = 0; i < tanksNBT.func_74745_c(); ++i) {
                NBTTagCompound tankNBT = (NBTTagCompound)tanksNBT.func_74743_b(i);
                int index = tankNBT.func_74762_e("index");
                if (!this.tanks.containsKey(index)) continue;
                this.tanks.get(index).readFromNBT(tankNBT);
            }
        }
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        NBTTagList tanksNBT = new NBTTagList();
        for (Map.Entry<Integer, TankSlot> entry : this.tanks.entrySet()) {
            NBTTagCompound tankNBT = new NBTTagCompound();
            tankNBT.func_74768_a("index", entry.getKey().intValue());
            entry.getValue().writeToNBT(tankNBT);
            tanksNBT.func_74742_a((NBTBase)tankNBT);
        }
        nbttagcompound.func_74782_a("liquidTanks", (NBTBase)tanksNBT);
    }

    @Override
    public boolean isTankReadOnly(int tank) {
        return this.tanks.get(tank).isReadOnly();
    }

    @Override
    public boolean isLiquidValidForTank(FluidStack liquid, int tank) {
        TankSlot slot = this.getTankSlot(tank);
        return slot == null ? false : slot.isValid(liquid) && !slot.isReadOnly();
    }

    @Override
    public TankInfo[] getTankInfos() {
        return TankInfo.get(this);
    }

    @Override
    public IFluidTank getTank(int index) {
        return this.getTanks()[index];
    }

    @Override
    public IFluidTank[] getTanks() {
        ArrayList<IFluidTank> ltanks = new ArrayList<IFluidTank>();
        for (TankSlot tank : this.tanks.values()) {
            ltanks.add(tank.getTank());
        }
        return ltanks.toArray(new IFluidTank[0]);
    }

    @Override
    public TankSlot getTankSlot(int index) {
        return this.tanks.get(index);
    }

    public FluidStack drain(ForgeDirection from, FluidStack resource, boolean doDrain) {
        return null;
    }

    public boolean canFill(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public boolean canDrain(ForgeDirection from, Fluid fluid) {
        return true;
    }

    public FluidTankInfo[] getTankInfo(ForgeDirection from) {
        FluidTankInfo[] info = new FluidTankInfo[this.getTanks().length];
        for (int i = 0; i < info.length; ++i) {
            info[i] = new FluidTankInfo(this.getTanks()[i]);
        }
        return info;
    }
}

