/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.machines.IMachine;
import binnie.core.machines.inventory.ComponentInventory;
import binnie.core.machines.inventory.IInventoryMachine;
import binnie.core.machines.inventory.InventorySlot;
import binnie.core.machines.transfer.TransferRequest;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraftforge.common.ForgeDirection;

public class ComponentInventorySlots
extends ComponentInventory
implements IInventoryMachine {
    Map<Integer, InventorySlot> inventory = new LinkedHashMap<Integer, InventorySlot>();

    public ComponentInventorySlots(IMachine machine) {
        super(machine);
    }

    public int func_70302_i_() {
        int size = 0;
        for (Integer index : this.inventory.keySet()) {
            size = Math.max(size, index + 1);
        }
        return size;
    }

    public ItemStack func_70301_a(int index) {
        if (this.inventory.containsKey(index)) {
            return this.inventory.get(index).getContent();
        }
        return null;
    }

    public ItemStack func_70298_a(int index, int amount) {
        if (this.inventory.containsKey(index)) {
            ItemStack stack = this.inventory.get(index).decrStackSize(amount);
            this.func_70296_d();
            return stack;
        }
        return null;
    }

    public ItemStack func_70304_b(int var1) {
        return null;
    }

    public void func_70299_a(int index, ItemStack itemStack) {
        if (this.inventory.containsKey(index) && (itemStack == null || this.inventory.get(index).isValid(itemStack))) {
            this.inventory.get(index).setContent(itemStack);
        }
        this.func_70296_d();
    }

    protected void transferItem(int indexFrom, int indexTo) {
        if (this.inventory.containsKey(indexFrom) && this.inventory.containsKey(indexTo)) {
            ItemStack newStack = this.inventory.get(indexFrom).getContent().func_77946_l();
            this.inventory.get(indexFrom).setContent(null);
            this.inventory.get(indexTo).setContent(newStack);
        }
        this.func_70296_d();
    }

    public String func_70303_b() {
        return "";
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer var1) {
        return true;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        if (nbttagcompound.func_74764_b("inventory")) {
            NBTTagList inventoryNBT = nbttagcompound.func_74761_m("inventory");
            for (int i = 0; i < inventoryNBT.func_74745_c(); ++i) {
                NBTTagCompound slotNBT = (NBTTagCompound)inventoryNBT.func_74743_b(i);
                int index = slotNBT.func_74762_e("id");
                if (slotNBT.func_74764_b("Slot")) {
                    index = slotNBT.func_74771_c("Slot") & 0xFF;
                }
                if (!this.inventory.containsKey(index)) continue;
                this.inventory.get(index).readFromNBT(slotNBT);
            }
        }
        this.func_70296_d();
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        NBTTagList inventoryNBT = new NBTTagList();
        for (Map.Entry<Integer, InventorySlot> entry : this.inventory.entrySet()) {
            NBTTagCompound slotNBT = new NBTTagCompound();
            slotNBT.func_74768_a("id", entry.getKey().intValue());
            entry.getValue().writeToNBT(slotNBT);
            inventoryNBT.func_74742_a((NBTBase)slotNBT);
        }
        nbttagcompound.func_74782_a("inventory", (NBTBase)inventoryNBT);
    }

    @Override
    public final void addSlot(int index, String name) {
        this.inventory.put(index, new InventorySlot(index, name));
    }

    @Override
    public final void addSlotArray(int[] indexes, String name) {
        for (int k : indexes) {
            this.addSlot(k, name);
        }
    }

    @Override
    public InventorySlot getSlot(int index) {
        if (this.inventory.containsKey(index)) {
            return this.inventory.get(index);
        }
        return null;
    }

    @Override
    public InventorySlot[] getAllSlots() {
        return this.inventory.values().toArray(new InventorySlot[0]);
    }

    @Override
    public InventorySlot[] getSlots(int[] indexes) {
        ArrayList<InventorySlot> list = new ArrayList<InventorySlot>();
        for (int i : indexes) {
            if (this.getSlot(i) == null) continue;
            list.add(this.getSlot(i));
        }
        return list.toArray(new InventorySlot[0]);
    }

    @Override
    public boolean isReadOnly(int slot) {
        InventorySlot iSlot = this.getSlot(slot);
        return iSlot == null ? true : iSlot.isReadOnly();
    }

    public boolean func_94042_c() {
        return true;
    }

    public boolean func_94041_b(int slot, ItemStack itemStack) {
        InventorySlot iSlot = this.getSlot(slot);
        return iSlot == null ? false : iSlot.isValid(itemStack) && !this.isReadOnly(slot);
    }

    @Override
    public int addItem(ItemStack stack, boolean doAdd, ForgeDirection from) {
        ArrayList<Integer> acceptingSlots = new ArrayList<Integer>();
        for (Map.Entry<Integer, InventorySlot> entry : this.inventory.entrySet()) {
            if (!this.func_102007_a(entry.getKey(), null, from.ordinal())) continue;
            acceptingSlots.add(entry.getKey());
        }
        int[] array = new int[acceptingSlots.size()];
        for (int i = 0; i < acceptingSlots.size(); ++i) {
            array[i] = (Integer)acceptingSlots.get(i);
        }
        ItemStack result = new TransferRequest(stack, this).setTargetSlots(array).transfer(doAdd);
        return result == null ? stack.field_77994_a : stack.field_77994_a - result.field_77994_a;
    }

    @Override
    public ItemStack[] extractItem(boolean doRemove, ForgeDirection from, int maxItemCount) {
        ArrayList<ItemStack> output = new ArrayList<ItemStack>();
        for (Map.Entry<Integer, InventorySlot> entry : this.inventory.entrySet()) {
            if (!this.func_102008_b(entry.getKey(), null, from.ordinal()) || entry.getValue().getContent() == null) continue;
            ItemStack fetched = null;
            if (doRemove) {
                fetched = this.func_70298_a(entry.getKey(), maxItemCount);
            } else {
                fetched = entry.getValue().getContent();
                if (fetched != null) {
                    fetched.field_77994_a = Math.min(maxItemCount, fetched.field_77994_a);
                    if (fetched.field_77994_a == 0) {
                        fetched = null;
                    }
                }
            }
            if (fetched == null) continue;
            output.add(fetched);
            break;
        }
        return output.toArray(new ItemStack[0]);
    }

    @Override
    public void onDestruction() {
        for (InventorySlot slot : this.inventory.values()) {
            ItemStack stack = slot.getContent();
            if (stack == null) continue;
            float f = this.getMachine().getWorld().field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f1 = this.getMachine().getWorld().field_73012_v.nextFloat() * 0.8f + 0.1f;
            float f2 = this.getMachine().getWorld().field_73012_v.nextFloat() * 0.8f + 0.1f;
            if (stack.field_77994_a == 0) {
                stack.field_77994_a = 1;
            }
            EntityItem entityitem = new EntityItem(this.getMachine().getWorld(), (double)((float)this.getMachine().getTileEntity().field_70329_l + f), (double)((float)this.getMachine().getTileEntity().field_70330_m + f1), (double)((float)this.getMachine().getTileEntity().field_70327_n + f2), stack.func_77946_l());
            float accel = 0.05f;
            entityitem.field_70159_w = (float)this.getMachine().getWorld().field_73012_v.nextGaussian() * accel;
            entityitem.field_70181_x = (float)this.getMachine().getWorld().field_73012_v.nextGaussian() * accel + 0.2f;
            entityitem.field_70179_y = (float)this.getMachine().getWorld().field_73012_v.nextGaussian() * accel;
            this.getMachine().getWorld().func_72838_d((Entity)entityitem);
        }
    }

    public int[] func_94128_d(int var1) {
        ArrayList<Integer> slots = new ArrayList<Integer>();
        for (InventorySlot slot : this.inventory.values()) {
            if (!slot.canInsert() && !slot.canExtract()) continue;
            slots.add(slot.getIndex());
        }
        int[] ids = new int[slots.size()];
        for (int i = 0; i < slots.size(); ++i) {
            ids[i] = (Integer)slots.get(i);
        }
        return ids;
    }

    public boolean func_102007_a(int i, ItemStack itemstack, int j) {
        return this.func_94041_b(i, itemstack) && this.getSlot(i).canInsert(ForgeDirection.getOrientation((int)j));
    }

    public boolean func_102008_b(int i, ItemStack itemstack, int j) {
        return this.getSlot(i).canExtract(ForgeDirection.getOrientation((int)j));
    }
}

