/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines.inventory;

import binnie.core.machines.inventory.MachineSide;
import binnie.core.machines.inventory.Validator;
import binnie.core.util.IValidator;
import forestry.api.core.INBTTagable;
import java.util.EnumSet;
import net.minecraftforge.common.ForgeDirection;

public abstract class BaseSlot<T>
implements INBTTagable,
IValidator<T> {
    EnumSet<MachineSide> inputSides = EnumSet.allOf(MachineSide.class);
    EnumSet<MachineSide> outputSides = EnumSet.allOf(MachineSide.class);
    Validator<T> validator = null;
    boolean readOnly = false;
    int index;
    String name = "Slot";

    public BaseSlot(int index, String name) {
        this.setIndex(index);
        this.setName(name);
    }

    public void setReadOnly() {
        this.readOnly = true;
        this.forbidInsertion();
    }

    @Override
    public boolean isValid(T item) {
        if (item == null) {
            return true;
        }
        if (this.validator != null) {
            return this.validator.isValid(item);
        }
        return true;
    }

    public abstract T getContent();

    public abstract void setContent(T var1);

    public void setValidator(Validator<T> val) {
        this.validator = val;
    }

    public boolean isEmpty() {
        return this.getContent() == null;
    }

    public boolean isReadOnly() {
        return this.readOnly;
    }

    public int getIndex() {
        return this.index;
    }

    public void setIndex(int index) {
        this.index = index;
    }

    public boolean canInsert() {
        return !this.inputSides.isEmpty();
    }

    public boolean canExtract() {
        return !this.outputSides.isEmpty();
    }

    public void forbidInteraction() {
        this.forbidInsertion();
        this.forbidExtraction();
    }

    public void setInputSides(EnumSet<MachineSide> sides) {
        this.inputSides = sides;
    }

    public void setOutputSides(EnumSet<MachineSide> sides) {
        this.outputSides = sides;
    }

    public void forbidExtraction() {
        this.setOutputSides(MachineSide.None);
    }

    public void forbidInsertion() {
        this.setInputSides(MachineSide.None);
    }

    public boolean canInsert(ForgeDirection dir) {
        return MachineSide.contains(this.inputSides, dir);
    }

    public boolean canExtract(ForgeDirection dir) {
        return MachineSide.contains(this.outputSides, dir);
    }

    public EnumSet<MachineSide> getInputSides() {
        return this.inputSides;
    }

    public EnumSet<MachineSide> getOutputSides() {
        return this.outputSides;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Validator<T> getValidator() {
        return this.validator;
    }
}

