/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.machines;

import binnie.core.machines.IMachine;
import binnie.core.machines.inventory.IChargedSlots;
import binnie.core.machines.power.IPoweredMachine;
import binnie.core.machines.power.ITankMachine;
import binnie.core.util.ItemStackSet;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.IFluidTank;

public class MachineUtil {
    IMachine machine;

    public MachineUtil(IMachine machine) {
        this.machine = machine;
    }

    private IInventory getInventory() {
        return this.machine.getInterface(IInventory.class);
    }

    private ITankMachine getTankContainer() {
        return this.machine.getInterface(ITankMachine.class);
    }

    private IPoweredMachine getPoweredMachine() {
        return this.machine.getInterface(IPoweredMachine.class);
    }

    public boolean isSlotEmpty(int slot) {
        return this.getInventory().func_70301_a(slot) == null;
    }

    public IFluidTank getTank(int id) {
        return this.getTankContainer().getTanks()[id];
    }

    public boolean spaceInTank(int id, int amount) {
        IFluidTank tank = this.getTank(id);
        int space = tank.getCapacity() - tank.getFluidAmount();
        return amount < space;
    }

    public ItemStack getStack(int slot) {
        return this.getInventory().func_70301_a(slot);
    }

    public void deleteStack(int slot) {
        this.setStack(slot, null);
    }

    public ItemStack decreaseStack(int slotWood, int amount) {
        return this.getInventory().func_70298_a(slotWood, amount);
    }

    public void setStack(int slot, ItemStack stack) {
        this.getInventory().func_70299_a(slot, stack);
    }

    public void fillTank(int id, FluidStack liquidStack) {
        IFluidTank tank = this.getTank(id);
        tank.fill(liquidStack, true);
    }

    public void addStack(int slot, ItemStack addition) {
        if (this.isSlotEmpty(slot)) {
            this.setStack(slot, addition);
        } else {
            ItemStack merge = this.getStack(slot);
            if (merge.func_77969_a(addition) && merge.field_77994_a + addition.field_77994_a <= merge.func_77976_d()) {
                merge.field_77994_a += addition.field_77994_a;
                this.setStack(slot, merge);
            }
        }
    }

    public FluidStack drainTank(int tank, int amount) {
        return this.getTank(tank).drain(amount, true);
    }

    public boolean liquidInTank(int tank, int amount) {
        return this.getTank(tank).drain(amount, false) != null && this.getTank((int)tank).drain((int)amount, (boolean)false).amount == amount;
    }

    public void damageItem(int slot, int damage) {
        ItemStack item = this.getStack(slot);
        if (damage < 0) {
            item.func_77964_b(Math.max(0, item.func_77960_j() + damage));
        } else if (item.func_96631_a(damage, new Random())) {
            this.setStack(slot, null);
        }
        this.setStack(slot, item);
    }

    public boolean isTankEmpty(int tankInput) {
        return this.getTank(tankInput).getFluidAmount() == 0;
    }

    public FluidStack getFluid(int tankInput) {
        return this.getTank(tankInput).getFluid() == null ? null : this.getTank(tankInput).getFluid();
    }

    public ItemStack[] getStacks(int[] slotGrains) {
        ItemStack[] stacks = new ItemStack[slotGrains.length];
        for (int i = 0; i < slotGrains.length; ++i) {
            stacks[i] = this.getStack(slotGrains[i]);
        }
        return stacks;
    }

    public ItemStack hasIngredients(int recipe, int[] inventory) {
        return null;
    }

    public boolean hasIngredients(int[] recipe, int[] inventory) {
        ItemStackSet requiredStacks = new ItemStackSet();
        for (ItemStack stack : this.getStacks(recipe)) {
            requiredStacks.add(stack);
        }
        ItemStackSet inventoryStacks = new ItemStackSet();
        for (ItemStack stack : this.getStacks(inventory)) {
            inventoryStacks.add(stack);
        }
        requiredStacks.removeAll(inventoryStacks);
        return requiredStacks.isEmpty();
    }

    public void usePower(float powerUsage) {
        this.getPoweredMachine().getPowerHandler().useEnergy(0.0f, powerUsage, true);
    }

    public boolean hasPower(float powerUsage) {
        return this.getPoweredMachine().getPowerHandler().useEnergy(0.0f, powerUsage, false) >= powerUsage;
    }

    public float getSlotCharge(int slot) {
        return this.machine.getInterface(IChargedSlots.class).getCharge(slot);
    }
}

