/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.liquid;

import binnie.core.BinnieCore;
import binnie.core.liquid.IFluidType;
import binnie.core.resource.ResourceManager;
import binnie.core.resource.ResourceType;
import java.awt.Color;
import java.io.IOException;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.ResourceLocation;

public class TextureBlankLiquid
extends TextureAtlasSprite {
    public IFluidType type;

    public String getID() {
        return "liquids/" + this.type.getIdentifier();
    }

    protected TextureBlankLiquid(IFluidType type) {
        super("binniecore:liquids/" + type.getIdentifier());
        this.type = type;
    }

    public boolean load(net.minecraft.client.resources.ResourceManager manager, ResourceLocation location) throws IOException {
        try {
            boolean loaded = super.load(manager, ResourceManager.getPNG(BinnieCore.instance, ResourceType.Block, "liquids/blank").getResourceLocation());
            int size = this.func_110970_k();
            Color fluidCol = new Color(this.type.getColour());
            for (int animation = 0; animation < this.func_110970_k(); ++animation) {
                int[] data = this.func_110965_a(animation);
                for (int i = 0; i < data.length; ++i) {
                    Color dataCol = new Color(data[i]);
                    Color newCol = new Color(dataCol.getRed() * dataCol.getAlpha() * fluidCol.getRed() / 65025, dataCol.getGreen() * dataCol.getAlpha() * fluidCol.getGreen() / 65025, dataCol.getBlue() * dataCol.getAlpha() * fluidCol.getBlue() / 65025, dataCol.getAlpha() * fluidCol.getAlpha() / 255);
                    data[i] = this.type.getTransparency() * 0x1000000 + dataCol.getRGB();
                }
                this.field_110976_a.set(animation, data);
            }
            if (!loaded) {
                System.out.println("Texture Error!");
            }
            return loaded;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }
}

