/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.core.genetics.BreedingSystem;
import forestry.api.apiculture.IBeeRoot;
import forestry.api.arboriculture.ITreeRoot;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.ISpeciesRoot;
import forestry.api.lepidopterology.IButterflyRoot;
import net.minecraft.world.World;

public class GeneticsManager {
    public BreedingSystem beeBreedingSystem;
    public BreedingSystem treeBreedingSystem;
    public BreedingSystem mothBreedingSystem;

    public boolean isSpeciesDiscovered(IAlleleSpecies species, World world, boolean nei) {
        return true;
    }

    public ITreeRoot getTreeRoot() {
        return (ITreeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootTrees");
    }

    public IBeeRoot getBeeRoot() {
        return (IBeeRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootBees");
    }

    public IButterflyRoot getButterflyRoot() {
        return (IButterflyRoot)AlleleManager.alleleRegistry.getSpeciesRoot("rootButterflies");
    }

    public BreedingSystem getSystem(String string) {
        for (BreedingSystem system : BreedingSystem.BREEDING_SYSTEMS.values()) {
            if (!system.getIdent().equals(string)) continue;
            return system;
        }
        return null;
    }

    public BreedingSystem getSystem(ISpeciesRoot root) {
        return this.getSystem(root.getUID());
    }

    public ISpeciesRoot getSpeciesRoot(IAlleleSpecies species) {
        for (ISpeciesRoot root : AlleleManager.alleleRegistry.getSpeciesRoot().values()) {
            if (!root.getKaryotype()[0].getAlleleClass().isInstance(species)) continue;
            return root;
        }
        return null;
    }
}

