/*
 * Decompiled with CFR 0.152.
 */
package binnie.core.genetics;

import binnie.core.Binnie;
import binnie.core.BinnieCore;
import binnie.core.genetics.BreedingMessageHandler;
import binnie.core.genetics.IBreedingMessage;
import binnie.core.language.LocalisedString;
import binnie.core.resource.BinnieIcon;
import forestry.api.core.ForestryEvent;
import forestry.api.genetics.AlleleManager;
import forestry.api.genetics.IAllele;
import forestry.api.genetics.IAlleleSpecies;
import forestry.api.genetics.IBreedingTracker;
import forestry.api.genetics.IChromosomeType;
import forestry.api.genetics.IClassification;
import forestry.api.genetics.IMutation;
import forestry.api.genetics.ISpeciesRoot;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.Icon;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.ForgeSubscribe;

public abstract class BreedingSystem {
    protected BinnieIcon iconUndiscovered;
    protected BinnieIcon iconDiscovered;
    public static final Map<ISpeciesRoot, BreedingSystem> BREEDING_SYSTEMS = new HashMap<ISpeciesRoot, BreedingSystem>();
    LocalisedString descriptor;
    Map<IChromosomeType, LocalisedString> chromosomeNames = new HashMap<IChromosomeType, LocalisedString>();
    LocalisedString[] epitomes = new LocalisedString[7];
    List<IClassification> allBranches = new ArrayList<IClassification>();
    List<IAlleleSpecies> allSpecies = new ArrayList<IAlleleSpecies>();
    List<IMutation> allMutations = new ArrayList<IMutation>();
    Map<IAlleleSpecies, List<IMutation>> resultantMutations = new HashMap<IAlleleSpecies, List<IMutation>>();
    Map<IAlleleSpecies, List<IMutation>> furtherMutations = new HashMap<IAlleleSpecies, List<IMutation>>();
    public float discoveredSpeciesPercentage;
    public int totalSpeciesCount;
    public int discoveredSpeciesCount;
    public int totalSecretCount;
    public int discoveredSecretCount;
    public float discoveredBranchPercentage;
    public int totalBranchCount;
    public int discoveredBranchCount;
    public int totalSecretBranchCount;
    public int discoveredSecretBranchCount;
    String currentEpithet;

    public BreedingSystem() {
        BREEDING_SYSTEMS.put(this.getSpeciesRoot(), this);
        MinecraftForge.EVENT_BUS.register((Object)this);
        this.descriptor = Binnie.Language.register(BinnieCore.instance, this.getSpeciesRoot().getUID() + ".descriptor");
        for (int i = 0; i < 7; ++i) {
            this.epitomes[i] = Binnie.Language.register(BinnieCore.instance, this.getSpeciesRoot().getUID() + ".epitome." + i);
        }
        this.currentEpithet = this.getEpitome(0.0f);
        for (IChromosomeType chromo : this.getSpeciesRoot().getKaryotype()) {
            this.chromosomeNames.put(chromo, Binnie.Language.register(BinnieCore.instance, this.getSpeciesRoot().getUID() + ".chromosome." + ((Enum)chromo).name().toLowerCase()));
        }
    }

    public final String getEpitome(float discoveredPercentage) {
        if (discoveredPercentage == 1.0f) {
            return this.epitomes[6].get();
        }
        if (discoveredPercentage < 0.1f) {
            return this.epitomes[0].get();
        }
        if (discoveredPercentage < 0.3f) {
            return this.epitomes[1].get();
        }
        if (discoveredPercentage < 0.5f) {
            return this.epitomes[2].get();
        }
        if (discoveredPercentage < 0.7f) {
            return this.epitomes[3].get();
        }
        if (discoveredPercentage < 0.9f) {
            return this.epitomes[4].get();
        }
        if (discoveredPercentage < 1.0f) {
            return this.epitomes[5].get();
        }
        return "";
    }

    public abstract ISpeciesRoot getSpeciesRoot();

    public final List<IClassification> getAllBranches() {
        return this.allBranches;
    }

    public final Collection<IAlleleSpecies> getAllSpecies() {
        return this.allSpecies;
    }

    public final Collection<IMutation> getAllMutations() {
        return this.allMutations;
    }

    public void calculateArrays() {
        Collection allAlleles = AlleleManager.alleleRegistry.getRegisteredAlleles().values();
        this.resultantMutations = new HashMap<IAlleleSpecies, List<IMutation>>();
        this.furtherMutations = new HashMap<IAlleleSpecies, List<IMutation>>();
        this.allSpecies = new ArrayList<IAlleleSpecies>();
        for (IAllele species : allAlleles) {
            if (this.getSpeciesRoot().getTemplate(species.getUID()) == null) continue;
            this.resultantMutations.put((IAlleleSpecies)species, new ArrayList());
            this.furtherMutations.put((IAlleleSpecies)species, new ArrayList());
            if (this.isBlacklisted(species)) continue;
            this.allSpecies.add((IAlleleSpecies)species);
        }
        this.allMutations = new ArrayList<IMutation>();
        Collection allRegBranches = AlleleManager.alleleRegistry.getRegisteredClassifications().values();
        this.allBranches = new ArrayList<IClassification>();
        for (IClassification branch : allRegBranches) {
            if (branch.getMemberSpecies().length <= 0 || this.getSpeciesRoot().getTemplate(branch.getMemberSpecies()[0].getUID()) == null) continue;
            boolean possible = false;
            for (IAlleleSpecies species : branch.getMemberSpecies()) {
                if (!this.allSpecies.contains(species)) continue;
                possible = true;
            }
            if (!possible) continue;
            this.allBranches.add(branch);
        }
        if (this.getSpeciesRoot().getMutations(false) != null) {
            for (IMutation mutation : this.getSpeciesRoot().getMutations(false)) {
                this.allMutations.add(mutation);
                LinkedHashSet<IAlleleSpecies> participatingSpecies = new LinkedHashSet<IAlleleSpecies>();
                if (mutation.getAllele0() instanceof IAlleleSpecies && this.allSpecies.contains(mutation.getAllele0())) {
                    participatingSpecies.add((IAlleleSpecies)mutation.getAllele0());
                }
                if (mutation.getAllele1() instanceof IAlleleSpecies && this.allSpecies.contains(mutation.getAllele1())) {
                    participatingSpecies.add((IAlleleSpecies)mutation.getAllele1());
                }
                for (IAlleleSpecies species : participatingSpecies) {
                    this.furtherMutations.get(species).add(mutation);
                }
                if (!this.resultantMutations.containsKey(mutation.getTemplate()[0])) continue;
                this.resultantMutations.get(mutation.getTemplate()[0]).add(mutation);
            }
        }
    }

    public final boolean isBlacklisted(IAllele allele) {
        return AlleleManager.alleleRegistry.isBlacklisted(allele.getUID());
    }

    public final List<IMutation> getResultantMutations(IAlleleSpecies species) {
        return this.resultantMutations.get(species);
    }

    public final List<IMutation> getFurtherMutations(IAlleleSpecies species) {
        return this.furtherMutations.get(species);
    }

    public final boolean isMutationDiscovered(IMutation mutation, World world, String name) {
        return this.isMutationDiscovered(mutation, this.getSpeciesRoot().getBreedingTracker(world, name));
    }

    public final boolean isMutationDiscovered(IMutation mutation, IBreedingTracker tracker) {
        if (tracker == null) {
            return true;
        }
        return tracker.isDiscovered(mutation);
    }

    public final boolean isSpeciesDiscovered(IAlleleSpecies species, World world, String name) {
        return this.isSpeciesDiscovered(species, this.getSpeciesRoot().getBreedingTracker(world, name));
    }

    public final boolean isSpeciesDiscovered(IAlleleSpecies species, IBreedingTracker tracker) {
        if (tracker == null) {
            return true;
        }
        return tracker.isDiscovered(species);
    }

    public final boolean isSecret(IAlleleSpecies species) {
        return !species.isCounted();
    }

    public final boolean isSecret(IClassification branch) {
        for (IAlleleSpecies species : branch.getMemberSpecies()) {
            if (this.isSecret(species)) continue;
            return false;
        }
        return true;
    }

    public final Collection<IClassification> getDiscoveredBranches(World world, String player) {
        ArrayList<IClassification> branches = new ArrayList<IClassification>();
        for (IClassification branch : this.getAllBranches()) {
            boolean discovered = false;
            for (IAlleleSpecies species : branch.getMemberSpecies()) {
                if (!this.isSpeciesDiscovered(species, world, player)) continue;
                discovered = true;
            }
            if (!discovered) continue;
            branches.add(branch);
        }
        return branches;
    }

    public final Collection<IClassification> getDiscoveredBranches(IBreedingTracker tracker) {
        ArrayList<IClassification> branches = new ArrayList<IClassification>();
        for (IClassification branch : this.getAllBranches()) {
            boolean discovered = false;
            for (IAlleleSpecies species : branch.getMemberSpecies()) {
                if (!this.isSpeciesDiscovered(species, tracker)) continue;
                discovered = true;
            }
            if (!discovered) continue;
            branches.add(branch);
        }
        return branches;
    }

    public final Collection<IAlleleSpecies> getDiscoveredSpecies(World world, String player) {
        ArrayList<IAlleleSpecies> speciesList = new ArrayList<IAlleleSpecies>();
        for (IAlleleSpecies species : this.getAllSpecies()) {
            if (!this.isSpeciesDiscovered(species, world, player)) continue;
            speciesList.add(species);
        }
        return speciesList;
    }

    public final Collection<IAlleleSpecies> getDiscoveredSpecies(IBreedingTracker tracker) {
        ArrayList<IAlleleSpecies> speciesList = new ArrayList<IAlleleSpecies>();
        for (IAlleleSpecies species : this.getAllSpecies()) {
            if (!this.isSpeciesDiscovered(species, tracker)) continue;
            speciesList.add(species);
        }
        return speciesList;
    }

    public final List<IMutation> getDiscoveredMutations(World world, String player) {
        ArrayList<IMutation> speciesList = new ArrayList<IMutation>();
        for (IMutation species : this.getAllMutations()) {
            if (!this.isMutationDiscovered(species, world, player)) continue;
            speciesList.add(species);
        }
        return speciesList;
    }

    public final List<IMutation> getDiscoveredMutations(IBreedingTracker tracker) {
        ArrayList<IMutation> speciesList = new ArrayList<IMutation>();
        for (IMutation species : this.getAllMutations()) {
            if (!this.isMutationDiscovered(species, tracker)) continue;
            speciesList.add(species);
        }
        return speciesList;
    }

    public final int getDiscoveredBranchMembers(IClassification branch, IBreedingTracker tracker) {
        int discoveredSpecies = 0;
        for (IAlleleSpecies species : branch.getMemberSpecies()) {
            if (!this.isSpeciesDiscovered(species, tracker)) continue;
            ++discoveredSpecies;
        }
        return discoveredSpecies;
    }

    public Icon getUndiscoveredIcon() {
        return this.iconUndiscovered.getIcon();
    }

    public Icon getDiscoveredIcon() {
        return this.iconDiscovered.getIcon();
    }

    public abstract float getChance(IMutation var1, EntityPlayer var2, IAllele var3, IAllele var4);

    public abstract Class<? extends IBreedingTracker> getTrackerClass();

    @ForgeSubscribe
    public final void onSyncBreedingTracker(ForestryEvent.SyncedBreedingTracker event) {
        IBreedingTracker tracker = event.tracker;
        if (!this.getTrackerClass().isInstance(tracker)) {
            return;
        }
        this.discoveredSpeciesPercentage = 0.0f;
        this.totalSpeciesCount = 0;
        this.discoveredSpeciesCount = 0;
        this.totalSecretCount = 0;
        this.discoveredSecretCount = 0;
        Collection<IAlleleSpecies> discoveredSpecies = this.getDiscoveredSpecies(tracker);
        Collection<IAlleleSpecies> allSpecies = this.getAllSpecies();
        for (IAlleleSpecies species : allSpecies) {
            if (!this.isSecret(species)) {
                ++this.totalSpeciesCount;
                if (!this.isSpeciesDiscovered(species, tracker)) continue;
                ++this.discoveredSpeciesCount;
                continue;
            }
            ++this.totalSecretCount;
            if (!this.isSpeciesDiscovered(species, tracker)) continue;
            ++this.discoveredSecretCount;
        }
        this.discoveredBranchPercentage = 0.0f;
        this.totalBranchCount = 0;
        this.discoveredBranchCount = 0;
        Collection<IClassification> discoveredBranches = this.getDiscoveredBranches(tracker);
        List<IClassification> allBranches = this.getAllBranches();
        for (IClassification branch : allBranches) {
            if (!this.isSecret(branch)) {
                ++this.totalBranchCount;
                if (!discoveredBranches.contains(branch)) continue;
                ++this.discoveredBranchCount;
                continue;
            }
            ++this.totalSecretBranchCount;
            if (!discoveredBranches.contains(branch)) continue;
            ++this.discoveredSecretBranchCount;
        }
        this.discoveredSpeciesPercentage = (float)this.discoveredSpeciesCount / (float)this.totalSpeciesCount;
        this.discoveredBranchPercentage = (float)this.discoveredBranchCount / (float)this.totalBranchCount;
        String epithet = this.getEpitome();
        if (!epithet.equals(this.currentEpithet)) {
            this.currentEpithet = epithet;
            BreedingMessageHandler.instance.messages.add(new IBreedingMessage.EpithetGained(epithet, this.getSpeciesRoot()));
        }
        this.onSyncBreedingTracker(event.tracker);
    }

    public void onSyncBreedingTracker(IBreedingTracker tracker) {
    }

    public String getEpitome() {
        return this.getEpitome(this.discoveredSpeciesPercentage);
    }

    public final String getDescriptor() {
        return this.descriptor.get();
    }

    public final String getIdent() {
        return this.getSpeciesRoot().getUID();
    }

    public final IChromosomeType getChromosome(int i) {
        for (IChromosomeType chromosome : this.getSpeciesRoot().getKaryotype()) {
            if (i != chromosome.ordinal()) continue;
            return chromosome;
        }
        return null;
    }

    public abstract int getColour();

    public String getAlleleName(IChromosomeType chromosome, IAllele allele) {
        return null;
    }

    public final String getChromosomeName(int i) {
        IChromosomeType chromo = this.getChromosome(i);
        return this.chromosomeNames.get(chromo).get();
    }
}

