/*
 * Decompiled with CFR 0.152.
 */
package denoflionsx.denLib.NewConfig;

import denoflionsx.denLib.Lib.denLib;
import denoflionsx.denLib.Mod.denLibMod;
import denoflionsx.denLib.NewConfig.ConfigField;
import java.io.File;
import java.lang.reflect.Field;
import java.util.ArrayList;
import net.minecraftforge.common.Configuration;
import net.minecraftforge.common.Property;

public class DenConfig {
    public Configuration setup(File origin, File configFile) {
        return this.setup(origin, configFile, null);
    }

    public Configuration setup(File origin, File configFile, String modID) {
        Configuration config = new Configuration(configFile);
        try {
            ArrayList<Field> fields = denLib.FileUtils.findFieldsInJarWithAnnotation(origin, ConfigField.class);
            for (Field f : fields) {
                f.setAccessible(true);
                ConfigField anno = f.getAnnotation(ConfigField.class);
                denLibMod.log("Found ConfigField " + f.getName());
                this.getAndSet(anno, f, config);
            }
        }
        catch (Throwable t) {
            // empty catch block
        }
        return config;
    }

    private void getAndSet(ConfigField annotation, Field f, Configuration config) {
        Object o = null;
        Property p = null;
        boolean isBlock = annotation.category().contains("block.");
        try {
            o = f.get(null);
            if (f.getType().equals(Integer.TYPE)) {
                p = isBlock ? config.getBlock(annotation.category(), f.getName(), ((Integer)o).intValue()) : config.get(annotation.category(), f.getName(), ((Integer)o).intValue());
                f.set(null, p.getInt());
            } else if (f.getType().equals(String.class)) {
                p = config.get(annotation.category(), f.getName(), (String)o);
                f.set(null, p.getString());
            } else if (f.getType().equals(Float.TYPE)) {
                p = config.get(annotation.category(), f.getName(), String.valueOf((Float)o));
                f.set(null, Float.valueOf(p.getString()));
            } else if (f.getType().equals(String[].class)) {
                p = config.get(annotation.category(), f.getName(), (String[])o);
                f.set(null, p.getStringList());
            } else if (f.getType().equals(Boolean.TYPE)) {
                p = config.get(annotation.category(), f.getName(), ((Boolean)o).booleanValue());
                f.set(null, p.getBoolean(((Boolean)o).booleanValue()));
            }
            if (!annotation.comment().equals("Tunable Values")) {
                p.comment = annotation.comment();
            }
            config.save();
        }
        catch (Throwable t) {
            t.printStackTrace();
        }
    }
}

