/*
 * Decompiled with CFR 0.152.
 */
package mariculture.plugins.nei;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.RecipeVat;
import mariculture.core.gui.feature.FeatureTank;
import mariculture.core.helpers.OreDicHelper;
import mariculture.core.helpers.cofh.StringHelper;
import mariculture.plugins.nei.NEIBase;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class NEIVatRecipeHandler
extends NEIBase {
    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        boolean isSecondSearch = this.isSecondSearch(outputId, results);
        if ((outputId.equals("vat") || isSecondSearch) && ((Object)((Object)this)).getClass() == NEIVatRecipeHandler.class) {
            HashMap<List<? extends Object>, RecipeVat> recipes = MaricultureHandlers.vat.getRecipes();
            for (Map.Entry<List<? extends Object>, RecipeVat> recipe : recipes.entrySet()) {
                FluidStack fluid = recipe.getValue().outputFluid;
                if (isSecondSearch && (!isSecondSearch || fluid == null || fluid.getFluid() == null || !fluid.getFluid().getName().equals(results[1]))) continue;
                this.arecipes.add(new CachedVatRecipe(recipe.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public boolean isEqual(FluidStack fluid1, FluidStack fluid2, String fluid) {
        if (fluid1 != null && fluid1.getFluid() != null && fluid1.getFluid().getName().equals(fluid)) {
            return true;
        }
        return fluid2 != null && fluid2.getFluid() != null && fluid2.getFluid().getName().equals(fluid);
    }

    @Override
    public void loadUsageRecipes(String inputId, Object ... ingredients) {
        boolean isSecondSearch = this.isSecondSearch(inputId, ingredients);
        if ((inputId.equals("vat") || isSecondSearch) && ((Object)((Object)this)).getClass() == NEIVatRecipeHandler.class) {
            HashMap<List<? extends Object>, RecipeVat> recipes = MaricultureHandlers.vat.getRecipes();
            for (Map.Entry<List<? extends Object>, RecipeVat> recipe : recipes.entrySet()) {
                if (isSecondSearch && (!isSecondSearch || !this.isEqual(recipe.getValue().inputFluid1, recipe.getValue().inputFluid2, (String)ingredients[1]))) continue;
                this.arecipes.add(new CachedVatRecipe(recipe.getValue()));
            }
        } else {
            super.loadUsageRecipes(inputId, ingredients);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        HashMap<List<? extends Object>, RecipeVat> recipes = MaricultureHandlers.vat.getRecipes();
        for (Map.Entry<List<? extends Object>, RecipeVat> recipe : recipes.entrySet()) {
            FluidStack fluid;
            if (recipe.getValue().outputItem != null) {
                ItemStack item = recipe.getValue().outputItem;
                if (OreDicHelper.convert(result).equals(OreDicHelper.convert(item))) {
                    this.arecipes.add(new CachedVatRecipe(recipe.getValue()));
                }
            }
            if ((fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)result)) == null || fluid.getFluid() == null || recipe.getValue().outputFluid == null || !fluid.getFluid().getName().equals(recipe.getValue().outputFluid.getFluid().getName())) continue;
            this.arecipes.add(new CachedVatRecipe(recipe.getValue()));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        HashMap<List<? extends Object>, RecipeVat> recipes = MaricultureHandlers.vat.getRecipes();
        for (Map.Entry<List<? extends Object>, RecipeVat> recipe : recipes.entrySet()) {
            FluidStack fluid;
            RecipeVat vat = recipe.getValue();
            if (vat.inputItem != null && OreDicHelper.convert(ingredient).equals(OreDicHelper.convert(vat.inputItem))) {
                this.arecipes.add(new CachedVatRecipe(recipe.getValue()));
            }
            if ((fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)ingredient)) == null) continue;
            if (vat.inputFluid1 != null && fluid.getFluid().getName().equals(recipe.getValue().inputFluid1.getFluid().getName())) {
                this.arecipes.add(new CachedVatRecipe(recipe.getValue()));
            }
            if (vat.inputFluid2 == null || !fluid.getFluid().getName().equals(recipe.getValue().inputFluid2.getFluid().getName())) continue;
            this.arecipes.add(new CachedVatRecipe(recipe.getValue()));
        }
    }

    public void drawExtras(int id) {
        int time;
        CachedVatRecipe cache = (CachedVatRecipe)((Object)this.arecipes.get(id));
        RecipeVat recipe = cache.recipe;
        if (recipe.inputFluid1 != null) {
            this.drawFluidRect(13, 30, recipe.inputFluid1, FeatureTank.TankSize.VAT);
            if (recipe.inputFluid2 == null) {
                this.drawFluidRect(36, 30, recipe.inputFluid1, FeatureTank.TankSize.VAT);
            } else {
                this.drawFluidRect(36, 30, recipe.inputFluid2, FeatureTank.TankSize.VAT);
            }
        }
        if (recipe.outputFluid != null) {
            this.drawFluidRect(106, 30, recipe.outputFluid, FeatureTank.TankSize.VAT);
            this.drawFluidRect(129, 30, recipe.outputFluid, FeatureTank.TankSize.VAT);
        }
        int x = (time = recipe.processTime) < 10 ? 76 : 72;
        Minecraft.func_71410_x().field_71466_p.func_78276_b("\u00a77" + time + "s", x, 16, 0);
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int id) {
        int xEnd;
        currenttip = super.handleTooltip(gui, currenttip, id);
        Point mouse = this.getMouse(this.getGuiWidth(gui), this.getGuiHeight(gui));
        if (this.isOverItem(gui, id)) {
            return currenttip;
        }
        RecipeVat recipe = ((CachedVatRecipe)((Object)this.arecipes.get((int)id))).recipe;
        String fluid = null;
        String fluid2 = null;
        String fluid3 = null;
        if (recipe.inputFluid1 != null) {
            fluid = StringHelper.getFluidName(recipe.inputFluid1.getFluid());
        }
        if (recipe.inputFluid2 != null) {
            fluid2 = StringHelper.getFluidName(recipe.inputFluid2.getFluid());
        }
        if (recipe.outputFluid != null) {
            fluid3 = StringHelper.getFluidName(recipe.outputFluid.getFluid());
        }
        int yLow = id % 2 == 0 ? 19 : 85;
        int yHigh = id % 2 == 0 ? 63 : 128;
        int n = xEnd = recipe.inputFluid2 == null ? 64 : 40;
        if (fluid != null) {
            if (mouse.x >= 16 && mouse.x <= xEnd && mouse.y >= yLow && mouse.y <= yHigh) {
                currenttip.add(fluid);
                StringHelper.getFluidQty(currenttip, recipe.inputFluid1, -1);
            }
            if (fluid2 != null && mouse.x > xEnd && mouse.x <= 64 && mouse.y >= yLow && mouse.y <= yHigh) {
                currenttip.add(fluid2);
                StringHelper.getFluidQty(currenttip, recipe.inputFluid2, -1);
            }
        }
        if (fluid3 != null && mouse.x > 109 && mouse.x <= 157 && mouse.y >= yLow && mouse.y <= yHigh) {
            currenttip.add(fluid3);
            StringHelper.getFluidQty(currenttip, recipe.outputFluid, -1);
        }
        return currenttip;
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int id) {
        int xEnd;
        super.mouseClicked(gui, button, id);
        Point mouse = this.getMouse(this.getGuiWidth(gui), this.getGuiHeight(gui));
        if (this.isOverItem(gui, id)) {
            return false;
        }
        RecipeVat recipe = ((CachedVatRecipe)((Object)this.arecipes.get((int)id))).recipe;
        int yLow = id % 2 == 0 ? 19 : 85;
        int yHigh = id % 2 == 0 ? 63 : 128;
        int n = xEnd = recipe.inputFluid2 == null ? 64 : 40;
        if (recipe.inputFluid1 != null) {
            FluidStack fluid;
            if (mouse.x >= 16 && mouse.x <= xEnd && mouse.y >= yLow && mouse.y <= yHigh) {
                this.loadFluidsButton(button, recipe.inputFluid1);
            }
            FluidStack fluidStack = fluid = recipe.inputFluid2 == null ? recipe.inputFluid1 : recipe.inputFluid2;
            if (mouse.x > xEnd && mouse.x <= 64 && mouse.y >= yLow && mouse.y <= yHigh) {
                this.loadFluidsButton(button, fluid);
            }
        }
        if (recipe.outputFluid != null && mouse.x > 109 && mouse.x <= 157 && mouse.y >= yLow && mouse.y <= yHigh) {
            this.loadFluidsButton(button, recipe.outputFluid);
        }
        return false;
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int id) {
        int xEnd;
        super.keyTyped(gui, keyChar, keyCode, id);
        Point mouse = this.getMouse(this.getGuiWidth(gui), this.getGuiHeight(gui));
        if (this.isOverItem(gui, id)) {
            return false;
        }
        RecipeVat recipe = ((CachedVatRecipe)((Object)this.arecipes.get((int)id))).recipe;
        int yLow = id % 2 == 0 ? 19 : 85;
        int yHigh = id % 2 == 0 ? 63 : 128;
        int n = xEnd = recipe.inputFluid2 == null ? 64 : 40;
        if (recipe.inputFluid1 != null) {
            FluidStack fluid;
            if (mouse.x >= 16 && mouse.x <= xEnd && mouse.y >= yLow && mouse.y <= yHigh) {
                this.loadFluidsKey(keyCode, recipe.inputFluid1);
            }
            FluidStack fluidStack = fluid = recipe.inputFluid2 == null ? recipe.inputFluid1 : recipe.inputFluid2;
            if (mouse.x > xEnd && mouse.x <= 64 && mouse.y >= yLow && mouse.y <= yHigh) {
                this.loadFluidsKey(keyCode, fluid);
            }
        }
        if (recipe.outputFluid != null && mouse.x > 109 && mouse.x <= 157 && mouse.y >= yLow && mouse.y <= yHigh) {
            this.loadFluidsKey(keyCode, recipe.outputFluid);
        }
        return false;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(72, 26, 22, 16), "vat", new Object[0]));
    }

    public String getRecipeName() {
        return "Vat";
    }

    public String getGuiTexture() {
        return new ResourceLocation("mariculture", "textures/gui/nei/vat.png").toString();
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)15, (int)166, (int)73);
        this.drawExtras(recipe);
    }

    public void drawForeground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GL11.glDisable((int)2896);
        GuiDraw.changeTexture((String)this.getGuiTexture());
    }

    public String getOverlayIdentifier() {
        return "vat";
    }

    @Override
    public boolean isOverItem(GuiRecipe gui, int id) {
        CachedVatRecipe cache = (CachedVatRecipe)((Object)this.arecipes.get(id));
        return cache.input != null && gui.isMouseOver(cache.input, id) || cache.output != null && gui.isMouseOver(cache.output, id);
    }

    public class CachedVatRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        RecipeVat recipe;
        PositionedStack input;
        PositionedStack output;

        public CachedVatRecipe(RecipeVat recipe) {
            super((TemplateRecipeHandler)NEIVatRecipeHandler.this);
            if (recipe.inputItem != null) {
                this.input = new PositionedStack((Object)recipe.inputItem.func_77946_l(), 28, 17);
            }
            if (recipe.outputItem != null) {
                this.output = new PositionedStack((Object)recipe.outputItem.func_77946_l(), 121, 17);
            }
            this.recipe = recipe;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public PositionedStack getIngredient() {
            return this.input;
        }
    }
}

