/*
 * Decompiled with CFR 0.152.
 */
package mariculture.plugins.nei;

import codechicken.core.gui.GuiDraw;
import codechicken.nei.ItemList;
import codechicken.nei.NEIClientUtils;
import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Point;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import mariculture.api.core.FuelInfo;
import mariculture.api.core.MaricultureHandlers;
import mariculture.api.core.RecipeSmelter;
import mariculture.core.gui.GuiLiquifier;
import mariculture.core.gui.feature.FeatureTank;
import mariculture.core.helpers.OreDicHelper;
import mariculture.core.helpers.cofh.ItemHelper;
import mariculture.core.helpers.cofh.StringHelper;
import mariculture.core.util.Rand;
import mariculture.plugins.nei.NEIBase;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidContainerRegistry;
import net.minecraftforge.fluids.FluidStack;
import org.lwjgl.opengl.GL11;

public class NEILiquifierRecipeHandler
extends NEIBase {
    public static ArrayList<LiquifierFuel> afuels;
    public int aFluid = -1;

    public Class<? extends GuiContainer> getGuiClass() {
        return GuiLiquifier.class;
    }

    public TemplateRecipeHandler newInstance() {
        this.checkAndFixFuels();
        return super.newInstance();
    }

    private boolean checkAndFixFuels() {
        if (afuels == null || afuels.size() < 1) {
            return NEILiquifierRecipeHandler.findFuels();
        }
        return true;
    }

    private static boolean findFuels() {
        afuels = new ArrayList();
        for (ItemStack item : ItemList.items) {
            FluidStack fluid;
            FuelInfo info = MaricultureHandlers.smelter.getFuelInfo(item);
            if (info != null) {
                afuels.add(new LiquifierFuel(item.func_77946_l(), info));
            }
            if ((fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)item)) == null || fluid.getFluid() == null || (info = MaricultureHandlers.smelter.getFuelInfo(fluid)) == null) continue;
            afuels.add(new LiquifierFuel(item.func_77946_l(), info));
        }
        return afuels != null && afuels.size() > 0;
    }

    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        boolean isSecondSearch = this.isSecondSearch(outputId, results);
        if ((outputId.equals("liquifier") || isSecondSearch) && ((Object)((Object)this)).getClass() == NEILiquifierRecipeHandler.class) {
            HashMap<String, RecipeSmelter> recipes = MaricultureHandlers.smelter.getRecipes();
            for (Map.Entry<String, RecipeSmelter> recipe : recipes.entrySet()) {
                if (isSecondSearch && (!isSecondSearch || !recipe.getValue().fluid.getFluid().getName().equals(results[1]))) continue;
                this.arecipes.add(new CachedLiquifierRecipe(recipe.getValue()));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        HashMap<String, RecipeSmelter> recipes = MaricultureHandlers.smelter.getRecipes();
        for (Map.Entry<String, RecipeSmelter> recipe : recipes.entrySet()) {
            FluidStack fluid;
            ItemStack item = recipe.getValue().output;
            if (OreDicHelper.convert(result).equals(OreDicHelper.convert(item))) {
                this.arecipes.add(new CachedLiquifierRecipe(recipe.getValue()));
            }
            if ((fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)result)) == null || fluid.getFluid() == null || recipe.getValue().fluid == null || !fluid.getFluid().getName().equals(recipe.getValue().fluid.getFluid().getName())) continue;
            this.arecipes.add(new CachedLiquifierRecipe(recipe.getValue()));
        }
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        HashMap<String, RecipeSmelter> recipes = MaricultureHandlers.smelter.getRecipes();
        for (Map.Entry<String, RecipeSmelter> recipe : recipes.entrySet()) {
            ItemStack item = recipe.getValue().input;
            if (OreDicHelper.convert(ingredient).equals(OreDicHelper.convert(item))) {
                this.arecipes.add(new CachedLiquifierRecipe(recipe.getValue()));
            }
            if ((item = recipe.getValue().input2) == null || !OreDicHelper.convert(ingredient).equals(OreDicHelper.convert(item))) continue;
            this.arecipes.add(new CachedLiquifierRecipe(recipe.getValue()));
        }
    }

    public void drawExtras(int id) {
        CachedLiquifierRecipe recipe = (CachedLiquifierRecipe)((Object)this.arecipes.get(id));
        int temp = recipe.recipe.temp * 60 / 2000;
        GuiDraw.drawTexturedModalRect((int)7, (int)(63 - temp), (int)251, (int)(60 - temp), (int)5, (int)temp);
        if (recipe.recipe.fluid != null) {
            if (recipe.recipe.random != null) {
                if (this.cycleticks % 64 == 0 || this.aFluid == -1) {
                    this.aFluid = Rand.rand.nextInt(recipe.recipe.random.length);
                }
                if (this.aFluid >= recipe.recipe.random.length) {
                    this.aFluid = 0;
                }
                FluidStack fluid = recipe.recipe.random[this.aFluid];
                this.drawFluidRect(93, 46, fluid, FeatureTank.TankSize.DOUBLE);
            } else {
                this.drawFluidRect(93, 46, recipe.recipe.fluid, FeatureTank.TankSize.DOUBLE);
            }
        }
        if (recipe.recipe.output != null) {
            int chance = (int)(1.0f / (float)recipe.recipe.chance * 100.0f);
            int x = chance < 10 ? 143 : 139;
            Minecraft.func_71410_x().field_71466_p.func_78276_b("\u00a77" + chance + "%", x, 44, 0);
        }
    }

    public List<String> handleItemTooltip(GuiRecipe gui, ItemStack stack, List<String> currenttip, int id) {
        if (stack != null) {
            CachedLiquifierRecipe cache = (CachedLiquifierRecipe)((Object)this.arecipes.get(id));
            RecipeSmelter recipe = cache.recipe;
            if (cache.output != null && gui.isMouseOver(cache.output, id) && recipe.output != null && ItemHelper.areItemStacksEqualNoNBT(stack, recipe.output)) {
                int chance = (int)(1.0f / (float)recipe.chance * 100.0f);
                currenttip.add("\u00a77" + chance + StatCollector.func_74838_a((String)"mariculture.string.percent") + stack.func_82833_r());
            }
            if (cache.recipe.input != null && gui.isMouseOver(cache.input1, id)) {
                currenttip.add("\u00a76" + StatCollector.func_74838_a((String)"mariculture.string.melting") + ": " + cache.recipe.temp + "\u00b0" + "C");
            }
            if (cache.recipe.input2 != null && gui.isMouseOver(cache.input2, id)) {
                currenttip.add("\u00a76" + StatCollector.func_74838_a((String)"mariculture.string.melting") + ": " + cache.recipe.temp + "\u00b0" + "C");
            }
            if (id % 2 == 0) {
                FuelInfo info = MaricultureHandlers.smelter.getFuelInfo(stack);
                if (FluidContainerRegistry.isFilledContainer((ItemStack)stack)) {
                    FluidStack fluid = FluidContainerRegistry.getFluidForFilledItem((ItemStack)stack);
                    info = MaricultureHandlers.smelter.getFuelInfo(fluid);
                }
                if (info != null) {
                    if (FluidContainerRegistry.isFilledContainer((ItemStack)stack)) {
                        currenttip.add("\u00a73" + StatCollector.func_74838_a((String)"mariculture.string.asFluid"));
                        currenttip.add("\u00a7f" + StatCollector.func_74838_a((String)"mariculture.string.perTempFluid") + ": " + info.maxTempPer + "\u00b0" + "C");
                    } else {
                        currenttip.add("\u00a72" + StatCollector.func_74838_a((String)"mariculture.string.asSolid"));
                        currenttip.add("\u00a7f" + StatCollector.func_74838_a((String)"mariculture.string.perTempSolid") + ": " + info.maxTempPer + "\u00b0" + "C");
                    }
                    currenttip.add("\u00a77" + StatCollector.func_74838_a((String)"mariculture.string.maxTemp") + ": " + info.maxTemp + "\u00b0" + "C");
                }
            }
        }
        return currenttip;
    }

    public List<String> handleTooltip(GuiRecipe gui, List<String> currenttip, int id) {
        currenttip = super.handleTooltip(gui, currenttip, id);
        Point mouse = this.getMouse(this.getGuiWidth(gui), this.getGuiHeight(gui));
        if (this.isOverItem(gui, id)) {
            return currenttip;
        }
        RecipeSmelter recipe = ((CachedLiquifierRecipe)((Object)this.arecipes.get((int)id))).recipe;
        int yLow = id % 2 == 0 ? 19 : 84;
        int yHigh = id % 2 == 0 ? 79 : 144;
        String fluid = null;
        if (recipe.fluid != null && recipe.fluid.amount > 0) {
            if (recipe.rands != null && this.aFluid < recipe.random.length) {
                FluidStack someFluid = recipe.random[this.aFluid];
                fluid = StringHelper.getFluidName(someFluid);
            } else {
                fluid = StringHelper.getFluidName(recipe.fluid.getFluid());
            }
        }
        if (mouse.x >= 97 && mouse.x <= 132 && mouse.y >= yLow && mouse.y <= yHigh) {
            currenttip.add(fluid);
            if (fluid != null) {
                if (recipe.rands != null && this.aFluid < recipe.random.length) {
                    StringHelper.getFluidQty(currenttip, recipe.random[this.aFluid], -1);
                } else {
                    StringHelper.getFluidQty(currenttip, recipe.fluid, -1);
                }
            }
        }
        if (mouse.x >= 12 && mouse.x <= 16 && mouse.y >= yLow && mouse.y <= yHigh) {
            currenttip.add(recipe.temp + "\u00b0" + "C");
        }
        return currenttip;
    }

    public boolean mouseClicked(GuiRecipe gui, int button, int id) {
        int yHigh;
        super.mouseClicked(gui, button, id);
        Point mouse = this.getMouse(this.getGuiWidth(gui), this.getGuiHeight(gui));
        if (this.isOverItem(gui, id)) {
            return false;
        }
        RecipeSmelter recipe = ((CachedLiquifierRecipe)((Object)this.arecipes.get((int)id))).recipe;
        int yLow = id % 2 == 0 ? 19 : 84;
        int n = yHigh = id % 2 == 0 ? 79 : 144;
        if (recipe.fluid != null && mouse.x >= 97 && mouse.x <= 132 && mouse.y >= yLow && mouse.y <= yHigh) {
            this.loadFluidsButton(button, recipe.fluid);
        }
        return false;
    }

    public boolean keyTyped(GuiRecipe gui, char keyChar, int keyCode, int id) {
        int yHigh;
        super.keyTyped(gui, keyChar, keyCode, id);
        Point mouse = this.getMouse(this.getGuiWidth(gui), this.getGuiHeight(gui));
        if (this.isOverItem(gui, id)) {
            return false;
        }
        RecipeSmelter recipe = ((CachedLiquifierRecipe)((Object)this.arecipes.get((int)id))).recipe;
        int yLow = id % 2 == 0 ? 19 : 84;
        int n = yHigh = id % 2 == 0 ? 79 : 144;
        if (recipe.fluid != null && mouse.x >= 97 && mouse.x <= 132 && mouse.y >= yLow && mouse.y <= yHigh) {
            this.loadFluidsKey(keyCode, recipe.fluid);
        }
        return false;
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(60, 27, 22, 16), "liquifier", new Object[0]));
    }

    public String getRecipeName() {
        return "Crucible Furnace";
    }

    public String getGuiTexture() {
        return new ResourceLocation("mariculture", "textures/gui/nei/liquifier.png").toString();
    }

    public void drawBackground(int recipe) {
        GL11.glColor4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GuiDraw.changeTexture((String)this.getGuiTexture());
        GuiDraw.drawTexturedModalRect((int)0, (int)0, (int)5, (int)15, (int)166, (int)73);
    }

    public String getOverlayIdentifier() {
        return "liquifier";
    }

    @Override
    public boolean isOverItem(GuiRecipe gui, int id) {
        return false;
    }

    public static class LiquifierFuel {
        public PositionedStack stack;
        public FuelInfo info;

        public LiquifierFuel(ItemStack ingred, FuelInfo info) {
            this.stack = new PositionedStack((Object)ingred, 33, 44, false);
            this.info = info;
        }
    }

    public class CachedLiquifierRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        RecipeSmelter recipe;
        PositionedStack input1;
        PositionedStack input2;
        PositionedStack output;

        public CachedLiquifierRecipe(RecipeSmelter recipe) {
            super((TemplateRecipeHandler)NEILiquifierRecipeHandler.this);
            this.input1 = new PositionedStack((Object)recipe.input.func_77946_l(), 24, 6);
            if (recipe.input2 != null) {
                this.input2 = new PositionedStack((Object)recipe.input2.func_77946_l(), 42, 6);
            }
            if (recipe.output != null) {
                this.output = new PositionedStack((Object)recipe.output.func_77946_l(), 140, 25);
            }
            this.recipe = recipe;
        }

        public PositionedStack getResult() {
            return this.output;
        }

        public List<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            stacks.add(this.getIngredient());
            if (this.input2 != null) {
                stacks.add(this.getComboIngredient());
            }
            return stacks;
        }

        public PositionedStack getIngredient() {
            int cycle = NEILiquifierRecipeHandler.this.cycleticks / 48;
            if (this.input1.item.func_77960_j() == -1) {
                PositionedStack stack = this.input1.copy();
                int maxDamage = 0;
                do {
                    stack.item.func_77964_b(++maxDamage);
                } while (NEIClientUtils.isValidItem((ItemStack)stack.item));
                stack.item.func_77964_b(cycle % maxDamage);
                return stack;
            }
            return this.input1;
        }

        public PositionedStack getComboIngredient() {
            int cycle = NEILiquifierRecipeHandler.this.cycleticks / 48;
            if (this.input2.item.func_77960_j() == -1) {
                PositionedStack stack = this.input2.copy();
                int maxDamage = 0;
                do {
                    stack.item.func_77964_b(++maxDamage);
                } while (NEIClientUtils.isValidItem((ItemStack)stack.item));
                stack.item.func_77964_b(cycle % maxDamage);
                return stack;
            }
            return this.input2;
        }

        public PositionedStack getOtherStack() {
            if (NEILiquifierRecipeHandler.this.checkAndFixFuels()) {
                return NEILiquifierRecipeHandler.afuels.get((int)(NEILiquifierRecipeHandler.this.cycleticks / 64 % NEILiquifierRecipeHandler.afuels.size())).stack;
            }
            return new PositionedStack((Object)new ItemStack(Item.field_77705_m, 1, 0), 33, 44, false);
        }
    }
}

