/*
 * Decompiled with CFR 0.152.
 */
package mariculture.plugins.nei;

import codechicken.nei.PositionedStack;
import codechicken.nei.recipe.GuiRecipe;
import codechicken.nei.recipe.TemplateRecipeHandler;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.List;
import mariculture.api.fishery.Fishing;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.fishery.Fish;
import mariculture.fishery.FishHelper;
import mariculture.fishery.FishMutationHandler;
import mariculture.fishery.items.ItemFishy;
import mariculture.plugins.nei.NEIBase;
import net.minecraft.client.Minecraft;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;

public class NEIFishBreedingMutationHandler
extends NEIBase {
    @Override
    public void loadCraftingRecipes(String outputId, Object ... results) {
        if (outputId.equals("fishbreeding") && ((Object)((Object)this)).getClass() == NEIFishBreedingMutationHandler.class) {
            ArrayList<FishMutationHandler.Mutation> mutations = Fishing.mutation.getMutations();
            for (FishMutationHandler.Mutation mute : mutations) {
                ItemStack baby = Fishing.fishHelper.makePureFish(Fishing.fishHelper.getSpecies(mute.baby));
                ItemStack father = Fish.gender.addDNA(Fishing.fishHelper.makePureFish(Fishing.fishHelper.getSpecies(mute.father)), FishHelper.MALE);
                ItemStack mother = Fish.gender.addDNA(Fishing.fishHelper.makePureFish(Fishing.fishHelper.getSpecies(mute.mother)), FishHelper.FEMALE);
                this.arecipes.add(new CachedBreedingRecipe(mother, father, baby, mute.chance));
            }
        } else {
            super.loadCraftingRecipes(outputId, results);
        }
    }

    public void loadCraftingRecipes(ItemStack result) {
        ArrayList<FishMutationHandler.Mutation> mutations = Fishing.mutation.getMutations();
        for (FishMutationHandler.Mutation mute : mutations) {
            FishSpecies species = Fishing.fishHelper.getSpecies(mute.baby);
            if (!NEIFishBreedingMutationHandler.isSpecies(result, species, true)) continue;
            ItemStack baby = Fishing.fishHelper.makePureFish(Fishing.fishHelper.getSpecies(mute.baby));
            ItemStack father = Fish.gender.addDNA(Fishing.fishHelper.makePureFish(Fishing.fishHelper.getSpecies(mute.father)), FishHelper.MALE);
            ItemStack mother = Fish.gender.addDNA(Fishing.fishHelper.makePureFish(Fishing.fishHelper.getSpecies(mute.mother)), FishHelper.FEMALE);
            this.arecipes.add(new CachedBreedingRecipe(mother, father, baby, mute.chance));
        }
    }

    public static boolean isSpecies(ItemStack stack, FishSpecies fish, boolean checkSecondary) {
        FishSpecies active = Fishing.fishHelper.getSpecies(Fish.species.getDNA(stack));
        if (!checkSecondary) {
            return fish == active;
        }
        FishSpecies inactive = Fishing.fishHelper.getSpecies(Fish.species.getLowerDNA(stack));
        return active == fish || inactive == fish;
    }

    public void loadUsageRecipes(ItemStack ingredient) {
        if (!(ingredient.func_77973_b() instanceof ItemFishy)) {
            return;
        }
        ArrayList<FishMutationHandler.Mutation> mutations = Fishing.mutation.getMutations();
        for (FishMutationHandler.Mutation mute : mutations) {
            FishSpecies fSpecies = Fishing.fishHelper.getSpecies(mute.father);
            FishSpecies mSpecies = Fishing.fishHelper.getSpecies(mute.mother);
            if (!NEIFishBreedingMutationHandler.isSpecies(ingredient, fSpecies, true) && !NEIFishBreedingMutationHandler.isSpecies(ingredient, mSpecies, true)) continue;
            ItemStack baby = Fishing.fishHelper.makePureFish(Fishing.fishHelper.getSpecies(mute.baby));
            ItemStack father = Fish.gender.addDNA(Fishing.fishHelper.makePureFish(Fishing.fishHelper.getSpecies(mute.father)), FishHelper.MALE);
            ItemStack mother = Fish.gender.addDNA(Fishing.fishHelper.makePureFish(Fishing.fishHelper.getSpecies(mute.mother)), FishHelper.FEMALE);
            this.arecipes.add(new CachedBreedingRecipe(mother, father, baby, mute.chance));
        }
    }

    public void drawExtras(int id) {
        CachedBreedingRecipe cache = (CachedBreedingRecipe)((Object)this.arecipes.get(id));
        Minecraft.func_71410_x().field_71466_p.func_78276_b("\u00a77" + cache.chance + "%", 94, 38, 0);
    }

    public void loadTransferRects() {
        this.transferRects.add(new TemplateRecipeHandler.RecipeTransferRect(new Rectangle(95, 16, 22, 16), "fishbreeding", new Object[0]));
    }

    public String getRecipeName() {
        return "Fish Breeding";
    }

    public String getGuiTexture() {
        return new ResourceLocation("mariculture", "textures/gui/nei/breeding.png").toString();
    }

    public String getOverlayIdentifier() {
        return "fishbreeding";
    }

    @Override
    public boolean isOverItem(GuiRecipe gui, int id) {
        return false;
    }

    public class CachedBreedingRecipe
    extends TemplateRecipeHandler.CachedRecipe {
        double chance;
        PositionedStack mother;
        PositionedStack father;
        PositionedStack baby;

        public CachedBreedingRecipe(ItemStack mother, ItemStack father, ItemStack baby, double chance) {
            super((TemplateRecipeHandler)NEIFishBreedingMutationHandler.this);
            this.mother = new PositionedStack((Object)father, 11, 16);
            this.father = new PositionedStack((Object)mother, 67, 16);
            this.baby = new PositionedStack((Object)baby, 133, 16);
            this.chance = chance;
        }

        public PositionedStack getResult() {
            return this.baby;
        }

        public List<PositionedStack> getIngredients() {
            ArrayList<PositionedStack> stacks = new ArrayList<PositionedStack>();
            stacks.add(this.mother);
            stacks.add(this.father);
            return stacks;
        }
    }
}

