/*
 * Decompiled with CFR 0.152.
 */
package mariculture.plugins;

import cpw.mods.fml.common.Loader;
import java.util.ArrayList;
import java.util.logging.Level;
import mariculture.core.handlers.LogHandler;
import mariculture.core.lib.Modules;

public class Plugins
extends Modules.Module {
    public static ArrayList<Plugin> plugins = new ArrayList();

    public Plugins() {
        this.add("Railcraft");
        this.add("TConstruct");
        this.add("Forestry");
        this.add("Thaumcraft");
        this.add("BiomesOPlenty");
        this.add("HungerOverhaul");
        this.add("ThermalExpansion");
        this.add("Enchiridion");
        this.add("AWWayofTime");
        this.add("Waila");
        this.add("Highlands");
    }

    public void add(String str) {
        if (Loader.isModLoaded((String)str)) {
            try {
                Class<?> clazz = Class.forName("mariculture.plugins.Plugin" + str);
                clazz.newInstance();
            }
            catch (Exception e) {
                LogHandler.log(Level.INFO, "Mariculture - Something went wrong when initializing " + str + " Plugin");
            }
        }
    }

    @Override
    public void setLoaded(String str) {
        LogHandler.log(Level.INFO, str + " Plugin Finished Loading");
    }

    @Override
    public void preInit() {
        for (Plugin plug : plugins) {
            plug.load(Plugin.Stage.PRE);
        }
    }

    @Override
    public void init() {
        for (Plugin plug : plugins) {
            plug.load(Plugin.Stage.INIT);
        }
    }

    @Override
    public void postInit() {
        for (Plugin plug : plugins) {
            plug.load(Plugin.Stage.POST);
            String name = plug.name;
            name = name.substring(0, 1).toUpperCase() + name.substring(1);
            this.setLoaded(name);
        }
    }

    public static abstract class Plugin {
        public String name;

        public Plugin(String name) {
            this.name = name;
            plugins.add(this);
        }

        public Plugin() {
            this.name = this.getClass().getSimpleName().toString().substring(6);
            plugins.add(this);
        }

        public void load(Stage stage) {
            try {
                switch (stage) {
                    case PRE: {
                        this.preInit();
                        break;
                    }
                    case INIT: {
                        this.init();
                        break;
                    }
                    case POST: {
                        this.postInit();
                    }
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                LogHandler.log(Level.INFO, "Mariculture - Something went wrong with " + this.name + " Plugin at " + stage.toString() + " Phase");
            }
        }

        public abstract void preInit();

        public abstract void init();

        public abstract void postInit();

        public void registerWildcards() {
        }

        public static enum Stage {
            PRE,
            INIT,
            POST;

        }
    }
}

