/*
 * Decompiled with CFR 0.152.
 */
package mariculture.plugins;

import cpw.mods.fml.common.Optional;
import cpw.mods.fml.common.event.FMLInterModComms;
import forestry.api.core.ItemInterface;
import forestry.api.fuels.EngineBronzeFuel;
import forestry.api.fuels.FermenterFuel;
import forestry.api.fuels.FuelManager;
import forestry.api.recipes.RecipeManagers;
import forestry.api.storage.BackpackManager;
import forestry.api.storage.EnumBackpackType;
import forestry.api.storage.IBackpackDefinition;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import mariculture.api.fishery.fish.FishSpecies;
import mariculture.core.Core;
import mariculture.core.helpers.RecipeHelper;
import mariculture.core.lib.ItemIds;
import mariculture.core.lib.Modules;
import mariculture.core.util.FluidDictionary;
import mariculture.fishery.Fishery;
import mariculture.plugins.Plugins;
import mariculture.world.WorldPlus;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.util.StatCollector;
import net.minecraftforge.fluids.FluidRegistry;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class PluginForestry
extends Plugins.Plugin {
    private static Item aquaBackpackT1;
    private static Item aquaBackpackT2;

    @Override
    public void preInit() {
    }

    public void addBee(String str, int num) {
        ItemStack bee = ItemInterface.getItem((String)str);
        if (bee != null) {
            RecipeHelper.addShapelessRecipe(new ItemStack(Fishery.bait, num, 4), new Object[]{bee});
        }
    }

    @Override
    public void init() {
        if (Modules.isActive(Modules.worldplus)) {
            FuelManager.fermenterFuel.put(new ItemStack(WorldPlus.coral, 1, 0), new FermenterFuel(new ItemStack(WorldPlus.coral, 1, 0), 150, 1));
        }
        if (Modules.isActive(Modules.fishery)) {
            this.addBee("beeDroneGE", 1);
            this.addBee("beePrincessGE", 5);
            this.addBee("beeQueenGE", 7);
            FMLInterModComms.sendMessage((String)"Forestry", (String)"add-backpack-items", (String)String.format("%s@%d:%d", "digger", Core.ores.field_71990_ca, 3));
            if (BackpackManager.backpackInterface != null) {
                AquaBackpack backpack = new AquaBackpack();
                aquaBackpackT1 = BackpackManager.backpackInterface.addBackpack(ItemIds.aquaBPT1, (IBackpackDefinition)backpack, EnumBackpackType.T1);
                aquaBackpackT2 = BackpackManager.backpackInterface.addBackpack(ItemIds.aquaBPT2, (IBackpackDefinition)backpack, EnumBackpackType.T2);
                backpack.setup();
                CraftingManager.func_77594_a().func_77592_b().add(new ShapedOreRecipe(new ItemStack(aquaBackpackT1), new Object[]{"SWS", "FCF", "SWS", Character.valueOf('S'), Item.field_77683_K, Character.valueOf('W'), new ItemStack(Block.field_72101_ab, 1, Short.MAX_VALUE), Character.valueOf('F'), new ItemStack(Fishery.fishyFood, 1, Short.MAX_VALUE), Character.valueOf('C'), Block.field_72077_au}));
                ItemStack silk = ItemInterface.getItem((String)"craftingMaterial");
                silk.func_77964_b(3);
                RecipeManagers.carpenterManager.addRecipe(200, FluidRegistry.getFluidStack((String)"water", (int)1000), null, new ItemStack(aquaBackpackT2), new Object[]{"WDW", "WTW", "WWW", Character.valueOf('D'), Item.field_77702_n, Character.valueOf('W'), silk, Character.valueOf('T'), aquaBackpackT1});
            }
            FuelManager.bronzeEngineFuel.put(FluidRegistry.getFluid((String)FluidDictionary.fish_oil), new EngineBronzeFuel(FluidRegistry.getFluid((String)FluidDictionary.fish_oil), 1, 7500, 1));
            for (Map.Entry<Integer, FishSpecies> species : FishSpecies.species.entrySet()) {
                Integer fishID = species.getKey();
                FishSpecies fish = species.getValue();
                RecipeManagers.squeezerManager.addRecipe(fish.getLifeSpan(), new ItemStack[]{new ItemStack(Fishery.fishyFood, 1, fishID.intValue())}, FluidDictionary.getFluidStack(FluidDictionary.fish_oil, (int)fish.getFishOilVolume() * 1000), fish.getLiquifiedProduct(), fish.getLiquifiedProductChance());
            }
        }
    }

    @Override
    public void postInit() {
    }

    @Optional.Interface(iface="api.storage.IBackpackDefinition", modid="Forestry")
    public class AquaBackpack
    implements IBackpackDefinition {
        private final List items = new ArrayList(50);

        public void setup() {
            if (Modules.isActive(Modules.fishery)) {
                this.addValidItem(new ItemStack(Fishery.fishy, 1, Short.MAX_VALUE));
                this.addValidItem(new ItemStack(Fishery.fishyFood, 1, Short.MAX_VALUE));
                this.addValidItem(new ItemStack(Fishery.bait, 1, Short.MAX_VALUE));
            }
            if (Modules.isActive(Modules.worldplus)) {
                this.addValidItem(new ItemStack(WorldPlus.coral, 1, Short.MAX_VALUE));
            }
            this.addValidItem(new ItemStack(Block.field_71991_bz));
            this.addValidItem(new ItemStack(Item.field_77754_aU));
            this.addValidItem(new ItemStack(Item.field_77756_aW, 1, 0));
            this.addValidItem(new ItemStack(Core.pearls, 1, Short.MAX_VALUE));
            this.addValidItem(new ItemStack(Core.materials, 1, 14));
            this.addValidItem(new ItemStack(Core.oyster));
            for (int i = 0; i < 9; ++i) {
                this.addValidItem(new ItemStack(Core.materials, 1, 18 + i));
            }
        }

        public String getKey() {
            return "AQUA";
        }

        public String getName() {
            return StatCollector.func_74838_a((String)"item.aquaBackpack.name");
        }

        public int getPrimaryColour() {
            return 0x41A4A1;
        }

        public int getSecondaryColour() {
            return 1736058;
        }

        public void addValidItem(ItemStack validItem) {
            if (validItem == null) {
                return;
            }
            this.items.add(validItem);
        }

        public Collection<ItemStack> getValidItems(EntityPlayer player) {
            return this.items;
        }

        public boolean isValidItem(EntityPlayer player, ItemStack itemstack) {
            for (ItemStack stack : this.getValidItems(player)) {
                if (!(stack.func_77960_j() < 0 ? stack.field_77993_c == itemstack.field_77993_c : stack.func_77969_a(itemstack))) continue;
                return true;
            }
            return false;
        }
    }
}

