/*
 * Decompiled with CFR 0.152.
 */
package mariculture.magic.jewelry;

import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.List;
import mariculture.api.core.MaricultureTab;
import mariculture.core.helpers.EnchantHelper;
import mariculture.core.util.IItemRegistry;
import mariculture.magic.Magic;
import mariculture.magic.jewelry.parts.JewelryPart;
import net.minecraft.client.renderer.texture.IconRegister;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Icon;
import net.minecraft.util.StatCollector;
import net.minecraft.world.World;

public class ItemJewelry
extends Item
implements IItemRegistry {
    private Icon[] parts;
    private Icon[] special;
    private Icon blank;

    public ItemJewelry(int id) {
        super(id);
        this.func_77656_e(100);
        this.func_77625_d(1);
        this.func_77637_a(MaricultureTab.tabJewelry);
        this.setNoRepair();
        this.canRepair = false;
    }

    public int func_77619_b() {
        return 1;
    }

    public int getType() {
        return 0;
    }

    public String getTypeString() {
        return "blank";
    }

    public String getPart1() {
        return "blank";
    }

    public String getPart2() {
        return "blank";
    }

    public boolean func_77623_v() {
        return true;
    }

    public int getRenderPasses(int meta) {
        return 3;
    }

    public Icon getIcon(ItemStack stack, int pass) {
        if (stack.func_77942_o()) {
            if (pass == 0) {
                int i = stack.field_77990_d.func_74762_e("Part1");
                if (JewelryPart.materialList.get(i).isValid(this.getType()) && JewelryPart.materialList.get(i).isVisible(this.getType())) {
                    return this.parts[i];
                }
            } else if (pass == 1) {
                int i;
                if (stack.field_77990_d.func_74764_b("Part2") && JewelryPart.materialList.get(i = stack.field_77990_d.func_74762_e("Part2")).isValid(this.getType()) && JewelryPart.materialList.get(i).isVisible(this.getType())) {
                    return this.parts[i];
                }
            } else if (pass == 2 && stack.field_77990_d.func_74764_b("Extra") && stack.field_77990_d.func_74762_e("Extra") < this.special.length) {
                return this.special[stack.field_77990_d.func_74762_e("Extra")];
            }
        }
        return this.blank;
    }

    public int getMaxDamage(ItemStack stack) {
        if (stack.func_77942_o()) {
            int part1 = stack.field_77990_d.func_74762_e("Part1");
            int part2 = stack.field_77990_d.func_74762_e("Part2");
            double modifier = 1.0;
            double base = 100.0;
            if (this.getType() == 0) {
                modifier = JewelryPart.materialList.get(part1).getDurabilityModifier(this.getType());
                base = JewelryPart.materialList.get(part2).getDurabilityBase(this.getType());
            } else {
                base = JewelryPart.materialList.get(part1).getDurabilityBase(this.getType());
                modifier = JewelryPart.materialList.get(part2).getDurabilityModifier(this.getType());
            }
            return (int)(base * modifier);
        }
        return 0;
    }

    public void func_77624_a(ItemStack stack, EntityPlayer player, List list, boolean bool) {
        int id;
        if (stack.func_77942_o() && stack.field_77990_d.func_74764_b("Part2") && JewelryPart.materialList.get(id = stack.field_77990_d.func_74762_e("Part2")) != null) {
            boolean enabled;
            String color = JewelryPart.materialList.get(id).getColor();
            String name = JewelryPart.materialList.get(id).getPartLang();
            list.add(color + StatCollector.func_74838_a((String)"mariculture.string.with") + " " + StatCollector.func_74838_a((String)name));
            int id2 = stack.field_77990_d.func_74762_e("Part1");
            boolean bl = enabled = JewelryPart.materialList.get(id).isEnabled(this.getType()) && JewelryPart.materialList.get(id2).isEnabled(this.getType());
            if (!enabled) {
                list.add("\u00a74" + StatCollector.func_74838_a((String)"mariculture.string.jewelry.disabled"));
            }
        }
        if (EnchantHelper.getLevel(Magic.oneRing, stack) > 0) {
            list.add(StatCollector.func_74838_a((String)"enchantment.oneRing.line1"));
            list.add(StatCollector.func_74838_a((String)"enchantment.oneRing.line2"));
            list.add(StatCollector.func_74838_a((String)"enchantment.oneRing.line3"));
            list.add(StatCollector.func_74838_a((String)"enchantment.oneRing.line4"));
            list.add(" ");
        }
        if (EnchantHelper.getLevel(Magic.clock, stack) > 0) {
            if (stack.field_77990_d.func_74762_e("Extra") == 0) {
                list.add("\u00a72(" + StatCollector.func_74838_a((String)"mariculture.string.keepDay") + ")");
            }
            if (stack.field_77990_d.func_74762_e("Extra") == 1) {
                list.add("\u00a7c(" + StatCollector.func_74838_a((String)"mariculture.string.keepNight") + ")");
            }
        }
    }

    public ItemStack func_77659_a(ItemStack stack, World world, EntityPlayer player) {
        if (stack.func_77942_o() && !world.field_72995_K && EnchantHelper.getLevel(Magic.clock, stack) > 0) {
            if (stack.field_77990_d.func_74762_e("Extra") == 1) {
                stack.field_77990_d.func_74768_a("Extra", 0);
            } else {
                stack.field_77990_d.func_74768_a("Extra", 1);
            }
        }
        return stack;
    }

    public String func_77628_j(ItemStack stack) {
        int id;
        if (stack.func_77942_o() && JewelryPart.materialList.get(id = stack.field_77990_d.func_74762_e("Part1")) != null) {
            String color = JewelryPart.materialList.get(id).getColor();
            String name = JewelryPart.materialList.get(id).getPartLang();
            return color + StatCollector.func_74838_a((String)name) + " " + StatCollector.func_74838_a((String)("part.jewelry." + this.getTypeString()));
        }
        return StatCollector.func_74838_a((String)this.func_77667_c(stack));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_94581_a(IconRegister iconRegister) {
        this.blank = iconRegister.func_94245_a("mariculture:jewelry/blank");
        this.special = new Icon[2];
        this.special[0] = iconRegister.func_94245_a("mariculture:jewelry/day");
        this.special[1] = iconRegister.func_94245_a("mariculture:jewelry/night");
        this.parts = new Icon[JewelryPart.materialList.size()];
        for (int i = 0; i < this.parts.length; ++i) {
            if (!JewelryPart.materialList.get(i).isValid(this.getType()) || !JewelryPart.materialList.get(i).isVisible(this.getType())) continue;
            this.parts[i] = iconRegister.func_94245_a("mariculture:jewelry/" + this.getTypeString() + "/" + JewelryPart.materialList.get(i).getPartType(this.getType()) + "/" + JewelryPart.materialList.get(i).getPartName());
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77633_a(int id, CreativeTabs tab, List list) {
        for (int i = 0; i < JewelryPart.materialList.size(); ++i) {
            boolean added = false;
            for (int j = 0; j < JewelryPart.materialList.size() && !added; ++j) {
                if (!JewelryPart.materialList.get(i).isValid(this.getType()) || !JewelryPart.materialList.get(j).isValid(this.getType()) || !JewelryPart.materialList.get(i).getPartType(this.getType()).equals(this.getPart1()) || !JewelryPart.materialList.get(j).getPartType(this.getType()).equals(this.getPart2())) continue;
                int part1 = i;
                int part2 = j;
                if (JewelryPart.materialList.get(i).isSingle()) {
                    part2 = part1;
                }
                ItemStack stack = ItemJewelry.buildJewelry(id, part1, part2);
                stack = JewelryPart.materialList.get(i).addEnchantments(stack);
                if (i != j) {
                    stack = JewelryPart.materialList.get(j).addEnchantments(stack);
                }
                if (JewelryPart.materialList.get(i).isEnabled(this.getType()) && JewelryPart.materialList.get(j).isEnabled(this.getType())) {
                    list.add(stack);
                }
                added = JewelryPart.materialList.get(i).addOnce();
            }
        }
    }

    public static ItemStack buildJewelry(int id, int part1, int part2) {
        ItemStack stack = new ItemStack(id, 1, 0);
        stack.func_77982_d(new NBTTagCompound());
        stack.field_77990_d.func_74768_a("Part1", part1);
        if (part1 != part2) {
            stack.field_77990_d.func_74768_a("Part2", part2);
        }
        return stack;
    }

    public static int getPieceID(String piece) {
        for (int i = 0; i < JewelryPart.materialList.size(); ++i) {
            JewelryPart part = JewelryPart.materialList.get(i);
            if (!part.getPartName().equals(piece)) continue;
            return i;
        }
        return 0;
    }

    @Override
    public void register() {
    }

    @Override
    public int getMetaCount() {
        return 0;
    }

    @Override
    public String getName(ItemStack stack) {
        return null;
    }
}

