/*
 * Decompiled with CFR 0.152.
 */
package mariculture.magic.enchantments;

import java.util.Random;
import mariculture.core.helpers.EnchantHelper;
import mariculture.core.helpers.KeyHelper;
import mariculture.magic.Magic;
import mariculture.magic.enchantments.EnchantmentJewelry;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.DamageSource;
import net.minecraftforge.event.entity.living.LivingAttackEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;

public class EnchantmentFire
extends EnchantmentJewelry {
    private static int damageTicker;

    public EnchantmentFire(int i, int weight, EnumEnchantmentType type) {
        super(i, weight, type);
        this.func_77322_b("fireResistance");
    }

    public int func_77321_a(int level) {
        return 15 + (level - 1) * 10;
    }

    public int func_77317_b(int level) {
        return this.func_77321_a(level) + 25;
    }

    public int func_77325_b() {
        return 3;
    }

    public static void activate(EntityPlayer player, LivingAttackEvent event) {
        if (EnchantHelper.hasEnchantment(Magic.fire, player) && EnchantHelper.getEnchantStrength(Magic.fire, player) > 2 && player.func_70058_J()) {
            if (++damageTicker >= 100) {
                damageTicker = 0;
                EnchantHelper.damageItems(Magic.fire, player, 1);
            }
            event.setCanceled(true);
        }
    }

    public static void testForFireDamage(LivingHurtEvent event) {
        Random rand = new Random();
        EntityPlayer player = (EntityPlayer)event.entity;
        if (EnchantHelper.hasEnchantment(Magic.fire, player) && (event.source == DamageSource.field_76370_b || event.source == DamageSource.field_76372_a || event.source == DamageSource.field_76371_c) && EnchantHelper.getEnchantStrength(Magic.fire, player) > 2) {
            if (++damageTicker >= 100) {
                damageTicker = 0;
                EnchantHelper.damageItems(Magic.fire, player, 1);
            }
            player.func_70066_B();
            event.setCanceled(true);
        }
    }

    public static void onAttack(EntityPlayer player, Entity target) {
        if (EnchantHelper.hasEnchantment(Magic.fire, player) && target instanceof EntityLivingBase && (player.func_71045_bC() == null || player.func_71045_bC() != null && EnchantHelper.getLevel(Magic.fire, player.func_71045_bC()) > 0)) {
            EntityLivingBase enemy = (EntityLivingBase)target;
            if (!target.func_70027_ad()) {
                EnchantHelper.damageItems(Magic.fire, player, 1);
            }
            player.field_70170_p.func_72956_a((Entity)player, "mariculture:firepunch", 1.0f, 1.0f);
            target.func_70015_d(2 * EnchantHelper.getEnchantStrength(Magic.fire, player));
        }
    }

    public static void onRightClick(EntityPlayer player, Entity target) {
        if (KeyHelper.ACTIVATE_PRESSED && EnchantHelper.hasEnchantment(Magic.fire, player) && target instanceof EntityLivingBase && EnchantHelper.getEnchantStrength(Magic.fire, player) > 1) {
            EntityLivingBase life = (EntityLivingBase)target;
            if (!life.func_70027_ad()) {
                EnchantHelper.damageItems(Magic.fire, player, 1);
            }
            player.field_70170_p.func_72956_a((Entity)player, "mariculture:firepunch", 1.0f, 1.0f);
            life.func_70015_d(EnchantHelper.getEnchantStrength(Magic.fire, player));
        }
    }
}

